/** 
 * Copyright (c) 2009 Parity Communications, Inc.  
 * All rights reserved. This program and the accompanying materials  
 * are made available under the terms of the Eclipse Public License v1.0  
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 *  
 * Contributors: 
 * Alexander Yuhimenko - implementation 
 * 
 */

package org.eclipse.higgins.rpps.web.filter;

import java.io.IOException;
import java.io.PrintWriter;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * @author Alexander Yuhimenko
 * 
 */
public class CheckClientVersionFilter implements Filter {

	/**
	 * Represents parameter name.
	 */
	private static final String PARAM_REQUIRED_CLIENT_VERSION = "RequiredClientVersion";

	/**
	 * Represent soap error message.
	 */
	private static final String RETURN_ERROR_MESSAGE = "<?xml version=\"1.0\" encoding=\"utf-8\"?><soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><soapenv:Body><soapenv:Fault><faultcode xmlns:ns1=\"urn:RPPSService/wsdlRPPSService\">ns1:org.eclipse.higgins.rpps.core.RppsException</faultcode><faultstring>IncompatibleVersionError: Unsupported client version!</faultstring><faultactor>RPPSService</faultactor><detail><ns2:hostname xmlns:ns2=\"http://xml.apache.org/axis/\">rh155.azigo.com</ns2:hostname></detail></soapenv:Fault></soapenv:Body></soapenv:Envelope>";

	/**
	 * Log.
	 */
	private static final Log LOG = LogFactory.getLog(CheckClientVersionFilter.class);

	/**
	 * Represents min required client version.
	 */
	private Double reqClientVersion;

	/*
	 * (non-Javadoc)
	 * 
	 * @see javax.servlet.Filter#destroy()
	 */
	public void destroy() {
	}

	/*
	 * 
	 * 
	 * 
	 * @see javax.servlet.Filter#doFilter(javax.servlet.ServletRequest, javax.servlet.ServletResponse,
	 * javax.servlet.FilterChain)
	 */
	public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException,
			ServletException {
		if (request instanceof HttpServletRequest) {
			String clientVersion = ((HttpServletRequest) request).getHeader("ClientVersion");
			if (null != clientVersion && clientVersion.length() > 0
					&& Double.parseDouble(clientVersion) < reqClientVersion) {
				// return SOAP fault - IncompatibleVersionError.
				((HttpServletResponse) response).setContentType("text/xml;charset=utf-8");
				PrintWriter writer = ((HttpServletResponse) response).getWriter();
				writer.print(RETURN_ERROR_MESSAGE);
				writer.flush();
				writer.close();
			} else {
				chain.doFilter(request, response);
			}

		} else {
			chain.doFilter(request, response);
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see javax.servlet.Filter#init(javax.servlet.FilterConfig)
	 */
	public void init(FilterConfig filterConfig) throws ServletException {
		try {
			reqClientVersion = new Double(filterConfig.getInitParameter(PARAM_REQUIRED_CLIENT_VERSION));
		} catch (Exception e) {
			reqClientVersion = new Double(0);
			LOG.error(e, e);
		}
	}

}
