/** 
 * Copyright (c) 2008 Parity Communications, Inc.  
 * All rights reserved. This program and the accompanying materials  
 * are made available under the terms of the Eclipse Public License v1.0  
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 *  
 * Contributors: 
 * Alexander Yuhimenko - implementation 
 * 
 */

package org.eclipse.higgins.rpps.web.filter;

import java.io.IOException;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;

/**
 * AIR couldn't process SOAP Fault http://bugs.adobe.com/jira/browse/SDK-11841 <br>
 * It's too bad, but Rpps always must return http status code 200 :(
 * 
 * @author Alexander Yuhimenko
 * 
 */
public class FixHttpStatusCodeFilter implements Filter {

	/*
	 * (non-Javadoc)
	 * 
	 * @see javax.servlet.Filter#destroy()
	 */
	public void destroy() {

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see javax.servlet.Filter#doFilter(javax.servlet.ServletRequest, javax.servlet.ServletResponse,
	 * javax.servlet.FilterChain)
	 */
	public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException,
			ServletException {
		// AIR couldn't process SOAP Fault http://bugs.adobe.com/jira/browse/SDK-11841
		// It's too bad, but Rpps always must return http status code 200 :(
		if (response instanceof HttpServletResponse) {
			chain.doFilter(request, new FixStatusCodeHttpServletResponseWrapper((HttpServletResponse) response));
		} else {
			chain.doFilter(request, response);
		}

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see javax.servlet.Filter#init(javax.servlet.FilterConfig)
	 */
	public void init(FilterConfig arg0) throws ServletException {
	}

}
