/** 
 * Copyright (c) 2008 Parity Communications, Inc.  
 * All rights reserved. This program and the accompanying materials  
 * are made available under the terms of the Eclipse Public License v1.0  
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 *  
 * Contributors: 
 * Alexander Yuhimenko - implementation 
 * 
 */

package org.eclipse.higgins.rpps.web.filter;

import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

/**
 * @author Alexander Yuhimenko
 * 
 */
public class FixStatusCodeHttpServletResponseWrapper extends HttpServletResponseWrapper {

	/*
	 * (non-Javadoc)
	 * 
	 * @see javax.servlet.http.HttpServletResponseWrapper#setStatus(int, java.lang.String)
	 */
	@Override
	public void setStatus(int sc, String sm) {
		if (sc == 500) {
			sc = 200;
		}
		super.setStatus(sc, sm);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see javax.servlet.http.HttpServletResponseWrapper#setStatus(int)
	 */
	@Override
	public void setStatus(int sc) {
		if (sc == 500) {
			sc = 200;
		}
		super.setStatus(sc);
	}

	/**
	 * @param response
	 */
	public FixStatusCodeHttpServletResponseWrapper(HttpServletResponse response) {
		super(response);
	}

}
