/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.rpps.core.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.security.AccessController;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.net.ssl.ManagerFactoryParameters;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactorySpi;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.callback.CallbackHandler;
import org.apache.axiom.om.util.UUIDGenerator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.utils.Base64;
import org.eclipse.higgins.cache.CacheProviderFactory;
import org.eclipse.higgins.configuration.xml.ConfigurationHandler;
import org.eclipse.higgins.icard.CUID;
import org.eclipse.higgins.icard.CardException;
import org.eclipse.higgins.icard.ICard;
import org.eclipse.higgins.icard.ICardProvider;
import org.eclipse.higgins.icard.ICardTemplate;
import org.eclipse.higgins.icard.IClaim;
import org.eclipse.higgins.icard.IClaimType;
import org.eclipse.higgins.icard.IComplexClaim;
import org.eclipse.higgins.icard.IImportCardInfo;
import org.eclipse.higgins.icard.IInformationCard;
import org.eclipse.higgins.icard.IInformationCardExtension;
import org.eclipse.higgins.icard.IIssuerInformationEntry;
import org.eclipse.higgins.icard.IManagedInformationCard;
import org.eclipse.higgins.icard.IPersonalInformationCard;
import org.eclipse.higgins.icard.IPolicy;
import org.eclipse.higgins.icard.ISimpleClaim;
import org.eclipse.higgins.icard.ISimpleClaimType;
import org.eclipse.higgins.icard.ITemplateContainer;
import org.eclipse.higgins.icard.ITemplateElement;
import org.eclipse.higgins.icard.ITemplateValue;
import org.eclipse.higgins.icard.TUID;
import org.eclipse.higgins.icard.auth.ICredential;
import org.eclipse.higgins.icard.auth.ICredentialDescriptor;
import org.eclipse.higgins.icard.auth.IPasswordCredential;
import org.eclipse.higgins.icard.auth.IPinCodeCredential;
import org.eclipse.higgins.icard.auth.ITSKerberosV5Credential;
import org.eclipse.higgins.icard.auth.ITSSelfIssuedCredential;
import org.eclipse.higgins.icard.auth.ITSUsernamePasswordCredential;
import org.eclipse.higgins.icard.auth.ITSX509V3Credential;
import org.eclipse.higgins.icard.auth.ITokenServiceCredential;
import org.eclipse.higgins.icard.auth.IUsernamePasswordCredential;
import org.eclipse.higgins.icard.common.auth.PinCodeCredential;
import org.eclipse.higgins.icard.common.auth.callback.PinCodeCallback;
import org.eclipse.higgins.icard.io.IFormatDescriptor;
import org.eclipse.higgins.icard.policy.ICardSpacePolicy;
import org.eclipse.higgins.icard.policy.ISTSPrivacyPolicy;
import org.eclipse.higgins.icard.provider.cardspace.common.CardSpacePolicy;
import org.eclipse.higgins.icard.provider.cardspace.common.InformationCard;
import org.eclipse.higgins.icard.provider.cardspace.common.PPIDCardSpacePolicy;
import org.eclipse.higgins.icard.provider.cardspace.common.STSFaultException;
import org.eclipse.higgins.icard.registry.ICardRegistry;
import org.eclipse.higgins.iss.CredentialContainer;
import org.eclipse.higgins.iss.ICardSelectorService;
import org.eclipse.higgins.iss.IICardSelector;
import org.eclipse.higgins.iss.IIdentityToken;
import org.eclipse.higgins.iss.SelectionANDofORs;
import org.eclipse.higgins.iss.SelectionANDofORsElm;
import org.eclipse.higgins.iss.UCTelm;
import org.eclipse.higgins.iss.UserChoiceTree;
import org.eclipse.higgins.iss.UserChoiceTree_ANDofORs;
import org.eclipse.higgins.keystore.IKeyStoreService;
import org.eclipse.higgins.keystore.registry.KeyStoreRegistry;
import org.eclipse.higgins.rpps.core.IRppsService;
import org.eclipse.higgins.rpps.core.RppsException;
import org.eclipse.higgins.rpps.core.chanel.CommunicationException;
import org.eclipse.higgins.rpps.core.chanel.EmailChanelCommand;
import org.eclipse.higgins.rpps.core.chanel.ICommunicationChanelCommand;
import org.eclipse.higgins.rpps.core.impl.CategoryComparator;
import org.eclipse.higgins.rpps.core.impl.ConvertHelper;
import org.eclipse.higgins.rpps.core.impl.RppsHelper;
import org.eclipse.higgins.rpps.core.impl.StringComparator;
import org.eclipse.higgins.rpps.core.impl.UserInterfaceResponse;
import org.eclipse.higgins.rpps.core.tobj.AccessTokenTO;
import org.eclipse.higgins.rpps.core.tobj.AuthCredentialTO;
import org.eclipse.higgins.rpps.core.tobj.CardExtensionTO;
import org.eclipse.higgins.rpps.core.tobj.CardInformationTO;
import org.eclipse.higgins.rpps.core.tobj.CardUsageTO;
import org.eclipse.higgins.rpps.core.tobj.CategoryTO;
import org.eclipse.higgins.rpps.core.tobj.ExtraTokenResponseTO;
import org.eclipse.higgins.rpps.core.tobj.FormatDescriptorTO;
import org.eclipse.higgins.rpps.core.tobj.ICardResponseTO;
import org.eclipse.higgins.rpps.core.tobj.ICardTO;
import org.eclipse.higgins.rpps.core.tobj.ICardTemplateTO;
import org.eclipse.higgins.rpps.core.tobj.ICardUpdateResponseTO;
import org.eclipse.higgins.rpps.core.tobj.ICardUpdateTO;
import org.eclipse.higgins.rpps.core.tobj.ICardsAndCategoryTO;
import org.eclipse.higgins.rpps.core.tobj.ImportCardInformationTO;
import org.eclipse.higgins.rpps.core.tobj.IssuerInformationEntryTO;
import org.eclipse.higgins.rpps.core.tobj.MapTO;
import org.eclipse.higgins.rpps.core.tobj.PropertyTO;
import org.eclipse.higgins.rpps.core.tobj.RPEndPointTO;
import org.eclipse.higgins.rpps.core.tobj.RPPolicy;
import org.eclipse.higgins.rpps.core.tobj.ResponseMessage;
import org.eclipse.higgins.rpps.core.tobj.STSPolicyTO;
import org.eclipse.higgins.rpps.core.tobj.SelectorAuthCredentialTO;
import org.eclipse.higgins.rpps.core.tobj.SelectorClientTO;
import org.eclipse.higgins.rpps.core.tobj.TokenResponseTO;
import org.eclipse.higgins.rpps.core.tobj.UIResponseAndTO;
import org.eclipse.higgins.rpps.core.tobj.UIResponseCardTO;
import org.eclipse.higgins.rpps.core.tobj.UIResponseClauseTO;
import org.eclipse.higgins.rpps.core.tobj.UIResponseOrTO;
import org.eclipse.higgins.rpps.core.tobj.UIResponseRPTO;
import org.eclipse.higgins.rpps.core.tobj.UIResponseTO;
import org.eclipse.higgins.rpps.core.tobj.UIResponseUsableCardsTO;
import org.eclipse.higgins.rpps.core.tobj.UITokenServiceCredentialTO;
import org.eclipse.higgins.rpps.core.tobj.UserProfileTO;
import org.eclipse.higgins.rpps.core.tobj.UsernamePasswordAuthCredentialTO;
import org.eclipse.higgins.rpps.core.utils.EmailUtils;
import org.eclipse.higgins.rpps.core.utils.ResourceMetaDataHelper;
import org.eclipse.higgins.rpps.core.utils.Utils;
import org.eclipse.higgins.sts.client.PPIDHelper;
import org.eclipse.higgins.sync.auth.IAuthenticateService;
import org.eclipse.higgins.sync.auth.entity.AccessTokenEntity;
import org.eclipse.higgins.sync.auth.exceptions.AuthenticationException;
import org.eclipse.higgins.sync.meta.IResourceMetaDataService;
import org.eclipse.higgins.sync.meta.entity.ResourceRevisionEntity;
import org.eclipse.higgins.sync.meta.entity.RevisionEntity;
import org.eclipse.higgins.sync.meta.utilities.ResourceUtil;
import org.eclipse.higgins.user.account.Account;
import org.eclipse.higgins.user.account.IUserAccountService;
import org.eclipse.higgins.user.account.UserAccountServiceFactory;
import org.eclipse.higgins.user.account.exception.UserAccountException;
import org.eclipse.higgins.user.account.exception.UserAlreadyExistsException;
import org.eclipse.higgins.user.account.utils.PasswordUtils;
import org.eclipse.higgins.user.login.LoginService;
import org.eclipse.higgins.user.login.UserAccount;
import org.eclipse.higgins.user.login.exception.ConfigurationException;
import org.eclipse.higgins.user.login.exception.LoginException;
import org.eclipse.higgins.user.profile.IUserProfileService;
import org.eclipse.higgins.user.profile.UserProfileServiceFactory;
import org.eclipse.higgins.user.profile.entity.Captcha;
import org.eclipse.higgins.user.profile.entity.CardCredential;
import org.eclipse.higgins.user.profile.entity.CardInformation;
import org.eclipse.higgins.user.profile.entity.CardUsage;
import org.eclipse.higgins.user.profile.entity.Category;
import org.eclipse.higgins.user.profile.entity.PolicyVersion;
import org.eclipse.higgins.user.profile.entity.SelectorClient;
import org.eclipse.higgins.user.profile.entity.UserProfile;
import org.eclipse.higgins.user.profile.entity.WebForm;
import org.eclipse.higgins.user.profile.exception.UserProfileException;

public class RppsService
implements IRppsService {
    private static final Log LOG = LogFactory.getLog(RppsService.class);
    private static Integer maxIdleTime = new Integer(1800);
    private static Integer maxLiveTime = new Integer(86400);
    private static final Map channelsMap = new HashMap();
    public static final ThreadLocal loginService;
    public static final ThreadLocal metaDataService;
    public static final ThreadLocal authenticateService;
    public static final ThreadLocal userAccountService;
    public static final ThreadLocal userProfileService;

    static {
        RppsService.AllowSelfSignedSSL();
        try {
            maxIdleTime = Integer.valueOf((String)RppsService.getContext().lookup("AccessTokenMaxIdleTime"));
            maxLiveTime = Integer.valueOf((String)RppsService.getContext().lookup("AccessTokenMaxLifeTime"));
            channelsMap.put("email", new EmailChanelCommand());
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
        }
        loginService = new ThreadLocal(){

            protected synchronized Object initialValue() {
                LoginService loginServiceInstance = null;
                try {
                    ConfigurationHandler configurationHandler = new ConfigurationHandler();
                    configurationHandler.setConfigurationBase((String)RppsService.getContext().lookup("HigginsConfigurationBase"));
                    configurationHandler.setFileName((String)RppsService.getContext().lookup("HigginsConfigurationFile"));
                    if (!configurationHandler.configure(null)) {
                        throw new ConfigurationException("Could not configure");
                    }
                    loginServiceInstance = LoginService.getInstance((Map)configurationHandler.getSettings());
                }
                catch (Exception e) {
                    LOG.error((Object)e, (Throwable)e);
                }
                return loginServiceInstance;
            }
        };
        metaDataService = new ThreadLocal(){

            protected synchronized Object initialValue() {
                IResourceMetaDataService metaDataServiceInstance = null;
                try {
                    metaDataServiceInstance = (IResourceMetaDataService)RppsService.getContext().lookup("cardsync/ResourceMetaDataService");
                }
                catch (Exception e) {
                    LOG.error((Object)e, (Throwable)e);
                }
                return metaDataServiceInstance;
            }
        };
        authenticateService = new ThreadLocal(){

            protected synchronized Object initialValue() {
                IAuthenticateService authServiceInstance = null;
                try {
                    authServiceInstance = (IAuthenticateService)RppsService.getContext().lookup("cardsync/AuthenticateService");
                }
                catch (Exception e) {
                    LOG.error((Object)e, (Throwable)e);
                }
                return authServiceInstance;
            }
        };
        userAccountService = new ThreadLocal(){

            protected synchronized Object initialValue() {
                IUserAccountService userAccountServiceInstance = null;
                try {
                    ConfigurationHandler configurationHandler = new ConfigurationHandler();
                    configurationHandler.setConfigurationBase((String)RppsService.getContext().lookup("HigginsConfigurationBase"));
                    configurationHandler.setFileName((String)RppsService.getContext().lookup("HigginsConfigurationFile"));
                    if (!configurationHandler.configure(null)) {
                        throw new ConfigurationException("Could not configure");
                    }
                    userAccountServiceInstance = UserAccountServiceFactory.getService((Map)configurationHandler.getSettings());
                }
                catch (Exception e) {
                    LOG.error((Object)e, (Throwable)e);
                }
                return userAccountServiceInstance;
            }
        };
        userProfileService = new ThreadLocal(){

            protected synchronized Object initialValue() {
                IUserProfileService userProfileServiceInstance = null;
                try {
                    ConfigurationHandler configurationHandler = new ConfigurationHandler();
                    configurationHandler.setConfigurationBase((String)RppsService.getContext().lookup("HigginsConfigurationBase"));
                    configurationHandler.setFileName((String)RppsService.getContext().lookup("HigginsConfigurationFile"));
                    if (!configurationHandler.configure(null)) {
                        throw new ConfigurationException("Could not configure");
                    }
                    userProfileServiceInstance = UserProfileServiceFactory.getService((Map)configurationHandler.getSettings());
                }
                catch (Exception e) {
                    LOG.error((Object)e, (Throwable)e);
                }
                return userProfileServiceInstance;
            }
        };
    }

    public static void AllowSelfSignedSSL() {
        if (Security.getProvider("Dummy") == null) {
            Security.insertProviderAt(new DummySecurityProvider(), 2);
            Security.setProperty("ssl.TrustManagerFactory.algorithm", DummyTrustManagerFactory.getAlgorithm());
        }
    }

    public static synchronized void ConfigureCache(String configurationBase, String configurationFile) {
        CacheProviderFactory.setConfigurationBase((String)configurationBase);
        CacheProviderFactory.setFileName((String)configurationFile);
        CacheProviderFactory.getCacheProvider();
    }

    public static Context getContext() throws NamingException {
        InitialContext initCtx = new InitialContext();
        return (Context)initCtx.lookup("java:comp/env");
    }

    protected void addCardHistory(UserAccount userAccount, CUID cuid, WebForm webForm) throws RppsException {
        try {
            Utils.cleanURLQuery(webForm);
            ((IUserProfileService)userProfileService.get()).addCardHistory(userAccount.getUserId(), cuid, webForm);
            try {
                RevisionEntity rootRevisionEntity = new ResourceUtil().findRootRevision((IResourceMetaDataService)metaDataService.get(), (String)((Object)userAccount.getUserId()));
                ResourceRevisionEntity revisionEntity = new ResourceRevisionEntity();
                revisionEntity.setResourceType("org.eclipse.higgins.sync.to.CardHistoryTO").setResourceId(String.valueOf(cuid.toString()) + webForm.getUrl().toString()).setUserId((String)((Object)userAccount.getUserId())).setParentId(rootRevisionEntity.getId());
                ((IResourceMetaDataService)metaDataService.get()).persistResourceRevisionEntity((RevisionEntity)revisionEntity);
            }
            catch (Exception e) {
                LOG.warn((Object)e, (Throwable)e);
            }
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    public CategoryTO addCategory(UserAccount userAccount, CategoryTO categoryTO) throws RppsException {
        try {
            Category category = ((IUserProfileService)userProfileService.get()).addCategory(userAccount.getUserId(), ConvertHelper.convertCategoryTO_to_Category(categoryTO));
            new ResourceMetaDataHelper().updateCategoryMD(category.getId(), (IResourceMetaDataService)metaDataService.get(), userAccount);
            return ConvertHelper.convertCategory_to_CategoryTO(category);
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    public void addClaimValuesMRU(UserAccount userAccount, String claimType, String claimValue) throws RppsException {
        try {
            Set vals = ((IUserProfileService)userProfileService.get()).getClaimValuesMRU(userAccount.getUserId(), claimType);
            vals.add(claimValue);
            ((IUserProfileService)userProfileService.get()).setClaimValuesMRU(userAccount.getUserId(), claimType, vals);
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    public boolean addRPEndPointCardRelation(UserAccount userAccount, String cuid, RPEndPointTO rpEndPointTO) throws RppsException {
        try {
            CUID cardCuid = new CUID(cuid);
            WebForm form = ConvertHelper.convertRPEndPointTOToWebForm(rpEndPointTO);
            ((IUserProfileService)userProfileService.get()).setUsedAlways(userAccount.getUserId(), cardCuid, form);
            return true;
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    public SelectorClientTO addSelectorClient(UserAccount userAccount, SelectorClientTO selectorClientTO) throws UserProfileException {
        if (((IUserProfileService)userProfileService.get()).getSelectorClients(userAccount.getUserId()).size() > 0) {
            throw new RuntimeException("You may add just one selector client without OTP.");
        }
        SelectorClient selectorClient = ((IUserProfileService)userProfileService.get()).addSelectorClient(userAccount.getUserId(), new SelectorClient().setAdded(new Date()).setName(selectorClientTO.getName()).setState("Active").setSerialNumber(UUIDGenerator.getUUID()));
        return ConvertHelper.convertSelectorClientToSelectorClientTO(selectorClient, selectorClientTO);
    }

    public SelectorClientTO[] getSelectorClients(UserAccount userAccount) throws UserProfileException {
        List clients = ((IUserProfileService)userProfileService.get()).getSelectorClients(userAccount.getUserId());
        if (clients != null) {
            SelectorClientTO[] clientTOs = new SelectorClientTO[clients.size()];
            int i = 0;
            while (i < clientTOs.length) {
                clientTOs[i] = ConvertHelper.convertSelectorClientToSelectorClientTO((SelectorClient)clients.get(i), new SelectorClientTO());
                ++i;
            }
            return clientTOs;
        }
        return new SelectorClientTO[0];
    }

    public SelectorClientTO addSelectorClient(UserAccount userAccount, SelectorClientTO selectorClientTO, String otp) throws UserProfileException {
        Map oneTimePasswords = ((IUserProfileService)userProfileService.get()).getUserProfile(userAccount.getUserId()).getOneTimePasswords();
        if (oneTimePasswords == null || !oneTimePasswords.containsValue(otp.replaceAll("-", ""))) {
            throw new RuntimeException(String.valueOf(otp) + " unknown  OTP.");
        }
        SelectorClient selectorClient = ((IUserProfileService)userProfileService.get()).addSelectorClient(userAccount.getUserId(), new SelectorClient().setAdded(new Date()).setName(selectorClientTO.getName()).setState("Active").setSerialNumber(UUIDGenerator.getUUID()));
        return ConvertHelper.convertSelectorClientToSelectorClientTO(selectorClient, selectorClientTO);
    }

    public SelectorClientTO updateSelectorClient(UserAccount userAccount, SelectorClientTO selectorClientTO) throws UserProfileException {
        List selectorClients = ((IUserProfileService)userProfileService.get()).getSelectorClients(userAccount.getUserId());
        int idx = selectorClients.indexOf(new SelectorClient().setSerialNumber(selectorClientTO.getSerialNumber()));
        if (idx > -1) {
            SelectorClient cfr_ignored_0 = (SelectorClient)selectorClients.get(idx);
            SelectorClient res = ((IUserProfileService)userProfileService.get()).modifySelectorClient(userAccount.getUserId(), ((SelectorClient)selectorClients.get(idx)).setState(selectorClientTO.getState()).setName(selectorClientTO.getName()));
            return ConvertHelper.convertSelectorClientToSelectorClientTO(res, selectorClientTO);
        }
        throw new UserProfileException("Couldn't find selector.");
    }

    public void deleteSelectorClient(UserAccount userAccount, SelectorClientTO selectorClientTO) throws UserProfileException {
        List selectorClients = ((IUserProfileService)userProfileService.get()).getSelectorClients(userAccount.getUserId());
        int idx = selectorClients.indexOf(new SelectorClient().setSerialNumber(selectorClientTO.getSerialNumber()));
        if (idx <= -1) {
            throw new UserProfileException("Couldn't find selector.");
        }
        SelectorClient selectorClient = (SelectorClient)selectorClients.get(idx);
        ((IUserProfileService)userProfileService.get()).deleteSelectorClient(userAccount.getUserId(), selectorClient.getId());
    }

    public boolean addUrlCardRelation(UserAccount userAccount, String cuid, String url) throws RppsException {
        try {
            CUID cardCuid = new CUID(cuid);
            WebForm form = new WebForm().setUrl(new URI(Utils.cleanURLQuery(url)));
            ((IUserProfileService)userProfileService.get()).setUsedAlways(userAccount.getUserId(), cardCuid, form);
            return true;
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    public ResponseMessage addUserProfile(UserProfileTO userProfile, String password) throws RppsException {
        try {
            this.addUserProfileBase(userProfile, password);
            return new ResponseMessage(0);
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            return new ResponseMessage(-1, e.getMessage());
        }
    }

    public UserProfile addUserProfileBase(UserProfileTO userProfile, String password) throws UserAccountException, NoSuchAlgorithmException, UnsupportedEncodingException, UserProfileException {
        if (!((IUserAccountService)userAccountService.get()).existsAccount(userProfile.getLoginName())) {
            Account account = ((IUserAccountService)userAccountService.get()).createAccount(null, new Account().setCreated(new Date()).setLogin(userProfile.getLoginName()).setPasswordHash(PasswordUtils.getPasswordHash((String)password)));
            UserProfile up = ((IUserProfileService)userProfileService.get()).addUserProfile((Serializable)((Object)account.getId()), ConvertHelper.convertUserProfileTO_to_UserProfile(new UserProfile(), userProfile).setUserIdentifier((Serializable)((Object)account.getId())));
            try {
                new EmailUtils().sendWelcomeEmail(userProfile.getEmail(), userProfile.getLoginName());
            }
            catch (Exception e) {
                LOG.error((Object)e);
            }
            new ResourceMetaDataHelper().updateUserProfileMD((IResourceMetaDataService)metaDataService.get(), account.getId(), up);
            return up;
        }
        throw new UserAlreadyExistsException();
    }

    public UserAccount authenticate(AuthCredentialTO authCredentialTO) throws ConfigurationException, LoginException, AuthenticationException, UserProfileException {
        if (authCredentialTO instanceof SelectorAuthCredentialTO) {
            SelectorAuthCredentialTO auth = (SelectorAuthCredentialTO)authCredentialTO;
            UserAccount account = ((LoginService)loginService.get()).login(RppsHelper.getCallbackHandler(auth.getUsername(), auth.getPassword()));
            List selectorClients = ((IUserProfileService)userProfileService.get()).getSelectorClients(account.getUserId());
            SelectorClient selector = new SelectorClient().setSerialNumber(auth.getSelectorSerialNumber());
            if (selectorClients != null && selectorClients.contains(selector)) {
                if ("Active".equals((selector = (SelectorClient)selectorClients.get(selectorClients.indexOf(selector))).getState())) {
                    return account;
                }
                throw new AuthenticationException("Selector was locked.");
            }
            throw new AuthenticationException("Couldn't find selector client.");
        }
        if (authCredentialTO instanceof UsernamePasswordAuthCredentialTO) {
            UsernamePasswordAuthCredentialTO auth = (UsernamePasswordAuthCredentialTO)authCredentialTO;
            return ((LoginService)loginService.get()).login(RppsHelper.getCallbackHandler(auth.getUsername(), auth.getPassword()));
        }
        throw new AuthenticationException("Unsupported  AuthCredentialTO type");
    }

    public UserAccount authenticate(String accessTokenId) throws ConfigurationException, AuthenticationException {
        return new UserAccount().setUserId((Serializable)((Object)((IAuthenticateService)authenticateService.get()).getAccessToken(accessTokenId).getUserIdentifier()));
    }

    public UserAccount authenticate(String userId, String password) throws ConfigurationException, LoginException {
        return ((LoginService)loginService.get()).login(RppsHelper.getCallbackHandler(userId, password));
    }

    public FormatDescriptorTO checkImportStream(UserAccount userAccount, byte[] crd) throws RppsException {
        try {
            IFormatDescriptor formatDescriptor = ICardRegistry.getInstance().checkInput((InputStream)new ByteArrayInputStream(crd));
            return this.convertIFormatDescriptor_to_FormatDescriptorTO(userAccount, formatDescriptor);
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    protected void clearCardCredential(UserAccount userAccount, CUID cuid) throws RppsException {
        try {
            ((IUserProfileService)userProfileService.get()).clearCardCredential(userAccount.getUserId(), cuid);
            try {
                RevisionEntity rootRevisionEntity = new ResourceUtil().findRootRevision((IResourceMetaDataService)metaDataService.get(), (String)((Object)userAccount.getUserId()));
                ResourceRevisionEntity revisionEntity = new ResourceRevisionEntity();
                revisionEntity.setResourceType("org.eclipse.higgins.sync.to.CardCredentialTO").setResourceId(cuid.toString()).setUserId((String)((Object)userAccount.getUserId())).setParentId(rootRevisionEntity.getId());
                ((IResourceMetaDataService)metaDataService.get()).persistResourceRevisionEntity((RevisionEntity)revisionEntity);
            }
            catch (Exception e) {
                LOG.error((Object)e, (Throwable)e);
            }
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    public ICardTO clearCardCredential(UserAccount userAccount, String cuid) throws RppsException {
        try {
            this.clearCardCredential(userAccount, new CUID(cuid));
            return this.getICardByCUID(userAccount, cuid);
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    protected void clearCardHistory(UserAccount userAccount, CUID cuid) throws RppsException {
        try {
            ((IUserProfileService)userProfileService.get()).clearCardHistory(userAccount.getUserId(), cuid);
            try {
                List historytList = this.getCardHistory(userAccount, cuid);
                for (CardUsage cardUsage : historytList) {
                    ResourceRevisionEntity revisionEntity = new ResourceRevisionEntity();
                    revisionEntity.setResourceType("org.eclipse.higgins.sync.to.CardHistoryTO").setResourceId(String.valueOf(cuid.toString()) + cardUsage.getForm().getUrl()).setUserId((String)((Object)userAccount.getUserId()));
                    ((IResourceMetaDataService)metaDataService.get()).deleteResourceRevisionEntity((RevisionEntity)revisionEntity);
                }
            }
            catch (Exception e) {
                LOG.error((Object)e, (Throwable)e);
            }
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    public boolean clearCardHistory(UserAccount userAccount, String cuid) throws RppsException {
        try {
            this.clearCardHistory(userAccount, new CUID(cuid));
            return true;
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    protected ICardTO convertICard_To_ICardTO(UserAccount userAccount, ICard card, boolean isCatchAuthentication, Map icardMap) throws CardException, RppsException {
        ICardTO icard = new ICardTO();
        if (card != null) {
            Map propMap;
            UITokenServiceCredentialTO[] tokenServiceCredentials;
            IInformationCardExtension[] extension;
            icard.setId(card.getID());
            icard.setCuid(card.getCUID().toString());
            icard.setName(card.getName());
            icard.setIssuerName(card.getIssuerName());
            icard.setzIssuer(card.getIssuer());
            icard.setImage(card.getImage());
            icard.setImageType(card.getImageType());
            icard.setSelfIssued(card.isSelfIssued());
            List supportedTokenTypes = card.getSupportedTokenTypes();
            if (supportedTokenTypes != null) {
                String[] zSupportedTokenTypes = new String[supportedTokenTypes.size()];
                int i = 0;
                while (i < zSupportedTokenTypes.length) {
                    URI uri = (URI)supportedTokenTypes.get(i);
                    zSupportedTokenTypes[i] = uri != null ? uri.toString() : "";
                    ++i;
                }
                icard.setzSupportedTokenType(zSupportedTokenTypes);
            }
            icard.setType(card.getType());
            if (card instanceof IInformationCard && ((IInformationCard)card).hasExtensions() && (extension = ((IInformationCard)card).getExtensions()) != null) {
                ArrayList<CardExtensionTO> cardExtensionTOs = new ArrayList<CardExtensionTO>();
                int i = 0;
                while (i < extension.length) {
                    try {
                        boolean enabled = extension[i].isEnabled();
                        String element = (String)extension[i].getElement().getAs(String.class);
                        cardExtensionTOs.add(new CardExtensionTO(enabled, element));
                    }
                    catch (Exception e) {
                        LOG.error((Object)e, (Throwable)e);
                    }
                    ++i;
                }
                icard.setCardExtensions(cardExtensionTOs.toArray(new CardExtensionTO[cardExtensionTOs.size()]));
            }
            if (card instanceof IManagedInformationCard) {
                IIssuerInformationEntry[] issuerInformationEntries;
                IManagedInformationCard managedInformationCard = (IManagedInformationCard)card;
                ISTSPrivacyPolicy policy = managedInformationCard.getPrivacyNotice();
                if (policy != null) {
                    icard.setStsPolicy(new STSPolicyTO(policy.getPrivacyVersion(), policy.getPrivacyUrl()));
                }
                if ((issuerInformationEntries = managedInformationCard.getIc07IssuerInformation()) != null && issuerInformationEntries.length > 0) {
                    IssuerInformationEntryTO[] entryTO = new IssuerInformationEntryTO[issuerInformationEntries.length];
                    int i = 0;
                    while (i < issuerInformationEntries.length) {
                        entryTO[i] = ConvertHelper.convertIIssuerInformationEntryToIssuerInformationEntryTO(issuerInformationEntries[i]);
                        ++i;
                    }
                    icard.setXInformationEntryTO(entryTO);
                }
            }
            CardCredential cardCredential = null;
            try {
                CardInformation cardInformation = ((IUserProfileService)userProfileService.get()).getCardInformation(userAccount.getUserId(), card.getCUID());
                if (cardInformation != null) {
                    cardCredential = cardInformation.getCardCredential();
                    List cu = ((IUserProfileService)userProfileService.get()).getCardUsageSummary(userAccount.getUserId(), card.getCUID(), 0, 1, "date", true);
                    if (cu != null && cu.size() > 0 && cu.get(0) != null) {
                        icard.setXLastUsed(ConvertHelper.convertCardUsage_to_CardUsageTO((CardUsage)cu.get(0)));
                    }
                }
            }
            catch (Exception e) {
                LOG.error((Object)e, (Throwable)e);
            }
            if ((tokenServiceCredentials = this.convertICredentials_to_UITokenServiceCredentialTO(userAccount, card, cardCredential, icardMap)).length > 0) {
                icard.setTokenServiceCredentials(tokenServiceCredentials);
            }
            if ((propMap = ConvertHelper.convertClaims_to_PropertyTO(card, isCatchAuthentication, card.getSupportedClaimTypes())).size() > 0) {
                icard.setProperties(propMap.values().toArray(new PropertyTO[propMap.values().size()]));
            }
        }
        return icard;
    }

    public UIResponseCardTO convertICard_To_UIResponseCardTO(UserAccount userAccount, ICard icard, WebForm webForm, IPolicy policy, CardInformation cardInformation, X509Certificate[] sslCerts) {
        UIResponseCardTO cardTO = new UIResponseCardTO();
        if (icard != null) {
            cardTO.setCardId(icard.getCUID().toString());
            cardTO.setUid(icard.getCUID().toString());
            String nm = icard.getName();
            int k = nm.lastIndexOf(47);
            nm = k > 0 ? nm.substring(k + 1) : nm;
            cardTO.setName(nm);
            cardTO.setDescription(icard.getDescription());
            cardTO.setImage(icard.getImage());
            cardTO.setImagetype(icard.getImageType());
            cardTO.setIssuerName(icard.getIssuerName());
            cardTO.setType(icard.getType());
            List supportedClaimTypeList = icard.getSupportedClaimTypesUris();
            if (supportedClaimTypeList != null && supportedClaimTypeList.size() > 0) {
                String[] supportedClaimType = new String[supportedClaimTypeList.size()];
                supportedClaimTypeList.toArray(supportedClaimType);
                cardTO.setSupportedClaimTypes(supportedClaimType);
            }
            UITokenServiceCredentialTO[] tokenservices = this.convertICredentials_to_UITokenServiceCredentialTO(userAccount, icard, cardInformation != null ? cardInformation.getCardCredential() : null, null);
            cardTO.setTokenservices(tokenservices);
            String PPID_CLAIM = "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/privatepersonalidentifier";
            Map requiredMap = null;
            try {
                if (policy.getRequiredClaims() != null && policy.getRequiredClaims().size() > 0) {
                    requiredMap = ConvertHelper.convertClaims_to_PropertyTO(icard, false, policy.getRequiredClaims().iterator());
                }
            }
            catch (Exception e) {
                LOG.error((Object)e, (Throwable)e);
            }
            if (policy instanceof ICardSpacePolicy) {
                ICardSpacePolicy policyCS = (ICardSpacePolicy)policy;
                try {
                    Map propMap;
                    if (icard instanceof IPersonalInformationCard && requiredMap != null && requiredMap.containsKey(PPID_CLAIM)) {
                        String ppid = null;
                        byte[] pinDigets = ((IPersonalInformationCard)icard).getPinDigest();
                        if (pinDigets == null && sslCerts != null && sslCerts.length > 0 && webForm != null && webForm.getUrl() != null) {
                            String uriSite = webForm.getUrl().toString();
                            byte[] ppidArray = PPIDHelper.computeClaimValuePPID((IInformationCard)((InformationCard)icard), (X509Certificate[])sslCerts, (CertStore)KeyStoreRegistry.getInstance().getSecurityService().getCertStore(RppsHelper.getCallbackHandler(userAccount.getUserId())), (String)uriSite);
                            if (ppidArray != null) {
                                ppid = PPIDHelper.getUserFriendlyPPID((byte[])ppidArray);
                            }
                        }
                        if (ppid != null) {
                            requiredMap.put(PPID_CLAIM, new PropertyTO("Site Specific Card ID", PPID_CLAIM, "".getClass().getName(), new String[]{ppid}, true, 0, new String[]{""}, "", ""));
                        }
                    }
                    if (policyCS.getOptionalClaims() != null && policyCS.getOptionalClaims().size() > 0 && (propMap = ConvertHelper.convertClaims_to_PropertyTO(icard, false, policyCS.getOptionalClaims().iterator())).size() > 0) {
                        cardTO.setOptionalClaims(propMap.values().toArray(new PropertyTO[propMap.values().size()]));
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)e, (Throwable)e);
                }
            }
            try {
                if (requiredMap != null && requiredMap.size() > 0) {
                    cardTO.setProperties(requiredMap.values().toArray(new PropertyTO[requiredMap.values().size()]));
                }
            }
            catch (Exception exception) {}
        }
        return cardTO;
    }

    private ICardResponseTO convertICards_To_CardResponceTO(UserAccount userAccount, List cards) {
        ICardResponseTO cardResponceTO;
        Hashtable icardMap;
        block7: {
            icardMap = new Hashtable();
            cardResponceTO = new ICardResponseTO();
            try {
                if (cards == null) break block7;
                ICardTO[] cardTOs = new ICardTO[cards.size()];
                int i = 0;
                while (i < cards.size()) {
                    try {
                        ICard card = (ICard)cards.get(i);
                        cardTOs[i] = this.convertICard_To_ICardTO(userAccount, card, false, icardMap);
                    }
                    catch (Exception e) {
                        LOG.error((Object)e, (Throwable)e);
                    }
                    ++i;
                }
                cardResponceTO.setICardList(cardTOs);
            }
            catch (Exception e) {
                LOG.error((Object)e, (Throwable)e);
            }
        }
        ArrayList<MapTO> relationList = new ArrayList<MapTO>();
        if (!icardMap.isEmpty()) {
            for (String key : icardMap.keySet()) {
                List value = (List)icardMap.get(key);
                relationList.add(new MapTO(key, value.toArray(new String[value.size()])));
            }
        }
        cardResponceTO.setRelationList(relationList.toArray(new MapTO[relationList.size()]));
        return cardResponceTO;
    }

    protected UITokenServiceCredentialTO[] convertICredentials_to_UITokenServiceCredentialTO(UserAccount userAccount, ICard card, CardCredential cardCredential, Map icardMap) {
        ICredentialDescriptor[] der;
        ArrayList<UITokenServiceCredentialTO> credList = new ArrayList<UITokenServiceCredentialTO>();
        if (card != null && (der = card.getRequiredCredentials()) != null) {
            int i = 0;
            while (i < der.length) {
                ICredential credential = der[i].getCredential();
                UITokenServiceCredentialTO credentialTO = this.convertICredentials_to_UITokenServiceCredentialTO(userAccount, credential, icardMap, card);
                if (credentialTO != null) {
                    if (cardCredential != null && credentialTO.getType().equals(cardCredential.getCredentialType())) {
                        credentialTO.setSaveCredential(true);
                    }
                    credList.add(credentialTO);
                }
                ++i;
            }
        }
        UITokenServiceCredentialTO[] array = new UITokenServiceCredentialTO[credList.size()];
        credList.toArray(array);
        return array;
    }

    protected UITokenServiceCredentialTO convertICredentials_to_UITokenServiceCredentialTO(UserAccount userAccount, ICredential credential, Map icardMap, ICard icard) {
        UITokenServiceCredentialTO tokenService;
        block28: {
            tokenService = null;
            if (credential != null) {
                tokenService = new UITokenServiceCredentialTO();
                if (credential instanceof ITokenServiceCredential) {
                    tokenService.setAddress(((ITokenServiceCredential)credential).getAddress().toString());
                    tokenService.setMetadataAddress(((ITokenServiceCredential)credential).getMetadataAddress().toString());
                    if (credential instanceof ITSUsernamePasswordCredential) {
                        tokenService.setPassword(((ITSUsernamePasswordCredential)credential).getPassword());
                        tokenService.setUsername(((ITSUsernamePasswordCredential)credential).getUsername());
                        tokenService.setType("ITSUsernamePasswordCredential");
                    } else if (credential instanceof ITSSelfIssuedCredential) {
                        ICard personalCard;
                        block27: {
                            tokenService.setType("ITSSelfIssuedNonPinCredential");
                            personalCard = this.getICardByPPID(userAccount, ((ITSSelfIssuedCredential)credential).getCertificate(), ((ITSSelfIssuedCredential)credential).getPPID(), ((ITSSelfIssuedCredential)credential).getAddress());
                            if (personalCard != null) break block27;
                            LOG.info((Object)"Cannot find the Personal card used to authenticate for this managed card.");
                            return null;
                        }
                        try {
                            if (icardMap != null && icard != null) {
                                List<String> relationCUIDs = null;
                                if (icardMap.containsKey(personalCard.getCUID().toString())) {
                                    relationCUIDs = (List)icardMap.get(personalCard.getCUID().toString());
                                }
                                if (relationCUIDs == null) {
                                    relationCUIDs = new ArrayList();
                                }
                                if (!relationCUIDs.contains(icard.getCUID().toString())) {
                                    relationCUIDs.add(icard.getCUID().toString());
                                }
                                icardMap.put(personalCard.getCUID().toString(), relationCUIDs);
                            }
                            tokenService.setAssociatedCardName(personalCard.getName());
                            tokenService.setAssociatedCardImage(personalCard.getImage());
                            tokenService.setAssociatedCardImageType(personalCard.getDescription());
                            tokenService.setAssociatedCardDescription(personalCard.getDescription());
                            ICredential subCredential = null;
                            ICredentialDescriptor[] derPersonal = personalCard.getRequiredCredentials();
                            if (derPersonal != null && derPersonal.length > 0) {
                                subCredential = derPersonal[0].getCredential();
                            }
                            if (subCredential == null) break block28;
                            int index = 0;
                            while (index < subCredential.getCallbacks().length) {
                                if (subCredential.getCallbacks()[index] instanceof PinCodeCallback) {
                                    tokenService.setType("ITSSelfIssuedCredential");
                                    break;
                                }
                                ++index;
                            }
                        }
                        catch (Exception e) {
                            LOG.error((Object)e, (Throwable)e);
                        }
                    } else if (credential instanceof ITSKerberosV5Credential) {
                        tokenService.setType("ITSKerberosV5Credential");
                    } else if (credential instanceof ITSX509V3Credential) {
                        tokenService.setType("ITSX509V3Credential");
                    } else {
                        tokenService = null;
                    }
                } else if (credential instanceof IPinCodeCredential) {
                    tokenService.setType("IPinCodeCredential");
                } else if (credential instanceof IUsernamePasswordCredential) {
                    tokenService.setType("IUsernamePasswordCredential");
                    tokenService.setUsername(((IUsernamePasswordCredential)credential).getUsername());
                } else if (credential instanceof IPasswordCredential) {
                    tokenService.setType("IPasswordCredential");
                } else {
                    tokenService = null;
                }
            }
        }
        return tokenService;
    }

    protected FormatDescriptorTO convertIFormatDescriptor_to_FormatDescriptorTO(UserAccount userAccount, IFormatDescriptor descriptor) {
        FormatDescriptorTO descriptorTO = null;
        if (descriptor != null) {
            descriptorTO = new FormatDescriptorTO();
            descriptorTO.setFormatID(descriptor.getID());
            descriptorTO.setName(descriptor.getDescription());
            descriptorTO.setFileExtension(descriptor.getFileExtension());
            if (descriptor.getCredentialDescriptor() != null && descriptor.getCredentialDescriptor().getCredential() != null) {
                UITokenServiceCredentialTO credential = this.convertICredentials_to_UITokenServiceCredentialTO(userAccount, descriptor.getCredentialDescriptor().getCredential(), null, null);
                descriptorTO.setCredential(credential);
            }
        }
        return descriptorTO;
    }

    public Captcha createCaptcha() throws RppsException {
        try {
            Captcha captcha = new Captcha();
            captcha.setDtCreation(new Date());
            captcha.setKey(UUIDGenerator.getUUID());
            return ((IUserProfileService)userProfileService.get()).addCaptcha(captcha);
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    protected ICard createDuplicateICard(UserAccount userAccount, String cardName, CUID cuid, String pinCode) throws RppsException {
        try {
            ICard card = ICardRegistry.getInstance().getICardByCUID(RppsHelper.getCallbackHandler(userAccount.getUserId()), cuid);
            if (!(card instanceof IPersonalInformationCard)) {
                throw new RppsException("You can not create dublicate this card.");
            }
            if (card.getRequiredCredentials() != null && card.getRequiredCredentials().length > 0) {
                PinCodeCredential credential = null;
                if (pinCode != null && pinCode.trim().length() > 0) {
                    credential = new PinCodeCredential();
                    try {
                        credential.setPinCode(pinCode.getBytes("UTF-8"));
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        credential.setPinCode(pinCode.getBytes());
                    }
                } else {
                    CardInformation cardInformation = ((IUserProfileService)userProfileService.get()).getCardInformation(userAccount.getUserId(), cuid);
                    if (cardInformation != null && cardInformation.getCardCredential() != null) {
                        credential = ConvertHelper.convertCardCredential_to_ICredential(card, cardInformation.getCardCredential());
                    } else {
                        throw new RppsException("Rpps can not retrieve card. You have to send pin code.");
                    }
                }
                card = card.getProvider().getICardByCUID(RppsHelper.getCallbackHandler(userAccount.getUserId()), cuid, (ICredential)credential);
            }
            ICardTemplate[] cardTemplates = card.getProvider().getCardCreationTemplates(RppsHelper.getCallbackHandler(userAccount.getUserId()));
            ICardTemplate cardTemplate = null;
            int i = 0;
            while (i < cardTemplates.length) {
                if (cardTemplates[i].getCardType().isInstance(card)) {
                    cardTemplate = cardTemplates[i];
                    if (cardTemplate.getTemplateElementByID("cardName") != null) {
                        ((ITemplateValue)cardTemplate.getTemplateElementByID("cardName")).setValue(cardName);
                    }
                    if (cardTemplate.getTemplateElementByID("cardPicture") != null && card.getImage() != null) {
                        ((ITemplateValue)cardTemplate.getTemplateElementByID("cardPicture")).setValue(Base64.encode((byte[])card.getImage()));
                    }
                    if (cardTemplate.getTemplateElementByID("claimList") == null) break;
                    Iterator iter = ((ITemplateContainer)cardTemplate.getTemplateElementByID("claimList")).getTemplateElements();
                    while (iter.hasNext()) {
                        ITemplateElement element = (ITemplateElement)iter.next();
                        IClaim claim = card.getClaim(element.getID());
                        if (claim == null || ((ISimpleClaim)claim).getValues().size() <= 0) continue;
                        ((ITemplateValue)element).setValue((String)((ISimpleClaim)claim).getValues().get(0));
                    }
                    break;
                }
                ++i;
            }
            if (cardTemplate != null) {
                return this.createICard(userAccount, cardTemplate);
            }
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
        return null;
    }

    public ICardTO createDuplicateICard(UserAccount userAccount, String cardName, String cuid, String pinCode) throws RppsException {
        ICard card = null;
        try {
            card = this.createDuplicateICard(userAccount, cardName, new CUID(cuid), pinCode);
            return this.convertICard_To_ICardTO(userAccount, card, false, null);
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    protected ICard createICard(UserAccount userAccount, ICardTemplate template) throws RppsException {
        try {
            if (template != null) {
                String extID = template.getProviderID();
                ICardProvider provider = ICardRegistry.getInstance().getICardProvider(extID);
                if (provider != null && provider.getCardCreationTemplates(RppsHelper.getCallbackHandler(userAccount.getUserId())) != null) {
                    try {
                        ICard res = provider.createCard(RppsHelper.getCallbackHandler(userAccount.getUserId()), template);
                        new ResourceMetaDataHelper().updateCardMD(res.getCUID().toString(), (IResourceMetaDataService)metaDataService.get(), userAccount);
                        return res;
                    }
                    catch (Exception ex) {
                        throw new RppsException(ex);
                    }
                }
                throw new RppsException("There is not a registered provider for this id.");
            }
            throw new RppsException("Paramenter <<template>> is null");
        }
        catch (RppsException e) {
            LOG.error((Object)e, (Throwable)e);
            throw e;
        }
    }

    public ICardTO createICard(UserAccount userAccount, ICardTemplateTO template) throws RppsException {
        ICard card = null;
        try {
            ICardTemplate[] templates = this.getICardCreationTemplateByProvider(userAccount, template.getProviderID());
            card = this.createICard(userAccount, RppsHelper.fillICardTemplate_from_ICardTemplateTO(templates, template));
            new ResourceMetaDataHelper().updateCardMD(card.getCUID().toString(), (IResourceMetaDataService)metaDataService.get(), userAccount);
            return this.convertICard_To_ICardTO(userAccount, card, false, null);
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    public String createICardFromHBX(UserAccount userAccount, String cardname) throws RppsException {
        String ret = null;
        try {
            ICardTemplate template = this.getICardCreationTemplateByTUID(userAccount, new TUID("org.eclipse.higgins.icard.provider.cardspace.personal.db", "PersonalCardTemplate"));
            template = RppsHelper.fillPersonalCardTemplate(template, cardname, "", "", "", "", "", "", "", "", "", "", "", "", "", "");
            ret = this.createICard(userAccount, template).getCUID().toString();
        }
        catch (Exception e) {
            throw new RppsException(e);
        }
        return ret;
    }

    public void deleteAllICard(UserAccount userAccount) throws RppsException {
        List icards = this.getICardsByUser(RppsHelper.getCallbackHandler(userAccount.getUserId()));
        Iterator iter = icards.iterator();
        while (iter.hasNext()) {
            this.deleteICardOnly(userAccount, ((ICard)iter.next()).getCUID().toString());
        }
    }

    public void deleteCaptcha(String id) throws RppsException {
        try {
            ((IUserProfileService)userProfileService.get()).deleteCaptcha(((IUserProfileService)userProfileService.get()).getCaptcha(id));
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    protected boolean deleteCardHistoryRecord(UserAccount userAccount, CUID cuid, WebForm webForm) throws RppsException {
        try {
            Utils.cleanURLQuery(webForm);
            ((IUserProfileService)userProfileService.get()).clearCardHistory(userAccount.getUserId(), cuid, webForm);
            try {
                ResourceRevisionEntity revisionEntity = new ResourceRevisionEntity();
                revisionEntity.setResourceType("org.eclipse.higgins.sync.to.CardHistoryTO").setResourceId(String.valueOf(cuid.toString()) + webForm.getUrl().toString()).setUserId((String)((Object)userAccount.getUserId()));
                ((IResourceMetaDataService)metaDataService.get()).deleteResourceRevisionEntity((RevisionEntity)revisionEntity);
            }
            catch (Exception e) {
                LOG.error((Object)e, (Throwable)e);
            }
            return true;
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    public boolean deleteCardHistoryRecord(UserAccount userAccount, String cuid, RPEndPointTO rpEndPointTO) throws RppsException {
        try {
            WebForm webForm = ConvertHelper.convertRPEndPointTOToWebForm(rpEndPointTO);
            Utils.cleanURLQuery(webForm);
            return this.deleteCardHistoryRecord(userAccount, new CUID(cuid), webForm);
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    public boolean deleteCardHistoryRecord(UserAccount userAccount, String cuid, String url) throws RppsException {
        try {
            return this.deleteCardHistoryRecord(userAccount, new CUID(cuid), new WebForm(new URI(Utils.cleanURLQuery(url)), null, null, null));
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    public void deleteCategory(UserAccount userAccount, String categoryId) throws RppsException {
        try {
            ((IUserProfileService)userProfileService.get()).deleteCategory(userAccount.getUserId(), categoryId);
            try {
                ((IResourceMetaDataService)metaDataService.get()).deleteResourceRevisionEntity(new ResourceRevisionEntity().setResourceType("org.eclipse.higgins.sync.to.CardCategoryTO").setResourceId(categoryId).setUserId((String)((Object)userAccount.getUserId())));
            }
            catch (Exception e) {
                LOG.error((Object)e, (Throwable)e);
            }
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    public ICardUpdateResponseTO deleteICard(UserAccount userAccount, String cuid) throws RppsException {
        ICard personalCard = null;
        try {
            ICard icard = this.getICardByCUID(userAccount, new CUID(cuid));
            ICredentialDescriptor[] credDescriptor = icard.getRequiredCredentials();
            if (credDescriptor != null) {
                int i = 0;
                while (i < credDescriptor.length) {
                    if (credDescriptor[i].getCredential() != null && credDescriptor[i].getCredential() instanceof ITSSelfIssuedCredential) {
                        ITSSelfIssuedCredential credential = (ITSSelfIssuedCredential)credDescriptor[i].getCredential();
                        personalCard = this.getICardByPPID(userAccount, credential.getCertificate(), credential.getPPID(), credential.getAddress());
                    }
                    ++i;
                }
            }
            this.deleteICardOnly(userAccount, cuid);
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            return new ICardUpdateResponseTO(-1, e.getMessage());
        }
        if (personalCard != null) {
            return new ICardUpdateResponseTO(personalCard.getCUID().toString());
        }
        return new ICardUpdateResponseTO(0, "");
    }

    private void deleteICardOnly(UserAccount userAccount, String cuid) throws RppsException {
        try {
            CUID cuidTemp = new CUID(cuid);
            ((IUserProfileService)userProfileService.get()).clearCardCredential(userAccount.getUserId(), cuidTemp);
            ((IUserProfileService)userProfileService.get()).clearUsedAlwaysURLs(userAccount.getUserId(), cuidTemp);
            ((IUserProfileService)userProfileService.get()).clearCardHistory(userAccount.getUserId(), cuidTemp);
            ICardRegistry.getInstance().deleteICard(RppsHelper.getCallbackHandler(userAccount.getUserId()), new CUID(cuid));
            ICardTO defaultPCard = this.getDefaultPCard(userAccount);
            if (defaultPCard != null && cuid.equals(defaultPCard.getCuid())) {
                this.setDefaultPCard(userAccount, null);
            }
            try {
                ResourceRevisionEntity revisionEntity = new ResourceRevisionEntity();
                revisionEntity.setResourceType("org.eclipse.higgins.sync.to.CardTO").setResourceId(cuid).setUserId((String)((Object)userAccount.getUserId()));
                ((IResourceMetaDataService)metaDataService.get()).deleteResourceRevisionEntity((RevisionEntity)revisionEntity);
            }
            catch (Exception e) {
                LOG.error((Object)e, (Throwable)e);
            }
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    public boolean deleteRPEndPointCardRelation(UserAccount userAccount, String cuid, RPEndPointTO rpEndPointTO) throws RppsException {
        try {
            if (rpEndPointTO != null) {
                this.deleteWebFormCardRelation(userAccount, new CUID(cuid), ConvertHelper.convertRPEndPointTOToWebForm(rpEndPointTO));
            }
            return true;
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    public boolean deleteRPEndPointsCardsRelations(UserAccount userAccount, String cuid) throws RppsException {
        try {
            ((IUserProfileService)userProfileService.get()).clearUsedAlwaysURLs(userAccount.getUserId(), new CUID(cuid));
            return true;
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    public boolean deleteUrlCardRelation(UserAccount userAccount, String cuid, String url) throws RppsException {
        try {
            if (url != null) {
                this.deleteWebFormCardRelation(userAccount, new CUID(cuid), new WebForm(new URI(Utils.cleanURLQuery(url)), null, null, null));
            }
            return true;
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    public boolean deleteUrlsCardsRelations(UserAccount userAccount, String cuid) throws RppsException {
        return this.deleteRPEndPointsCardsRelations(userAccount, cuid);
    }

    public ResponseMessage deleteUserProfile(UserAccount userAccount) throws RppsException {
        try {
            this.deleteAllICard(userAccount);
            ((IUserAccountService)userAccountService.get()).deleteAccount(userAccount.getUserId());
            return new ResponseMessage(0);
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            return new ResponseMessage(-1, e.getMessage());
        }
    }

    protected CardUsage deleteWebFormCardRelation(UserAccount userAccount, CUID cuid, WebForm webForm) throws RppsException {
        try {
            Utils.cleanURLQuery(webForm);
            CardUsage res = ((IUserProfileService)userProfileService.get()).deleteUsedAlways(userAccount.getUserId(), cuid, webForm);
            return res;
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    public ICardTO editPinCode(UserAccount userAccount, String cuid, String oldPinCode, String newPinCode) throws RppsException {
        ICard card = null;
        byte[] oldPinCodeTemp = null;
        try {
            card = this.getICardByCUID(userAccount, new CUID(cuid));
            if (card == null) {
                throw new RppsException("Can't find card with CUID " + cuid);
            }
            if (!(card instanceof IPersonalInformationCard)) {
                new RppsException("This card is not personal");
            }
            CardInformation cardInformation = null;
            if (oldPinCode == null) {
                cardInformation = ((IUserProfileService)userProfileService.get()).getCardInformation(userAccount.getUserId(), new CUID(cuid));
                if (cardInformation.getCardCredential() != null && "IPinCodeCredential".equals(cardInformation.getCardCredential().getCredentialType())) {
                    oldPinCodeTemp = cardInformation.getCardCredential().getPinCode();
                }
            } else {
                oldPinCodeTemp = oldPinCode.getBytes("UTF-8");
            }
            card = this.resetPinCode(userAccount, (IPersonalInformationCard)card, oldPinCodeTemp);
            card = this.setPinCode(userAccount, (IPersonalInformationCard)card, newPinCode.getBytes("UTF-8"));
            if (cardInformation != null) {
                try {
                    if (cardInformation.getCardCredential() != null) {
                        CardCredential cardCredential = cardInformation.getCardCredential();
                        cardCredential.setPinCode(newPinCode.getBytes("UTF-8"));
                        this.setCardCredential(userAccount, new CUID(cuid), cardCredential);
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)e, (Throwable)e);
                }
            }
            new ResourceMetaDataHelper().updateCardMD(cuid, (IResourceMetaDataService)metaDataService.get(), userAccount);
            return this.convertICard_To_ICardTO(userAccount, card, false, null);
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    public byte[] exportICards(UserAccount userAccount, String formatID, String[] cards, UITokenServiceCredentialTO credential) throws RppsException {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            if (cards != null && cards.length > 0) {
                CUID[] cuids = new CUID[cards.length];
                int i = 0;
                while (i < cards.length) {
                    cuids[i] = new CUID(cards[i]);
                    ++i;
                }
                ICredential credentialTemp = ConvertHelper.convertUITokenServiceCredentialTO_to_ICredentials(credential);
                ICardRegistry.getInstance().exportICards(RppsHelper.getCallbackHandler(userAccount.getUserId()), (OutputStream)out, formatID, cuids, credentialTemp);
                return out.toByteArray();
            }
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
        return null;
    }

    public void generatePasswordResetCode(String userIdentifier) throws RppsException {
        try {
            Serializable id = ((IUserAccountService)userAccountService.get()).getAccountId(userIdentifier);
            UserProfile userProfile = ((IUserProfileService)userProfileService.get()).getUserProfile(id);
            Account account = ((IUserAccountService)userAccountService.get()).getAccount(id);
            if (userProfile.getEmail() == null) {
                throw new RppsException("Email address is empty, couldn't send email.");
            }
            String passwordResetCode = PPIDHelper.getUserFriendlyPPID((byte[])SecureRandom.getSeed(32));
            account.setPasswordResetCode(passwordResetCode.replaceAll("-", ""));
            ((IUserAccountService)userAccountService.get()).modifyAccount(account);
            new EmailUtils().sendPasswordResetCode(userProfile.getEmail(), passwordResetCode);
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    protected UIResponseAndTO[] getAnds(UserAccount userAccount, UserChoiceTree uct, WebForm webForm, X509Certificate[] sslCerts) throws RppsException, UserProfileException {
        Utils.cleanURLQuery(webForm);
        ArrayList<UIResponseAndTO> andList = new ArrayList<UIResponseAndTO>();
        if (uct != null) {
            ListIterator li = uct.getListIterator();
            while (li.hasNext()) {
                Object child = li.next();
                UIResponseAndTO and = new UIResponseAndTO();
                if (child instanceof UserChoiceTree) {
                    ArrayList<UIResponseOrTO> orList = new ArrayList<UIResponseOrTO>();
                    ListIterator li2 = ((UserChoiceTree)child).getListIterator();
                    while (li2.hasNext()) {
                        Object child2 = li2.next();
                        UIResponseOrTO or = new UIResponseOrTO();
                        if (child2 instanceof UserChoiceTree) {
                            ArrayList<UIResponseAndTO> andList2 = new ArrayList<UIResponseAndTO>();
                            ListIterator li3 = ((UserChoiceTree)child2).getListIterator();
                            while (li3.hasNext()) {
                                Object child3 = li3.next();
                                UIResponseAndTO and2 = new UIResponseAndTO();
                                boolean cfr_ignored_0 = child3 instanceof UCTelm;
                                andList2.add(and2);
                            }
                        } else if (child2 instanceof UCTelm) {
                            IPolicy atom = ((UCTelm)child2).getAtom();
                            UIResponseClauseTO clause = new UIResponseClauseTO();
                            RPPolicy policy = ConvertHelper.convertIPolicyToRPPolicy(atom);
                            clause.setLabelType(policy.getLabelType());
                            clause.setLabel(policy.getLabel());
                            clause.setLonglabel(policy.getLonglabel());
                            clause.setOptional(policy.getOptional());
                            clause.setLongOptional(policy.getLongOptional());
                            clause.setOptionalType(policy.getOptionalType());
                            PolicyVersion policyVersion = ((IUserProfileService)userProfileService.get()).getRPPolicyVersion(userAccount.getUserId(), webForm);
                            if (atom instanceof ICardSpacePolicy) {
                                ICardSpacePolicy icp = (ICardSpacePolicy)atom;
                                if (policyVersion != null && policyVersion.getVersion() != null && !policyVersion.getVersion().equals(icp.getPrivacyVersion())) {
                                    try {
                                        IPolicy oldPolicy = ICardSelectorService.getInstance().parsePolicy(policyVersion.getPolicy());
                                        RPPolicy oldRpPolicy = ConvertHelper.convertIPolicyToRPPolicy(oldPolicy);
                                        clause.setOldPolicy(oldRpPolicy);
                                    }
                                    catch (Exception e) {
                                        LOG.error((Object)e, (Throwable)e);
                                    }
                                }
                            }
                            UIResponseUsableCardsTO uc = new UIResponseUsableCardsTO();
                            ArrayList<UIResponseCardTO> cardList = new ArrayList<UIResponseCardTO>();
                            Iterator it = ((UCTelm)child2).getCredsIterator();
                            while (it != null && it.hasNext()) {
                                UIResponseCardTO card = new UIResponseCardTO();
                                CredentialContainer cc = (CredentialContainer)it.next();
                                ICard cred = cc.getCredential();
                                try {
                                    Iterator iterator = cred.getSupportedClaimTypes();
                                    while (iterator.hasNext()) {
                                        IClaimType claimTypeItem = (IClaimType)iterator.next();
                                        int i = 0;
                                        while (i < clause.getLabel().length) {
                                            if (claimTypeItem != null && claimTypeItem.getType().equals(clause.getLabel()[i])) {
                                                clause.getLabel()[i] = claimTypeItem.getDisplayName();
                                            }
                                            ++i;
                                        }
                                    }
                                }
                                catch (Exception e) {
                                    LOG.warn((Object)e, (Throwable)e);
                                }
                                CardInformation cardInformation = ((IUserProfileService)userProfileService.get()).getCardInformation(userAccount.getUserId(), cred.getCUID());
                                card = this.convertICard_To_UIResponseCardTO(userAccount, cred, webForm, atom, cardInformation, sslCerts);
                                card.setCardId(cc.key);
                                cardList.add(card);
                            }
                            UIResponseCardTO[] cards = new UIResponseCardTO[cardList.size()];
                            cardList.toArray(cards);
                            uc.setCard(cards);
                            clause.setUsableCards(uc);
                            List usedCard = this.getUsedCards(userAccount, webForm);
                            String[] usedCardCuids = new String[usedCard.size()];
                            int index = 0;
                            while (index < usedCard.size()) {
                                usedCardCuids[index] = ((CardUsage)usedCard.get(index)).getCuid().toString();
                                ++index;
                            }
                            clause.setUsedCardCuids(usedCardCuids);
                            or.setClause(clause);
                        }
                        orList.add(or);
                    }
                    UIResponseOrTO[] ors = new UIResponseOrTO[orList.size()];
                    orList.toArray(ors);
                    and.setOr(ors);
                } else {
                    boolean cfr_ignored_1 = child instanceof UCTelm;
                }
                andList.add(and);
            }
        }
        UIResponseAndTO[] ands = new UIResponseAndTO[andList.size()];
        andList.toArray(ands);
        return ands;
    }

    public Captcha getCaptcha(String id) throws RppsException {
        try {
            return ((IUserProfileService)userProfileService.get()).getCaptcha(id);
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    protected List getCardHistory(UserAccount userAccount, CUID cuid) throws RppsException, UserProfileException {
        try {
            return ((IUserProfileService)userProfileService.get()).getCardUsageSummary(userAccount.getUserId(), cuid);
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    protected List getCardHistory(UserAccount userAccount, CUID cuid, int startFrom, int size, String orderBy, boolean desc) throws RppsException, UserProfileException {
        try {
            return ((IUserProfileService)userProfileService.get()).getCardUsageSummary(userAccount.getUserId(), cuid, startFrom, size, orderBy, desc);
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    public CardUsageTO[] getCardHistory(UserAccount userAccount, String cuid, int startFrom, int size, String orderBy, String orderDirection) {
        boolean desc = orderDirection.equalsIgnoreCase("desc");
        String order = "site";
        if ("date".equalsIgnoreCase(orderBy)) {
            order = "date";
        } else if ("site".equalsIgnoreCase(orderBy)) {
            order = "useAlways";
        }
        try {
            List list = this.getCardHistory(userAccount, new CUID(cuid), startFrom, size, order, desc);
            CardUsageTO[] arrayUsage = new CardUsageTO[list.size()];
            int i = 0;
            while (i < list.size()) {
                CardUsage cardUsage = (CardUsage)list.get(i);
                arrayUsage[i] = ConvertHelper.convertCardUsage_to_CardUsageTO(cardUsage);
                ++i;
            }
            return arrayUsage;
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    public CardInformationTO getCardInformation(UserAccount userAccount, String cuid, int size) throws RppsException {
        try {
            return ConvertHelper.createCardInformationTO(this.getCardHistory(userAccount, new CUID(cuid), 0, size, "date", false), ((IUserProfileService)userProfileService.get()).getHistoryTotalSize(userAccount.getUserId(), new CUID(cuid)));
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    protected List getCategories(UserAccount userAccount) throws RppsException {
        LOG.trace((Object)"RppsService.getCategories(CallbackHandler) started");
        try {
            List list = ((IUserProfileService)userProfileService.get()).getCategories(userAccount.getUserId());
            Collections.sort(list, new CategoryComparator());
            return list;
        }
        catch (UserProfileException e) {
            LOG.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    public CategoryTO[] getCategory(UserAccount userAccount) throws RppsException {
        LOG.trace((Object)"RppsService.getCategory() started");
        try {
            List category = this.getCategories(userAccount);
            CategoryTO[] categorysTO = new CategoryTO[]{};
            if (category != null) {
                categorysTO = new CategoryTO[category.size()];
                int i = 0;
                while (i < category.size()) {
                    categorysTO[i] = ConvertHelper.convertCategory_to_CategoryTO((Category)category.get(i));
                    ++i;
                }
            }
            return categorysTO;
        }
        catch (RppsException e) {
            LOG.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    public MapTO[] getClaimValuesMRU(UserAccount userAccount) throws RppsException {
        try {
            Map claimValuesMRU = ((IUserProfileService)userProfileService.get()).getClaimValuesMRU(userAccount.getUserId());
            if (claimValuesMRU != null && claimValuesMRU.keySet() != null) {
                ArrayList<MapTO> result = new ArrayList<MapTO>();
                Iterator iter = claimValuesMRU.keySet().iterator();
                while (iter.hasNext()) {
                    String[] values;
                    MapTO mruTO = new MapTO();
                    String key = (String)iter.next();
                    Set valuesSet = (Set)claimValuesMRU.get(key);
                    if (valuesSet == null || (values = new String[valuesSet.size()]) == null || values.length <= 0) continue;
                    valuesSet.toArray(values);
                    if (values != null) {
                        Arrays.sort(values, new StringComparator());
                    }
                    mruTO.setKey(key);
                    mruTO.setValues(values);
                    result.add(mruTO);
                }
                MapTO[] resultMRU = new MapTO[result.size()];
                result.toArray(resultMRU);
                return resultMRU;
            }
            return new MapTO[0];
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    protected CUID getCuidByWebForm(UserAccount userAccount, WebForm webForm) throws RppsException {
        try {
            Utils.cleanURLQuery(webForm);
            return ((IUserProfileService)userProfileService.get()).getUsedAlwaysCard(userAccount.getUserId(), webForm);
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    public ICardTO getDefaultPCard(UserAccount userAccount) throws RppsException {
        try {
            String defaultPCardCUID = ((IUserProfileService)userProfileService.get()).getUserProfile(userAccount.getUserId()).getDefaultPCardCUID();
            if (defaultPCardCUID != null && defaultPCardCUID.length() > 0) {
                return this.convertICard_To_ICardTO(userAccount, ICardRegistry.getInstance().getICardByCUID(RppsHelper.getCallbackHandler(userAccount.getUserId()), defaultPCardCUID), false, null);
            }
            return null;
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    protected ICard getICardByCUID(UserAccount userAccount, CUID cuid) throws RppsException {
        try {
            return ICardRegistry.getInstance().getICardByCUID(RppsHelper.getCallbackHandler(userAccount.getUserId()), cuid);
        }
        catch (CardException e) {
            LOG.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    public ICardTO getICardByCUID(UserAccount userAccount, String cuid) throws RppsException {
        try {
            ICard card = this.getICardByCUID(userAccount, new CUID(cuid));
            return this.convertICard_To_ICardTO(userAccount, card, false, null);
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    public ICardTO getICardByCUIDAndTokenServiceCredential(UserAccount userAccount, String cuid, UITokenServiceCredentialTO tokenCredential) throws RppsException, STSFaultException {
        try {
            ICard card = this.getICardByCUID(userAccount, new CUID(cuid));
            if (card == null) {
                throw new RppsException("Can't find card with CUID " + cuid);
            }
            CardInformation cardInformation = ((IUserProfileService)userProfileService.get()).getCardInformation(userAccount.getUserId(), new CUID(cuid));
            ICredential credential = null;
            if (cardInformation.getCardCredential() != null) {
                credential = ConvertHelper.convertCardCredential_to_ICredential(card, cardInformation.getCardCredential());
            } else if (tokenCredential != null) {
                credential = ConvertHelper.convertUITokenServiceCredentialTO_to_ICredentials(card, tokenCredential);
            }
            if (credential != null) {
                card = card.getProvider().getICardByCUID(RppsHelper.getCallbackHandler(userAccount.getUserId()), card.getCUID(), credential);
            }
            return this.convertICard_To_ICardTO(userAccount, card, true, null);
        }
        catch (STSFaultException stse) {
            throw stse;
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    protected ICard getICardByPPID(UserAccount userAccount, X509Certificate x509cert, String ppid, URI address) throws RppsException {
        SelectionANDofORs subselection;
        block8: {
            try {
                byte[] bppid = Base64.decode((String)ppid);
                IKeyStoreService securityService = KeyStoreRegistry.getInstance().getSecurityService();
                X509Certificate[] chainOriginal = new X509Certificate[]{x509cert};
                X509Certificate[] chain = null;
                if (chainOriginal != null) {
                    try {
                        chain = securityService.getNormalizedCertificateChain(RppsHelper.getCallbackHandler(userAccount.getUserId()), chainOriginal, null);
                    }
                    catch (CertificateException e) {
                        LOG.error((Object)e, (Throwable)e);
                    }
                    catch (CertStoreException e) {
                        LOG.error((Object)e, (Throwable)e);
                    }
                }
                if (chain == null) {
                    chain = chainOriginal;
                }
                PPIDCardSpacePolicy policy = new PPIDCardSpacePolicy(chain, securityService.getCertStore(RppsHelper.getCallbackHandler(userAccount.getUserId())), bppid, address.toString());
                IICardSelector selector = ICardSelectorService.getInstance().getICardSelector(RppsHelper.getCallbackHandler(userAccount.getUserId()), (IPolicy)policy);
                UserChoiceTree_ANDofORs uct = (UserChoiceTree_ANDofORs)selector.getUserChoice();
                subselection = uct.getDefaultSelection();
                if (!subselection.isEmpty()) break block8;
                LOG.debug((Object)"Cannot find the Personal card used to authenticate for this managed card.");
                return null;
            }
            catch (Exception e) {
                LOG.error((Object)e, (Throwable)e);
                throw new RppsException(e);
            }
        }
        String cuid = ((SelectionANDofORsElm)subselection.getElements().get(0)).getUUID();
        return this.getICardByCUID(userAccount, new CUID(cuid));
    }

    public UIResponseCardTO getICardClaims(UserAccount userAccount, String cuid, String policy, String typeofCredential, String[] credentialKey, String[] credentialValue) throws RppsException, STSFaultException {
        try {
            ICard card;
            RppsService.AllowSelfSignedSSL();
            Hashtable<String, String> table = new Hashtable<String, String>();
            int i = 0;
            while (i < credentialKey.length) {
                if (credentialKey[i] != null && credentialValue[i] != null) {
                    table.put(credentialKey[i], credentialValue[i]);
                }
                ++i;
            }
            URI url = null;
            if (table.get("url") != null) {
                url = new URI((String)table.get("url"));
            }
            X509Certificate[] sslCertsOriginal = null;
            if (table.get("cert") != null && (sslCertsOriginal = RppsHelper.parseSSLCert((String)table.get("cert"))) != null) {
                X509Certificate[] sslCerts = null;
                try {
                    sslCerts = KeyStoreRegistry.getInstance().getSecurityService().getNormalizedCertificateChain(RppsHelper.getCallbackHandler(userAccount.getUserId()), sslCertsOriginal, null);
                    if (sslCerts != null) {
                        sslCertsOriginal = sslCerts;
                    }
                }
                catch (CertificateException e) {
                    LOG.error((Object)e, (Throwable)e);
                }
                catch (CertStoreException e) {
                    LOG.error((Object)e, (Throwable)e);
                }
            }
            if ((card = this.getICardByCUID(userAccount, new CUID(cuid))) != null) {
                CardInformation cardInformation = ((IUserProfileService)userProfileService.get()).getCardInformation(userAccount.getUserId(), new CUID(cuid));
                ICredential credential = cardInformation != null && cardInformation.getCardCredential() != null ? ConvertHelper.convertCardCredential_to_ICredential(card, cardInformation.getCardCredential()) : ConvertHelper.convertHashtable_to_Credential(card, typeofCredential, table);
                if (credential != null) {
                    card = card.getProvider().getICardByCUID(RppsHelper.getCallbackHandler(userAccount.getUserId()), card.getCUID(), credential);
                }
                ICardSpacePolicy policyTemp = (ICardSpacePolicy)ICardSelectorService.getInstance().parsePolicy(policy);
                return this.convertICard_To_UIResponseCardTO(userAccount, card, new WebForm(url, null, null, null), (IPolicy)policyTemp, cardInformation, sslCertsOriginal);
            }
            throw new RppsException("Didn't find card with cuid=" + cuid);
        }
        catch (STSFaultException stse) {
            LOG.error((Object)stse, (Throwable)stse);
            throw stse;
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    public UIResponseCardTO getICardClaims(UserAccount userAccount, String cuid, String policy, String typeofCredential, String[] credentialKey, String[] credentialValue, RPEndPointTO rpEndPointTO) throws RppsException {
        try {
            ICard card;
            RppsService.AllowSelfSignedSSL();
            Hashtable<String, String> table = new Hashtable<String, String>();
            int i = 0;
            while (i < credentialKey.length) {
                if (credentialKey[i] != null && credentialValue[i] != null) {
                    table.put(credentialKey[i], credentialValue[i]);
                }
                ++i;
            }
            WebForm webForm = ConvertHelper.convertRPEndPointTOToWebForm(rpEndPointTO);
            Utils.cleanURLQuery(webForm);
            X509Certificate[] sslCertsOriginal = null;
            if (table.get("cert") != null && (sslCertsOriginal = RppsHelper.parseSSLCert((String)table.get("cert"))) != null) {
                X509Certificate[] sslCerts = null;
                try {
                    sslCerts = KeyStoreRegistry.getInstance().getSecurityService().getNormalizedCertificateChain(RppsHelper.getCallbackHandler(userAccount.getUserId()), sslCertsOriginal, null);
                    if (sslCerts != null) {
                        sslCertsOriginal = sslCerts;
                    }
                }
                catch (CertificateException e) {
                    LOG.error((Object)e, (Throwable)e);
                }
                catch (CertStoreException e) {
                    LOG.error((Object)e, (Throwable)e);
                }
            }
            if ((card = this.getICardByCUID(userAccount, new CUID(cuid))) != null) {
                CardInformation cardInformation = ((IUserProfileService)userProfileService.get()).getCardInformation(userAccount.getUserId(), new CUID(cuid));
                ICredential credential = cardInformation != null && cardInformation.getCardCredential() != null ? ConvertHelper.convertCardCredential_to_ICredential(card, cardInformation.getCardCredential()) : ConvertHelper.convertHashtable_to_Credential(card, typeofCredential, table);
                if (credential != null) {
                    card = card.getProvider().getICardByCUID(RppsHelper.getCallbackHandler(userAccount.getUserId()), card.getCUID(), credential);
                }
                ICardSpacePolicy policyTemp = (ICardSpacePolicy)ICardSelectorService.getInstance().parsePolicy(policy);
                return this.convertICard_To_UIResponseCardTO(userAccount, card, webForm, (IPolicy)policyTemp, cardInformation, sslCertsOriginal);
            }
            throw new RppsException("Didn't find card with cuid=" + cuid);
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    protected List getICardCreationTemplate(CallbackHandler handler) throws RppsException {
        return ICardRegistry.getInstance().getCardCreationTemplates(handler);
    }

    public ICardTemplateTO[] getICardCreationTemplate(UserAccount userAccount) {
        List templates = null;
        templates = this.getICardCreationTemplate(RppsHelper.getCallbackHandler(userAccount.getUserId()));
        ICardTemplateTO[] telmplateList = new ICardTemplateTO[]{};
        if (templates != null) {
            telmplateList = new ICardTemplateTO[templates.size()];
            int index = 0;
            while (index < templates.size()) {
                telmplateList[index] = ConvertHelper.convertICardTemplate_to_ICardTemplateTO((ICardTemplate)templates.get(index));
                ++index;
            }
        }
        return telmplateList;
    }

    public ICardTemplate[] getICardCreationTemplateByProvider(UserAccount userAccount, String extID) throws RppsException {
        ICardProvider provider = ICardRegistry.getInstance().getICardProvider(extID);
        return provider.getCardCreationTemplates(RppsHelper.getCallbackHandler(userAccount.getUserId()));
    }

    public ICardTemplateTO getICardCreationTemplateByTUID(UserAccount userAccount, String tuid) throws RppsException {
        ICardTemplate template = null;
        try {
            template = this.getICardCreationTemplateByTUID(userAccount, new TUID(tuid));
        }
        catch (CardException e) {
            LOG.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
        if (template != null) {
            return ConvertHelper.convertICardTemplate_to_ICardTemplateTO(template);
        }
        return null;
    }

    public ICardTemplate getICardCreationTemplateByTUID(UserAccount userAccount, TUID tuid) throws CardException {
        return ICardRegistry.getInstance().getCardCreationTemplatesByTUID(RppsHelper.getCallbackHandler(userAccount.getUserId()), tuid);
    }

    public ICardsAndCategoryTO getICardsAndCategoriesByUser(UserAccount userAccount) throws RppsException {
        LOG.trace((Object)"RppsService.getICardsAndCategoriesByUser() started");
        ICardsAndCategoryTO cardsAndCategoryTO = new ICardsAndCategoryTO();
        try {
            ICardResponseTO cardResponceTO = this.getICardsByUser(userAccount);
            cardsAndCategoryTO.setRelationList(cardResponceTO.getRelationList());
            cardsAndCategoryTO.setICardList(cardResponceTO.getICardList());
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
        }
        try {
            cardsAndCategoryTO.setCategoryList(this.getCategory(userAccount));
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
        }
        return cardsAndCategoryTO;
    }

    public ICardTO[] getICardsByCUIDs(UserAccount userAccount, String[] cuids) {
        ArrayList<ICardTO> result = new ArrayList<ICardTO>();
        int i = 0;
        while (i < cuids.length) {
            try {
                result.add(this.getICardByCUID(userAccount, cuids[i]));
            }
            catch (Exception e) {
                LOG.error((Object)e, (Throwable)e);
            }
            ++i;
        }
        return result.toArray(new ICardTO[result.size()]);
    }

    public ICardTO[] getICardsByFormat(UserAccount userAccount, String formatID) throws RppsException {
        ICardTO[] icards;
        block10: {
            icards = new ICardTO[]{};
            try {
                ArrayList cards = new ArrayList();
                try {
                    Iterator iter = ICardRegistry.getInstance().getICardsByFormat(RppsHelper.getCallbackHandler(userAccount.getUserId()), formatID);
                    while (iter.hasNext()) {
                        try {
                            cards.add(iter.next());
                        }
                        catch (Exception e) {
                            LOG.error((Object)e, (Throwable)e);
                        }
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)e, (Throwable)e);
                }
                if (cards == null) break block10;
                icards = new ICardTO[cards.size()];
                int i = 0;
                while (i < cards.size()) {
                    try {
                        icards[i] = this.convertICard_To_ICardTO(userAccount, (ICard)cards.get(i), false, null);
                    }
                    catch (Exception e) {
                        LOG.error((Object)e, (Throwable)e);
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                LOG.error((Object)e, (Throwable)e);
            }
        }
        return icards;
    }

    protected List getICardsByUser(CallbackHandler handlerLocal) {
        LOG.trace((Object)"RppsService.getICardsByUser() List started");
        ArrayList cards = new ArrayList();
        Iterator pit = ICardRegistry.getInstance().getICardProviders();
        while (pit.hasNext()) {
            ICardProvider provider = (ICardProvider)pit.next();
            LOG.trace((Object)("RppsService.getICardsByUser() processes icard probvider : " + provider.getID()));
            try {
                Iterator icards = provider.getICards(handlerLocal);
                while (icards.hasNext()) {
                    cards.add(icards.next());
                }
            }
            catch (Exception e) {
                LOG.error((Object)e, (Throwable)e);
            }
        }
        LOG.trace((Object)"RppsService.getICardsByUser() List finished");
        return cards;
    }

    public ICardResponseTO getICardsByUser(UserAccount userAccount) {
        LOG.trace((Object)"RppsService.getICardsByUser() started");
        ICardResponseTO cardResponceTO = new ICardResponseTO();
        try {
            List cards = null;
            cards = this.getICardsByUser(RppsHelper.getCallbackHandler(userAccount.getUserId()));
            if (cards != null) {
                cardResponceTO = this.convertICards_To_CardResponceTO(userAccount, cards);
            }
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
        }
        return cardResponceTO;
    }

    protected ICredential getICredentialByPPID(UserAccount userAccount, X509Certificate x509cert, String ppid, URI address) throws RppsException {
        ICredentialDescriptor[] der;
        block7: {
            block6: {
                ICard card;
                block5: {
                    try {
                        card = this.getICardByPPID(userAccount, x509cert, ppid, address);
                        if (card != null) break block5;
                        return null;
                    }
                    catch (Exception e) {
                        LOG.error((Object)e, (Throwable)e);
                        throw new RppsException(e);
                    }
                }
                der = card.getRequiredCredentials();
                if (der != null) break block6;
                return null;
            }
            if (der.length != 0) break block7;
            return null;
        }
        return der[0].getCredential();
    }

    public FormatDescriptorTO[] getOutputFormats(UserAccount userAccount) throws RppsException {
        try {
            IFormatDescriptor[] formatDescriptor = ICardRegistry.getInstance().getOutputFormats();
            if (formatDescriptor != null && formatDescriptor.length > 0) {
                FormatDescriptorTO[] formatDescriptorTO = new FormatDescriptorTO[formatDescriptor.length];
                int i = 0;
                while (i < formatDescriptor.length) {
                    formatDescriptorTO[i] = this.convertIFormatDescriptor_to_FormatDescriptorTO(userAccount, formatDescriptor[i]);
                    ++i;
                }
                return formatDescriptorTO;
            }
            return null;
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    public TokenResponseTO getTokenByRPEndPoint(UserAccount userAccount, String policy, String policytype, String sslCert, RPEndPointTO rpEndPointTO) throws RppsException {
        TokenResponseTO token;
        block11: {
            CUID cuidUrl;
            IPolicy iPolicy;
            WebForm webForm;
            block10: {
                block9: {
                    boolean result;
                    token = null;
                    webForm = ConvertHelper.convertRPEndPointTOToWebForm(rpEndPointTO);
                    Utils.cleanURLQuery(webForm);
                    PolicyVersion policyVersion = ((IUserProfileService)userProfileService.get()).getRPPolicyVersion(userAccount.getUserId(), webForm);
                    iPolicy = ICardSelectorService.getInstance().parsePolicy(policy);
                    if (policyVersion == null || !(iPolicy instanceof CardSpacePolicy) || (result = policyVersion.getVersion().equals(((CardSpacePolicy)iPolicy).getPrivacyVersion()))) break block9;
                    return null;
                }
                cuidUrl = this.getCuidByWebForm(userAccount, webForm);
                if (cuidUrl != null) break block10;
                return null;
            }
            try {
                CardInformation cardInformation = ((IUserProfileService)userProfileService.get()).getCardInformation(userAccount.getUserId(), cuidUrl);
                if (cardInformation == null) break block11;
                String[] cuids = new String[]{cuidUrl.toString()};
                ICard card = this.getICardByCUID(userAccount, cuidUrl);
                if (card == null) {
                    new RppsException("Does not find card with cuid " + cuidUrl.toString());
                }
                ICredential credential = null;
                credential = ConvertHelper.convertCardCredential_to_ICredential(card, cardInformation.getCardCredential());
                List optionalClaims = null;
                try {
                    optionalClaims = this.getUsersChoiceOfOptionalClaims(userAccount, card.getCUID(), webForm);
                }
                catch (Exception exc) {
                    LOG.error((Object)exc, (Throwable)exc);
                }
                if (iPolicy instanceof CardSpacePolicy && optionalClaims != null && optionalClaims.size() > 0) {
                    ((CardSpacePolicy)iPolicy).setOptionalClaims(optionalClaims);
                }
                if ((token = this.getTokenObject(userAccount, iPolicy, policytype, sslCert, cuids, credential, webForm)) != null && token.getTkn() != null && token.getTkn().length() > 0 && webForm != null) {
                    this.addCardHistory(userAccount, card.getCUID(), webForm);
                }
            }
            catch (Exception e) {
                LOG.error((Object)e, (Throwable)e);
            }
        }
        return token;
    }

    public TokenResponseTO getTokenByUrl(UserAccount userAccount, String policy, String policytype, String sslCert, String url) throws RppsException {
        TokenResponseTO token = null;
        try {
            token = this.getTokenByRPEndPoint(userAccount, policy, policytype, sslCert, new RPEndPointTO().setUrl(Utils.cleanURLQuery(url)));
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
        }
        return token;
    }

    public ExtraTokenResponseTO getTokenExtraByRPEndPoint(UserAccount userAccount, String policy, String policytype, String sslCert, RPEndPointTO rpEndPointTO) throws RppsException {
        ExtraTokenResponseTO token;
        block11: {
            CUID cuidUrl;
            IPolicy iPolicy;
            WebForm webForm;
            block10: {
                block9: {
                    String privacyVersion;
                    token = null;
                    webForm = ConvertHelper.convertRPEndPointTOToWebForm(rpEndPointTO);
                    Utils.cleanURLQuery(webForm);
                    PolicyVersion policyVersion = ((IUserProfileService)userProfileService.get()).getRPPolicyVersion(userAccount.getUserId(), webForm);
                    iPolicy = ICardSelectorService.getInstance().parsePolicy(policy);
                    if (policyVersion == null || !(iPolicy instanceof CardSpacePolicy) || (privacyVersion = ((CardSpacePolicy)iPolicy).getPrivacyVersion()) == null || privacyVersion.trim().equals("") || policyVersion.getVersion().equals(privacyVersion)) break block9;
                    return null;
                }
                cuidUrl = this.getCuidByWebForm(userAccount, webForm);
                if (cuidUrl != null) break block10;
                return null;
            }
            try {
                TokenResponseTO tokenTO;
                CardInformation cardCredentialInfo = ((IUserProfileService)userProfileService.get()).getCardInformation(userAccount.getUserId(), cuidUrl);
                if (cardCredentialInfo == null) break block11;
                String[] cuids = new String[]{cardCredentialInfo.getCuid().toString()};
                ICard card = this.getICardByCUID(userAccount, cardCredentialInfo.getCuid());
                if (card == null) {
                    new RppsException("Does not find card with cuid " + cardCredentialInfo.getCuid().toString());
                }
                ICredential credential = null;
                credential = ConvertHelper.convertCardCredential_to_ICredential(card, cardCredentialInfo.getCardCredential());
                List optionalClaims = null;
                if (iPolicy instanceof CardSpacePolicy) {
                    try {
                        optionalClaims = this.getUsersChoiceOfOptionalClaims(userAccount, card.getCUID(), webForm);
                        ((CardSpacePolicy)iPolicy).setOptionalClaims(optionalClaims);
                    }
                    catch (Exception exc) {
                        LOG.error((Object)exc, (Throwable)exc);
                    }
                }
                if ((tokenTO = this.getTokenObject(userAccount, iPolicy, policytype, sslCert, cuids, credential, webForm)) != null && tokenTO.getTkn() != null && tokenTO.getTkn().length() > 0 && webForm != null) {
                    this.addCardHistory(userAccount, card.getCUID(), webForm);
                }
                token = new ExtraTokenResponseTO();
                token.setTkn(tokenTO.getTkn());
                token.setCardName(card.getName());
                token.setCardDescription(card.getDescription());
                token.setCardImage(card.getImage());
                token.setCardImageType(card.getImageType());
            }
            catch (Exception e) {
                LOG.error((Object)e, (Throwable)e);
            }
        }
        return token;
    }

    public ExtraTokenResponseTO getTokenExtraByUrl(UserAccount userAccount, String policy, String policytype, String sslCert, String url) throws RppsException {
        ExtraTokenResponseTO token = null;
        try {
            token = this.getTokenExtraByRPEndPoint(userAccount, policy, policytype, sslCert, new RPEndPointTO().setUrl(Utils.cleanURLQuery(url)));
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
        }
        return token;
    }

    public TokenResponseTO getTokenObject(UserAccount userAccount, IPolicy policy, String policytype, String sslCert, String[] cuids, ICredential credential, WebForm webForm) throws RppsException, STSFaultException {
        String token = null;
        Utils.cleanURLQuery(webForm);
        IKeyStoreService securityService = KeyStoreRegistry.getInstance().getSecurityService();
        SelectionANDofORs selection = new SelectionANDofORs();
        if (webForm != null && webForm.getUrl() != null) {
            selection.action = webForm.getUrl().toString();
        }
        selection.idemix_credential_db_uri = "credentials.db";
        selection.cardspace_credential_db_uri = "infocards.properties";
        selection.publickey_db_uri = "pk.db";
        X509Certificate[] chainOriginal = RppsHelper.parseSSLCert(sslCert);
        X509Certificate[] chain = null;
        if (chainOriginal != null) {
            try {
                chain = securityService.getNormalizedCertificateChain(RppsHelper.getCallbackHandler(userAccount.getUserId()), chainOriginal, null);
                securityService.putCertChain(chain);
            }
            catch (CertificateException e) {
                LOG.error((Object)e, (Throwable)e);
            }
            catch (CertStoreException e) {
                LOG.error((Object)e, (Throwable)e);
            }
        }
        if (chain == null) {
            chain = chainOriginal;
        }
        selection.sslCertChain = chain;
        selection.setCredential(credential);
        int i = 0;
        while (i < cuids.length) {
            String uid = cuids[i];
            int ui = 0;
            try {
                if (i < cuids.length - 1) {
                    ui = Integer.parseInt(cuids[++i]);
                }
            }
            catch (Exception ew) {
                ew.printStackTrace();
            }
            SelectionANDofORsElm se = new SelectionANDofORsElm(uid, ui, 0);
            selection.add(se);
            ++i;
        }
        try {
            IICardSelector selector = ICardSelectorService.getInstance().getICardSelector(RppsHelper.getCallbackHandler(userAccount.getUserId()), policy);
            IIdentityToken iToken = selector.getIdentityToken(selection);
            token = iToken != null ? (String)iToken.getAs(String.class) : "";
        }
        catch (STSFaultException stse) {
            throw stse;
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            throw new RppsException(e.getMessage(), e);
        }
        return ConvertHelper.createTokenResponse(token);
    }

    protected TokenResponseTO getTokenObject(UserAccount userAccount, String policy, String policytype, String sslCert, String[] cuids, ICredential credential, CardInformation cardCredentialInfo, WebForm webForm, boolean saveCard, boolean saveCredential) throws RppsException, STSFaultException {
        TokenResponseTO token = null;
        Utils.cleanURLQuery(webForm);
        try {
            CUID cuid = null;
            if (cuids != null && cuids.length > 0) {
                cuid = new CUID(cuids[0]);
                if (!saveCredential && cardCredentialInfo != null && cardCredentialInfo.getCardCredential() != null) {
                    this.clearCardCredential(userAccount, cuid);
                }
            }
            IPolicy iPolicy = ICardSelectorService.getInstance().parsePolicy(policy);
            token = this.getTokenObject(userAccount, iPolicy, policytype, sslCert, cuids, credential, webForm);
            if (cuid != null && token != null && token.getTkn() != null && token.getTkn().length() > 0) {
                if (webForm != null) {
                    this.addCardHistory(userAccount, cuid, webForm);
                    if (iPolicy instanceof CardSpacePolicy) {
                        ICardSpacePolicy iCardSpacePolicy;
                        List claimTypeList = ((CardSpacePolicy)iPolicy).getOptionalClaims();
                        if (claimTypeList != null && claimTypeList.size() > 0) {
                            this.saveUsersChoiceOfOptionalClaims(userAccount, cuid, webForm, claimTypeList);
                        }
                        if ((iCardSpacePolicy = (ICardSpacePolicy)iPolicy) != null && iCardSpacePolicy.getPrivacyVersion() != null && iCardSpacePolicy.getPrivacyVersion().length() > 0) {
                            PolicyVersion policyVersion = new PolicyVersion();
                            policyVersion.setForm(webForm);
                            policyVersion.setPolicy(policy);
                            policyVersion.setVersion(iCardSpacePolicy.getPrivacyVersion());
                            ((IUserProfileService)userProfileService.get()).setRPPolicyVersion(userAccount.getUserId(), policyVersion);
                        }
                    }
                }
                if (saveCard && webForm != null) {
                    ((IUserProfileService)userProfileService.get()).setUsedAlways(userAccount.getUserId(), cuid, webForm);
                }
                if (saveCredential) {
                    CardCredential cardCredential = ConvertHelper.convertICredential_to_CardCredential(credential);
                    this.setCardCredential(userAccount, cuid, cardCredential);
                }
            }
        }
        catch (STSFaultException stse) {
            throw stse;
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
        return token;
    }

    public TokenResponseTO getTokenObject(UserAccount userAccount, String policy, String policytype, String sslCert, String[] cuids, String typeofCredential, String[] credentialKey, String[] credentialValue) throws RppsException, STSFaultException {
        TokenResponseTO token = null;
        try {
            ICard card;
            RppsService.AllowSelfSignedSSL();
            Hashtable<String, String> table = new Hashtable<String, String>();
            boolean saveCard = false;
            boolean saveCredential = false;
            String urlStr = null;
            int i = 0;
            while (i < credentialKey.length) {
                if (credentialKey[i] != null && credentialValue[i] != null) {
                    table.put(credentialKey[i], credentialValue[i]);
                    LOG.debug((Object)("Put in table key='" + credentialKey[i] + "' with value='" + credentialValue[i] + "'"));
                }
                ++i;
            }
            if (table.get("saveCard") != null && "true".equalsIgnoreCase((String)table.get("saveCard"))) {
                saveCard = true;
            }
            if (table.get("saveCredential") != null && "true".equalsIgnoreCase((String)table.get("saveCredential"))) {
                saveCredential = true;
            }
            if (table.get("url") != null) {
                urlStr = Utils.cleanURLQuery((String)table.get("url"));
            }
            WebForm webForm = null;
            if (urlStr != null && urlStr.length() > 0) {
                webForm = new WebForm(new URI(urlStr), null, null, null);
            }
            ICredential credential = null;
            CardInformation cardCredentialInfo = null;
            if (cuids != null && cuids.length > 0 && (card = this.getICardByCUID(userAccount, new CUID(cuids[0]))) != null) {
                CUID cuidUrl = null;
                if (webForm != null) {
                    cuidUrl = this.getCuidByWebForm(userAccount, webForm);
                }
                if (cuidUrl != null && cuidUrl.equals((Object)card.getCUID()) && !saveCard) {
                    this.deleteWebFormCardRelation(userAccount, card.getCUID(), webForm);
                }
                credential = (cardCredentialInfo = ((IUserProfileService)userProfileService.get()).getCardInformation(userAccount.getUserId(), card.getCUID())) != null && cardCredentialInfo.getCardCredential() != null ? ConvertHelper.convertCardCredential_to_ICredential(card, cardCredentialInfo.getCardCredential()) : ConvertHelper.convertHashtable_to_Credential(card, typeofCredential, table);
            }
            token = this.getTokenObject(userAccount, policy, policytype, sslCert, cuids, credential, cardCredentialInfo, webForm, saveCard, saveCredential);
        }
        catch (STSFaultException stse) {
            throw stse;
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
        return token;
    }

    public TokenResponseTO getTokenObject(UserAccount userAccount, String policy, String policytype, String sslCert, String[] cuids, String typeofCredential, String[] credentialKey, String[] credentialValue, RPEndPointTO rpEndPointTO) throws RppsException, STSFaultException {
        TokenResponseTO token = null;
        try {
            ICard card;
            RppsService.AllowSelfSignedSSL();
            Hashtable<String, String> table = new Hashtable<String, String>();
            boolean saveCard = false;
            boolean saveCredential = false;
            int i = 0;
            while (i < credentialKey.length) {
                if (credentialKey[i] != null && credentialValue[i] != null) {
                    table.put(credentialKey[i], credentialValue[i]);
                    LOG.debug((Object)("Put in table key='" + credentialKey[i] + "' with value='" + credentialValue[i] + "'"));
                }
                ++i;
            }
            if (table.get("saveCard") != null && "true".equalsIgnoreCase((String)table.get("saveCard"))) {
                saveCard = true;
            }
            if (table.get("saveCredential") != null && "true".equalsIgnoreCase((String)table.get("saveCredential"))) {
                saveCredential = true;
            }
            WebForm webForm = ConvertHelper.convertRPEndPointTOToWebForm(rpEndPointTO);
            Utils.cleanURLQuery(webForm);
            ICredential credential = null;
            CardInformation cardCredentialInfo = null;
            if (cuids != null && cuids.length > 0 && (card = this.getICardByCUID(userAccount, new CUID(cuids[0]))) != null) {
                cardCredentialInfo = null;
                CUID cuidUrl = null;
                if (webForm != null) {
                    cuidUrl = this.getCuidByWebForm(userAccount, webForm);
                }
                if (cuidUrl != null && cuidUrl.equals((Object)card.getCUID()) && !saveCard) {
                    this.deleteWebFormCardRelation(userAccount, card.getCUID(), webForm);
                }
                credential = (cardCredentialInfo = ((IUserProfileService)userProfileService.get()).getCardInformation(userAccount.getUserId(), card.getCUID())) != null && cardCredentialInfo.getCardCredential() != null ? ConvertHelper.convertCardCredential_to_ICredential(card, cardCredentialInfo.getCardCredential()) : ConvertHelper.convertHashtable_to_Credential(card, typeofCredential, table);
            }
            token = this.getTokenObject(userAccount, policy, policytype, sslCert, cuids, credential, cardCredentialInfo, webForm, saveCard, saveCredential);
        }
        catch (STSFaultException stse) {
            throw stse;
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
        return token;
    }

    private List getUsedCards(UserAccount userAccount, WebForm webForm) throws RppsException {
        try {
            Utils.cleanURLQuery(webForm);
            return ((IUserProfileService)userProfileService.get()).getUsedCards(userAccount.getUserId(), webForm);
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    public UIResponseTO getUserInterface(UserAccount userAccount, RPEndPointTO rpEndPointTO, String target, String sslCert, String policytype, String policy) throws RppsException {
        X509Certificate[] sslCertsOriginal;
        UserInterfaceResponse uir;
        block11: {
            uir = new UserInterfaceResponse();
            sslCertsOriginal = null;
            try {
                WebForm webForm = ConvertHelper.convertRPEndPointTOToWebForm(rpEndPointTO);
                IICardSelector selector = ICardSelectorService.getInstance().getICardSelector(RppsHelper.getCallbackHandler(userAccount.getUserId()), policy);
                uir.setUCL(selector.getUserChoice());
                sslCertsOriginal = RppsHelper.parseSSLCert(sslCert);
                if (sslCertsOriginal == null) break block11;
                X509Certificate cert = null;
                if (sslCertsOriginal != null && sslCertsOriginal.length > 0) {
                    cert = KeyStoreRegistry.getInstance().getSecurityService().findLeafFromCertificates(sslCertsOriginal);
                }
                uir.setRequestorInformation(cert);
                IKeyStoreService securityService = KeyStoreRegistry.getInstance().getSecurityService();
                boolean isValid = false;
                boolean isExtendedValid = false;
                X509Certificate[] sslCerts = null;
                try {
                    sslCerts = securityService.getNormalizedCertificateChain(RppsHelper.getCallbackHandler(userAccount.getUserId()), sslCertsOriginal, null);
                    if (sslCerts != null) {
                        isValid = true;
                        sslCertsOriginal = sslCerts;
                    }
                }
                catch (CertificateException e) {
                    LOG.error((Object)e, (Throwable)e);
                }
                catch (CertStoreException e) {
                    LOG.error((Object)e, (Throwable)e);
                }
                if (isValid) {
                    isExtendedValid = securityService.extendendValidationCertificateChain(RppsHelper.getCallbackHandler(userAccount.getUserId()), sslCertsOriginal, webForm.getUrl());
                }
                uir.setValid(isValid);
                uir.setExtendedValid(isExtendedValid);
            }
            catch (Exception e) {
                LOG.error((Object)e, (Throwable)e);
                throw new RppsException(e);
            }
        }
        UIResponseTO uirto = new UIResponseTO();
        try {
            WebForm webForm = ConvertHelper.convertRPEndPointTOToWebForm(rpEndPointTO);
            Utils.cleanURLQuery(webForm);
            if (uir != null) {
                uirto.setStatus("ok");
                UIResponseRPTO rp = new UIResponseRPTO();
                rp.setName(uir.getName());
                rp.setAddr1(uir.getAddr1());
                rp.setAddr2(uir.getAddr2());
                rp.setPhone(uir.getPhone());
                rp.setVerifier(uir.getVerifier());
                rp.setValid(uir.isValid());
                rp.setExtendedValid(uir.isExtendedValid());
                uirto.setRP(rp);
                uirto.setAnd(this.getAnds(userAccount, uir.getUCL(), webForm, sslCertsOriginal));
            }
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
        return uirto;
    }

    public UIResponseTO getUserInterface(UserAccount userAccount, String url, String target, String sslCert, String policytype, String policy) throws RppsException {
        try {
            return this.getUserInterface(userAccount, new RPEndPointTO().setUrl(url), target, sslCert, policytype, policy);
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    public UserProfileTO getUserProfile(UserAccount userAccount) throws RppsException, UserProfileException, UserAccountException {
        UserProfile userProfile = ((IUserProfileService)userProfileService.get()).getUserProfile(userAccount.getUserId());
        return ConvertHelper.convertUserProfile_to_UserProfileTO(userProfile, ((IUserAccountService)userAccountService.get()).getAccount(userAccount.getUserId()));
    }

    private List getUsersChoiceOfOptionalClaims(UserAccount userAccount, CUID cuid, WebForm webForm) {
        try {
            Utils.cleanURLQuery(webForm);
            Set optionalClaims = ((IUserProfileService)userProfileService.get()).getOptionalClaims(userAccount.getUserId(), cuid, webForm);
            if (optionalClaims != null) {
                return new ArrayList(optionalClaims);
            }
            return new ArrayList();
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    public ICardResponseTO importICards(UserAccount userAccount, byte[] crd) throws RppsException {
        return this.importICards(userAccount, crd, null, null);
    }

    public ICardResponseTO importICards(UserAccount userAccount, byte[] crd, String formatID, UITokenServiceCredentialTO credential, Boolean[] importFlag) throws RppsException {
        try {
            List cards = null;
            cards = this.importICards(userAccount, new ByteArrayInputStream(crd), formatID, ConvertHelper.convertUITokenServiceCredentialTO_to_ICredentials(credential), importFlag);
            return this.convertICards_To_CardResponceTO(userAccount, cards);
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    public ICardResponseTO importICards(UserAccount userAccount, byte[] crd, String formatID, UITokenServiceCredentialTO credential) throws RppsException {
        try {
            List cards = null;
            cards = this.importICards(userAccount, new ByteArrayInputStream(crd), formatID, ConvertHelper.convertUITokenServiceCredentialTO_to_ICredentials(credential), null);
            return this.convertICards_To_CardResponceTO(userAccount, cards);
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    protected List importICards(UserAccount userAccount, InputStream in, String formatID, ICredential credential, Boolean[] importFlag) throws RppsException {
        try {
            ArrayList<ICard> result = new ArrayList<ICard>();
            Iterator iter = ICardRegistry.getInstance().importICards(RppsHelper.getCallbackHandler(userAccount.getUserId()), in, formatID, credential, importFlag);
            while (iter.hasNext()) {
                ICard card = (ICard)iter.next();
                new ResourceMetaDataHelper().updateCardMD(card.getCUID().toString(), (IResourceMetaDataService)metaDataService.get(), userAccount);
                result.add(card);
            }
            return result;
        }
        catch (CardException e) {
            LOG.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    public ResponseMessage modifyCategories(UserAccount userAccount, CategoryTO[] categoriesTO) throws RppsException {
        try {
            int i = 0;
            while (i < categoriesTO.length) {
                this.modifyCategory(userAccount, categoriesTO[i]);
                ++i;
            }
            return new ResponseMessage(0, "");
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            return new ResponseMessage(-1, e.getMessage());
        }
    }

    public CategoryTO modifyCategory(UserAccount userAccount, CategoryTO categoryTO) throws RppsException {
        try {
            Category category = ((IUserProfileService)userProfileService.get()).modifyCategory(userAccount.getUserId(), ConvertHelper.convertCategoryTO_to_Category(categoryTO));
            new ResourceMetaDataHelper().updateCategoryMD(category.getId(), (IResourceMetaDataService)metaDataService.get(), userAccount);
            return ConvertHelper.convertCategory_to_CategoryTO(category);
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    public void modifyPasswordWithOldPassword(String userIdentifier, String oldPassword, String newPassword) throws RppsException {
        try {
            Serializable id = ((IUserAccountService)userAccountService.get()).getAccountId(userIdentifier);
            this.authenticate(userIdentifier, oldPassword);
            UserProfile userProfile = ((IUserProfileService)userProfileService.get()).getUserProfile(id);
            Account account = ((IUserAccountService)userAccountService.get()).getAccount(id);
            if (newPassword == null) {
                throw new RppsException("Password shouldn't be null");
            }
            account.setPasswordHash(PasswordUtils.getPasswordHash((String)newPassword));
            ((IUserAccountService)userAccountService.get()).modifyAccount(account);
            new EmailUtils().sendPasswordUpdatedEmail(userProfile.getEmail());
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    public void modifyPasswordWithPasswordResetCode(String userIdentifier, String passwordResetCode, String newPassword) throws RppsException {
        try {
            Serializable id = ((IUserAccountService)userAccountService.get()).getAccountId(userIdentifier);
            UserProfile userProfile = ((IUserProfileService)userProfileService.get()).getUserProfile(id);
            Account account = ((IUserAccountService)userAccountService.get()).getAccount(id);
            if (account.getPasswordResetCode() == null || !account.getPasswordResetCode().equals(passwordResetCode.replaceAll("-", ""))) {
                throw new RppsException("Password reset code incorrect");
            }
            account.setPasswordResetCode(null);
            account.setPasswordHash(PasswordUtils.getPasswordHash((String)newPassword));
            ((IUserAccountService)userAccountService.get()).modifyAccount(account);
            new EmailUtils().sendPasswordUpdatedEmail(userProfile.getEmail());
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    public UserProfileTO modifyUserProfile(UserAccount userAccount, UserProfileTO userProfileTO) throws RppsException {
        try {
            UserProfile userProfile = ConvertHelper.convertUserProfileTO_to_UserProfile(new UserProfile().setUserIdentifier(userAccount.getUserId()), userProfileTO);
            ((IUserProfileService)userProfileService.get()).modifyUserProfile(userAccount.getUserId(), userProfile);
            new ResourceMetaDataHelper().updateUserProfileMD((IResourceMetaDataService)metaDataService.get(), (String)((Object)userAccount.getUserId()), userProfile);
            return this.getUserProfile(userAccount);
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    public void removeClaimValuesMRU(UserAccount userAccount, String claimType, String claimValue) throws RppsException {
        try {
            Set claimValuesMRU = ((IUserProfileService)userProfileService.get()).getClaimValuesMRU(userAccount.getUserId(), claimType);
            if (claimValuesMRU.contains(claimValue)) {
                claimValuesMRU.remove(claimValue);
                ((IUserProfileService)userProfileService.get()).setClaimValuesMRU(userAccount.getUserId(), claimType, claimValuesMRU);
            }
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    protected ICard resetPinCode(UserAccount userAccount, IPersonalInformationCard card, byte[] oldPinCode) throws RppsException {
        try {
            PinCodeCredential pinCodeCredential = new PinCodeCredential();
            pinCodeCredential.setPinCode(oldPinCode);
            card = (IPersonalInformationCard)card.getProvider().getICardByCUID(RppsHelper.getCallbackHandler(userAccount.getUserId()), card.getCUID(), (ICredential)pinCodeCredential);
            try {
                PinCodeCredential pinCodeCredentialNew = new PinCodeCredential();
                pinCodeCredentialNew.setPinCode(null);
                card.beginUpdates();
                card.setPinCode((IPinCodeCredential)pinCodeCredentialNew);
                card.applyUpdates();
            }
            catch (CardException e) {
                if (card.isEditMode()) {
                    card.cancelUpdates();
                }
                throw new RppsException(e);
            }
            return ICardRegistry.getInstance().getICardByCUID(RppsHelper.getCallbackHandler(userAccount.getUserId()), card.getCUID());
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    public ICardTO resetPinCode(UserAccount userAccount, String cuid, String oldPinCode) throws RppsException {
        ICard card = null;
        byte[] oldPinCode_ = null;
        try {
            card = this.getICardByCUID(userAccount, new CUID(cuid));
            if (card == null) {
                throw new RppsException("Can't find card with CUID " + cuid);
            }
            if (!(card instanceof IPersonalInformationCard)) {
                new RppsException("This card is not personal");
            }
            CardInformation cardInformation = null;
            if (oldPinCode == null) {
                cardInformation = ((IUserProfileService)userProfileService.get()).getCardInformation(userAccount.getUserId(), new CUID(cuid));
                if (cardInformation.getCardCredential() != null && "IPinCodeCredential".equals(cardInformation.getCardCredential().getCredentialType())) {
                    oldPinCode_ = cardInformation.getCardCredential().getPinCode();
                }
            } else {
                oldPinCode_ = oldPinCode.getBytes("UTF-8");
            }
            card = this.resetPinCode(userAccount, (IPersonalInformationCard)card, oldPinCode_);
            if (cardInformation != null) {
                this.clearCardCredential(userAccount, card.getCUID());
            }
            new ResourceMetaDataHelper().updateCardMD(cuid, (IResourceMetaDataService)metaDataService.get(), userAccount);
            return this.convertICard_To_ICardTO(userAccount, card, false, null);
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    private void saveUsersChoiceOfOptionalClaims(UserAccount userAccount, CUID cuid, WebForm webForm, List claims) throws UserProfileException {
        try {
            Utils.cleanURLQuery(webForm);
            HashSet optionalClaims = new HashSet(claims);
            ((IUserProfileService)userProfileService.get()).setOptionalClaims(userAccount.getUserId(), cuid, webForm, optionalClaims);
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    protected boolean setCardCredential(UserAccount userAccount, CUID cuid, CardCredential cardCredential) throws RppsException {
        try {
            ((IUserProfileService)userProfileService.get()).setCardCredential(userAccount.getUserId(), cuid, cardCredential);
            CardInformation cardInformation = ((IUserProfileService)userProfileService.get()).getCardInformation(userAccount.getUserId(), cuid);
            if (cardInformation.getCardCredential() != null && cardCredential != null || cardInformation.getCardCredential() == null && cardCredential == null) {
                ResourceMetaDataHelper resourceMetaDataHelper = new ResourceMetaDataHelper();
                resourceMetaDataHelper.updateCardMD(cuid.toString(), (IResourceMetaDataService)metaDataService.get(), userAccount);
                resourceMetaDataHelper.updateCardCredentialMD(cuid.toString(), (IResourceMetaDataService)metaDataService.get(), userAccount);
                return true;
            }
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
        return false;
    }

    public boolean setCardCredential(UserAccount userAccount, String cuid, UITokenServiceCredentialTO tokenCredential) throws RppsException {
        try {
            ICard card = this.getICardByCUID(userAccount, new CUID(cuid));
            if (card == null) {
                throw new RppsException("Can't find card with CUID " + cuid);
            }
            ICredential credential = ConvertHelper.convertUITokenServiceCredentialTO_to_ICredentials(card, tokenCredential);
            ICardProvider provider = card.getProvider();
            card = null;
            if (credential != null) {
                card = provider.getICardByCUID(RppsHelper.getCallbackHandler(userAccount.getUserId()), new CUID(cuid), credential);
            }
            if (card != null) {
                CardCredential cardCredential = ConvertHelper.convertUITokenServiceCredentialTO_to_CardCredential(tokenCredential);
                return this.setCardCredential(userAccount, new CUID(cuid), cardCredential);
            }
            throw new RppsException("Didn't set card credential.");
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            throw new RppsException(e.getMessage(), e);
        }
    }

    private void setComplexValues(UserAccount userAccount, IClaim claim, PropertyTO value) throws Exception {
        if (claim != null && claim instanceof IComplexClaim) {
            int size = value.getComplexValue().length;
            int index = 0;
            while (index < size) {
                PropertyTO propTO = value.getComplexValue()[index];
                IClaim claimValue = ((IComplexClaim)claim).getClaim(propTO.getClaimType());
                if (claimValue == null) {
                    claimValue = ((IComplexClaim)claim).createClaim(propTO.getClaimType());
                }
                if (propTO.getValueType() != null) {
                    this.setSimpleValues(userAccount, claimValue, propTO);
                } else {
                    this.setComplexValues(userAccount, claimValue, propTO);
                }
                ++index;
            }
        }
    }

    public void setDefaultPCard(UserAccount userAccount, String pcardId) throws RppsException {
        try {
            UserProfile userProfile = ((IUserProfileService)userProfileService.get()).getUserProfile(userAccount.getUserId());
            userProfile.setDefaultPCardCUID(pcardId);
            ((IUserProfileService)userProfileService.get()).modifyUserProfile(userAccount.getUserId(), userProfile);
            new ResourceMetaDataHelper().updateUserProfileMD((IResourceMetaDataService)metaDataService.get(), (String)((Object)userAccount.getUserId()), userProfile);
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    protected ICard setPinCode(UserAccount userAccount, IPersonalInformationCard card, byte[] pinCode) throws RppsException {
        try {
            PinCodeCredential pinCodeCredential = new PinCodeCredential();
            try {
                card.beginUpdates();
                pinCodeCredential.setPinCode(pinCode);
                card.setPinCode((IPinCodeCredential)pinCodeCredential);
                card.applyUpdates();
            }
            catch (CardException e) {
                if (card.isEditMode()) {
                    card.cancelUpdates();
                }
                throw new RppsException(e);
            }
            pinCodeCredential = new PinCodeCredential();
            pinCodeCredential.setPinCode(pinCode);
            return card.getProvider().getICardByCUID(RppsHelper.getCallbackHandler(userAccount.getUserId()), card.getCUID(), (ICredential)pinCodeCredential);
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    public ICardTO setPinCode(UserAccount userAccount, String cuid, String pinCode) throws RppsException {
        ICard card = null;
        try {
            card = ICardRegistry.getInstance().getICardByCUID(RppsHelper.getCallbackHandler(userAccount.getUserId()), cuid);
            if (!(card instanceof IPersonalInformationCard)) {
                new RppsException("This card is not personal");
            }
            card = this.setPinCode(userAccount, (IPersonalInformationCard)card, pinCode.getBytes("UTF-8"));
            new ResourceMetaDataHelper().updateCardMD(cuid, (IResourceMetaDataService)metaDataService.get(), userAccount);
            return this.convertICard_To_ICardTO(userAccount, card, false, null);
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    private void setSimpleValues(UserAccount userAccount, IClaim claim, PropertyTO value) throws Exception {
        if (claim != null && claim instanceof ISimpleClaim && ((ISimpleClaimType)claim.getType()).getDataType().getName().equals(value.getValueType())) {
            ArrayList<String> newValues = new ArrayList<String>();
            int index = 0;
            while (index < value.getValue().length) {
                newValues.add(value.getValue()[index]);
                try {
                    this.addClaimValuesMRU(userAccount, claim.getType().getType(), value.getValue()[index]);
                }
                catch (Exception e) {
                    LOG.error((Object)e, (Throwable)e);
                }
                ++index;
            }
            ((ISimpleClaim)claim).setValues(newValues);
        }
    }

    public AccessTokenTO signIn(AuthCredentialTO authCredentialTO) throws ConfigurationException, LoginException, AuthenticationException, UserProfileException {
        AccessTokenEntity accessToken = ((IAuthenticateService)authenticateService.get()).persistAccessToken(new AccessTokenEntity().setUserIdentifier(this.authenticate(authCredentialTO).getUserId().toString()));
        AccessTokenTO accessTokenTO = new AccessTokenTO();
        accessTokenTO.setId(accessToken.getId());
        accessTokenTO.setIssuedTime(accessToken.getIssuedTime());
        accessTokenTO.setMaxIdleTime(maxIdleTime);
        accessTokenTO.setMaxLiveTime(maxLiveTime);
        return accessTokenTO;
    }

    public AccessTokenTO signIn(UserAccount account) throws ConfigurationException, LoginException, AuthenticationException, UserProfileException {
        AccessTokenEntity accessToken = ((IAuthenticateService)authenticateService.get()).persistAccessToken(new AccessTokenEntity().setUserIdentifier(account.getUserId().toString()));
        AccessTokenTO accessTokenTO = new AccessTokenTO();
        accessTokenTO.setId(accessToken.getId());
        accessTokenTO.setIssuedTime(accessToken.getIssuedTime());
        accessTokenTO.setMaxIdleTime(maxIdleTime);
        accessTokenTO.setMaxLiveTime(maxLiveTime);
        return accessTokenTO;
    }

    public void signOut(String accessTokenId) throws ConfigurationException, LoginException {
        ((IAuthenticateService)authenticateService.get()).deleteAccessToken(accessTokenId);
    }

    private ICard updateCard(UserAccount userAccount, ICardTO icardTO) throws RppsException {
        ICard card = null;
        try {
            card = this.getICardByCUID(userAccount, new CUID(icardTO.getCuid()));
            CardInformation cardInformation = ((IUserProfileService)userProfileService.get()).getCardInformation(userAccount.getUserId(), card.getCUID());
            ICredential credential = null;
            if (cardInformation.getCardCredential() != null) {
                credential = ConvertHelper.convertCardCredential_to_ICredential(card, cardInformation.getCardCredential());
            } else if (icardTO.getTokenServiceCredentials() != null && icardTO.getTokenServiceCredentials().length != 0) {
                credential = ConvertHelper.convertUITokenServiceCredentialTO_to_ICredentials(card, icardTO.getTokenServiceCredentials()[0]);
            }
            if (credential != null) {
                card = card.getProvider().getICardByCUID(RppsHelper.getCallbackHandler(userAccount.getUserId()), card.getCUID(), credential);
            }
            card.beginUpdates();
            if (!RppsHelper.equalsObject(card.getName(), icardTO.getName())) {
                card.setName(icardTO.getName());
            }
            try {
                if (!RppsHelper.equalsObject(card.getIssuerName(), icardTO.getIssuerName())) {
                    card.setIssuerName(icardTO.getIssuerName());
                }
            }
            catch (Exception exc) {
                LOG.error((Object)exc, (Throwable)exc);
            }
            if (!RppsHelper.equalsObject(card.getImageType(), icardTO.getImageType()) || !RppsHelper.equalsObject(card.getImage(), icardTO.getImage())) {
                card.setImage(icardTO.getImage(), icardTO.getImageType());
            }
            try {
                CardExtensionTO[] cardExtensionTOs;
                if (card instanceof IInformationCard && (cardExtensionTOs = icardTO.getCardExtensions()) != null) {
                    int i = 0;
                    while (i < cardExtensionTOs.length) {
                        IInformationCardExtension[] cardExtensions = ((IInformationCard)card).getExtensions();
                        int j = 0;
                        while (j < cardExtensions.length) {
                            if (cardExtensions[j].getElement() != null && cardExtensions[j].getElement().getAs(String.class).toString().equalsIgnoreCase(cardExtensionTOs[i].getElement())) {
                                cardExtensions[j].setEnabled(cardExtensionTOs[i].isEnabled());
                            }
                            ++j;
                        }
                        ++i;
                    }
                }
            }
            catch (Exception e) {
                LOG.error((Object)e, (Throwable)e);
            }
            if (card instanceof IPersonalInformationCard && icardTO.getProperties() != null) {
                int size = icardTO.getProperties().length;
                int index = 0;
                while (index < size) {
                    PropertyTO propTO = icardTO.getProperties()[index];
                    IClaim claim = card.getClaim(propTO.getClaimType());
                    if (claim == null) {
                        claim = card.createClaim(propTO.getClaimType());
                    }
                    if (propTO.getComplexValue() == null) {
                        this.setSimpleValues(userAccount, claim, propTO);
                    } else {
                        this.setComplexValues(userAccount, claim, propTO);
                    }
                    ++index;
                }
            }
            card.applyUpdates();
            card = this.getICardByCUID(userAccount, new CUID(icardTO.getCuid()));
            new ResourceMetaDataHelper().updateCardMD(icardTO.getCuid(), (IResourceMetaDataService)metaDataService.get(), userAccount);
            return card;
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            try {
                if (card != null && card.isEditMode()) {
                    card.cancelUpdates();
                }
            }
            catch (Throwable throwable) {}
            throw new RppsException(e);
        }
    }

    public ICardUpdateResponseTO[] updateClaimsAcrossCards(UserAccount userAccount, String[] claimTypes, String[] claimValues, ICardUpdateTO[] cardUpdate) throws RppsException {
        ICard card = null;
        if (cardUpdate == null) {
            return new ICardUpdateResponseTO[0];
        }
        ICardUpdateResponseTO[] result = new ICardUpdateResponseTO[cardUpdate.length];
        int i = 0;
        while (i < cardUpdate.length) {
            block16: {
                try {
                    card = this.getICardByCUID(userAccount, new CUID(cardUpdate[i].getCuid()));
                    if (!(card instanceof IPersonalInformationCard)) break block16;
                    CardInformation cardInformation = ((IUserProfileService)userProfileService.get()).getCardInformation(userAccount.getUserId(), card.getCUID());
                    ICredential credential = null;
                    if (cardInformation.getCardCredential() != null) {
                        credential = ConvertHelper.convertCardCredential_to_ICredential(card, cardInformation.getCardCredential());
                    } else if (cardUpdate[i].getTokenServiceCredential() != null) {
                        credential = ConvertHelper.convertUITokenServiceCredentialTO_to_ICredentials(card, cardUpdate[i].getTokenServiceCredential());
                    }
                    if (credential != null) {
                        card = card.getProvider().getICardByCUID(RppsHelper.getCallbackHandler(userAccount.getUserId()), card.getCUID(), credential);
                    }
                    card.beginUpdates();
                    int index = 0;
                    while (index < claimTypes.length) {
                        String claimType = claimTypes[index];
                        String claimValue = claimValues[index];
                        IClaim claim = card.getClaim(claimType);
                        if (claim == null) {
                            claim = card.createClaim(claimType);
                        }
                        if (claim != null && claim instanceof ISimpleClaim) {
                            ArrayList<String> newValues = new ArrayList<String>();
                            newValues.add(claimValue);
                            ((ISimpleClaim)claim).setValues(newValues);
                            try {
                                this.addClaimValuesMRU(userAccount, claimType, claimValue);
                            }
                            catch (Exception e) {
                                LOG.error((Object)e, (Throwable)e);
                            }
                        }
                        ++index;
                    }
                    card.applyUpdates();
                    result[i] = new ICardUpdateResponseTO(card.getCUID().toString());
                    ResourceMetaDataHelper resourceMetaDataHelper = new ResourceMetaDataHelper();
                    resourceMetaDataHelper.updateCardMD(card.getCUID().toString(), (IResourceMetaDataService)metaDataService.get(), userAccount);
                }
                catch (Exception e) {
                    LOG.error((Object)e, (Throwable)e);
                    result[i] = new ICardUpdateResponseTO(-1, e.getMessage());
                    try {
                        if (card != null && card.isEditMode()) {
                            card.cancelUpdates();
                        }
                    }
                    catch (Throwable tr) {
                        LOG.error((Object)tr, tr);
                    }
                }
            }
            ++i;
        }
        return result;
    }

    public ICardTO updateICard(UserAccount userAccount, ICardTO icardTO) throws RppsException {
        try {
            ICardTO res = this.convertICard_To_ICardTO(userAccount, this.updateCard(userAccount, icardTO), false, null);
            return res;
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    public ICardUpdateResponseTO[] updateICards(UserAccount userAccount, ICardTO[] icardTOList) throws RppsException {
        try {
            ICardUpdateResponseTO[] result = new ICardUpdateResponseTO[icardTOList.length];
            int i = 0;
            while (i < icardTOList.length) {
                try {
                    ICard card = this.updateCard(userAccount, icardTOList[i]);
                    result[i] = new ICardUpdateResponseTO(card.getCUID().toString());
                }
                catch (Exception e) {
                    LOG.error((Object)e, (Throwable)e);
                    result[i] = new ICardUpdateResponseTO(-1, e.getMessage());
                }
                ++i;
            }
            return result;
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    public boolean userIdentifierExists(String userIdentifier) throws UserAccountException {
        return ((IUserAccountService)userAccountService.get()).existsAccount(userIdentifier);
    }

    public void getOTP(AuthCredentialTO authCredentialTO, String captchaId, String captchaResponse, String channel) throws ConfigurationException, LoginException, AuthenticationException, UserProfileException, NoSuchAlgorithmException, CommunicationException {
        UserAccount account = this.authenticate(authCredentialTO);
        UserProfile userProfile = ((IUserProfileService)userProfileService.get()).getUserProfile(account.getUserId());
        this.validateCaptcha(captchaId, captchaResponse);
        if (!(channelsMap.get(channel) instanceof ICommunicationChanelCommand)) {
            throw new CommunicationException(String.valueOf(channel) + " is not supported channel name.");
        }
        String passwordResetCode = PPIDHelper.getUserFriendlyPPID((byte[])SecureRandom.getSeed(32));
        HashMap<Date, String> oneTimePasswords = userProfile.getOneTimePasswords();
        if (oneTimePasswords == null) {
            oneTimePasswords = new HashMap<Date, String>();
        }
        oneTimePasswords.put(new Date(), passwordResetCode.replaceAll("-", ""));
        userProfile.setOneTimePasswords(oneTimePasswords);
        ((IUserProfileService)userProfileService.get()).modifyUserProfile(account.getUserId(), userProfile);
        ((ICommunicationChanelCommand)channelsMap.get(channel)).sendMessage(userProfile, MessageFormat.format(EmailUtils.getString("email.body.otp_code"), passwordResetCode));
    }

    public void validateCaptcha(String captchaId, String captchaResponse) throws UserProfileException, AuthenticationException {
        Captcha captcha = ((IUserProfileService)userProfileService.get()).getCaptcha(captchaId);
        if (captcha == null) {
            throw new AuthenticationException("Invalide capthcha.");
        }
        ((IUserProfileService)userProfileService.get()).deleteCaptcha(captchaId);
    }

    public ImportCardInformationTO[] getImportingCardsInformation(UserAccount userAccount, byte[] crd, String formatID, UITokenServiceCredentialTO credential) throws RppsException {
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(crd);
            ICredential cred = ConvertHelper.convertUITokenServiceCredentialTO_to_ICredentials(credential);
            IImportCardInfo[] cardInfoArray = ICardRegistry.getInstance().getImportCardInformation(RppsHelper.getCallbackHandler(userAccount.getUserId()), (InputStream)is, formatID, cred);
            return ConvertHelper.convertImportCardInformation(cardInfoArray);
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    static final class DummySecurityProvider
    extends Provider {
        private static final long serialVersionUID = 594145003249139851L;

        public DummySecurityProvider() {
            super("Dummy", 1.0, "");
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    DummySecurityProvider.this.put("TrustManagerFactory." + DummyTrustManagerFactory.getAlgorithm(), DummyTrustManagerFactory.class.getName());
                    return null;
                }
            });
        }
    }

    public static final class DummyTrustManagerFactory
    extends TrustManagerFactorySpi {
        public static String getAlgorithm() {
            return "XTrust509";
        }

        protected TrustManager[] engineGetTrustManagers() {
            return new TrustManager[]{new X509TrustManager(){

                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                    int i = 0;
                    while (i < certs.length) {
                        LOG.info((Object)("  >>> Checking certificate " + certs[i]));
                        ++i;
                    }
                }

                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }
            }};
        }

        protected void engineInit(KeyStore keystore) throws KeyStoreException {
        }

        protected void engineInit(ManagerFactoryParameters arg0) throws InvalidAlgorithmParameterException {
        }
    }
}

