/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.rpps.core.utils;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.sync.meta.IResourceMetaDataService;
import org.eclipse.higgins.sync.meta.entity.ResourceRevisionEntity;
import org.eclipse.higgins.sync.meta.entity.RevisionEntity;
import org.eclipse.higgins.sync.meta.entity.RootRevisionEntity;
import org.eclipse.higgins.sync.meta.utilities.ResourceUtil;
import org.eclipse.higgins.user.login.UserAccount;
import org.eclipse.higgins.user.profile.entity.UserProfile;

public class ResourceMetaDataHelper {
    private static Log LOG = LogFactory.getLog(ResourceMetaDataHelper.class);

    public void updateCardMD(String cuid, IResourceMetaDataService metaDataService, UserAccount userAccount) {
        try {
            RevisionEntity rootRevisionEntity = new ResourceUtil().findRootRevision(metaDataService, (String)((Object)userAccount.getUserId()));
            ResourceRevisionEntity revisionEntity = new ResourceRevisionEntity();
            revisionEntity.setResourceType("org.eclipse.higgins.sync.to.CardTO").setResourceId(cuid).setUserId((String)((Object)userAccount.getUserId())).setParentId(rootRevisionEntity.getId());
            metaDataService.persistResourceRevisionEntity((RevisionEntity)revisionEntity);
        }
        catch (Exception e) {
            LOG.warn((Object)e, (Throwable)e);
        }
    }

    public void updateCardCredentialMD(String cuid, IResourceMetaDataService metaDataService, UserAccount userAccount) {
        try {
            RevisionEntity rootRevisionEntity = new ResourceUtil().findRootRevision(metaDataService, (String)((Object)userAccount.getUserId()));
            metaDataService.persistResourceRevisionEntity(new ResourceRevisionEntity().setResourceType("org.eclipse.higgins.sync.to.CardCredentialTO").setResourceId(cuid).setUserId((String)((Object)userAccount.getUserId())).setParentId(rootRevisionEntity.getId()));
        }
        catch (Exception e) {
            LOG.warn((Object)e, (Throwable)e);
        }
    }

    public void updateUserProfileMD(IResourceMetaDataService metaDataService, String userId, UserProfile userProfile) {
        try {
            ResourceUtil resourceUtil = new ResourceUtil();
            RootRevisionEntity rootRevisionEntity = new ResourceUtil().persistRoorRevision(metaDataService, (Serializable)((Object)userId));
            resourceUtil.persistResourceRevision(metaDataService, (Serializable)((Object)((String)((Object)userProfile.getUserIdentifier()))), "org.eclipse.higgins.sync.to.UserProfileTO", userId, rootRevisionEntity.getId());
        }
        catch (Exception e) {
            LOG.warn((Object)e, (Throwable)e);
        }
    }

    public void updateCategoryMD(String id, IResourceMetaDataService metaDataService, UserAccount userAccount) {
        try {
            ResourceUtil resourceUtil = new ResourceUtil();
            RevisionEntity rootRevisionEntity = resourceUtil.findRootRevision(metaDataService, (String)((Object)userAccount.getUserId()));
            metaDataService.persistResourceRevisionEntity(new ResourceRevisionEntity().setResourceType("org.eclipse.higgins.sync.to.CardCategoryTO").setResourceId(id).setUserId((String)((Object)userAccount.getUserId())).setParentId(rootRevisionEntity.getId()));
        }
        catch (Exception e) {
            LOG.warn((Object)e, (Throwable)e);
        }
    }
}

