/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    abhi shelat (IBM Corporation) - initial API and implementation
 *******************************************************************************/

package org.eclipse.higgins.rpps.core;

import java.security.cert.X509Certificate;
import java.util.Hashtable;
import org.eclipse.higgins.iss.UserChoiceTree;

public class UserInterfaceResponse {
	String _name;

	String _addr1;

	String _addr2;

	String _phone;

	String _verifier;

	UserChoiceTree _ucl;

	public UserInterfaceResponse() {
		_name = _addr1 = _addr2 = _phone = _verifier = "unknown";
		_ucl = null;
	}

	public void setUCL(UserChoiceTree ucl) {
		_ucl = ucl;
	}

	public UserChoiceTree getUCL() {
		return _ucl;
	}

	public void setRequestorInformation(X509Certificate sslCert) {
		if (sslCert == null) {
			return;
		}
		Hashtable t = getHashFromX509Name(sslCert.getSubjectX500Principal().getName());

		_name = clean(t.get("CN"));
		_addr1 = clean(t.get("O"));
		String st = clean(t.get("ST"));
		// String co = clean(t.get("C"));
		_addr2 = (st.length() > 0 ? st + " " : "") + clean(t.get("C"));

		t = getHashFromX509Name(sslCert.getIssuerX500Principal().getName());
		_verifier = clean(t.get("CN"));
		String vc = clean(t.get("C"));
		if (vc.length() > 0)
			_verifier += " in " + vc;

	}

	public String clean(Object o) {
		if (o == null) {
			return "";
		} else {
			return o.toString();
		}
	}

	// name looks like 1.2.840.113549.1.9.1=#1612616273407a75726963682e69626d2e636f6d,CN=9.4.21.94,OU=abhi test,O=IBM ZRL,L=Zurich,ST=Zurich,C=CH
	public Hashtable getHashFromX509Name(String name) {
		Hashtable h = new Hashtable();
		String s[] = name.split(",");
		if (s != null) {
			for (int j = 0; j < s.length; j++) {
				String keyval[] = s[j].split("=");
				if (keyval != null && keyval.length > 1) {
					h.put(keyval[0], keyval[1]);
				}
			}
		}
		return h;
	}

	public String getName() {
		return _name;
	}

	public void setName(String name) {
		_name = name;
	}

	public String getAddr1() {
		return _addr1;
	}

	public void setAddr1(String addr) {
		_addr1 = addr;
	}

	public String getAddr2() {
		return _addr2;
	}

	public void setAddr2(String addr) {
		_addr2 = addr;
	}

	public String getPhone() {
		return _phone;
	}

	public void setPhone(String phone) {
		_phone = phone;
	}

	public String getVerifier() {
		return _verifier;
	}

	public void setVerifier(String verifier) {
		_verifier = verifier;
	}
}
