/**
 * Copyright (c) 2007 Parity Communications, Inc. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Sergei Yakovlev - initial API and implementation
 */

package org.eclipse.higgins.rpps.core.impl;

import java.io.Serializable;
import java.net.URI;
import java.util.Properties;

/**
 * This is the feed properties container class.
 * 
 * @author Sergei Yakovlev
 * 
 */
public class FeedProperties implements Serializable {

	private static final long serialVersionUID = -2575989756955019924L;

	private URI id;

	private Properties properties;

	/**
	 * Constructor for the FeedProperties.
	 * 
	 * @param id the feed id (title).
	 * @param properties the feed property list (items).
	 */
	public FeedProperties(URI id, Properties properties) {
		setId(id);
		setProperties(properties);
	}

	/**
	 * Gets feed id.
	 * 
	 * @return the feed id.
	 */
	public URI getId() {
		return id;
	}

	/**
	 * Sets feed id.
	 * 
	 * @param id the feed id to set.
	 */
	public void setId(URI id) {
		this.id = id;
	}

	/**
	 * Gets the property list
	 * 
	 * @return the properties.
	 */
	public Properties getProperties() {
		return properties;
	}

	/**
	 * Sets the property list
	 * 
	 * @param properties the feed properties to set.
	 */
	public void setProperties(Properties properties) {
		this.properties = properties;
	}
}
