/**
 * Copyright (c) 2007 Parity Communications, Inc. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Sergei Yakovlev - initial API and implementation
 */

package org.eclipse.higgins.rpps.core.impl;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;

/**
 * The object used for simplifying file operations.
 * 
 * @author Sergei Yakovlev
 * 
 */
public class FileService {

	public static String SCRIPTS_DIR = "scripts" + File.separator;

	public static String SCRIPTS_EXT = ".scr";

	/**
	 * Creates an FileService object.
	 * 
	 * @return the FileService object
	 */
	public static FileService getInstance() {
		return new FileService();
	}

	/**
	 * Converts feed URL to local path string.
	 * 
	 * @param url the feed url.
	 * @return the local path string
	 */
	public static String convertURLToPath(URL url) {
		String path = null;
		if (url != null) {
			path = url.getHost();
			path += url.getPath().replace('/', File.separatorChar);
		}
		return path;
	}

	/**
	 * Gets BufferedReader from the specified file.
	 * 
	 * @param filePath the file path string.
	 * @return the BufferedReader object.
	 * @throws FileNotFoundException
	 */
	public BufferedReader getBufferedReader(String filePath) throws FileNotFoundException {
		return new BufferedReader(new FileReader(filePath));
	}

	/**
	 * Gets BufferedWriter to specified file.
	 * 
	 * @param filePath the file path string.
	 * @return the BufferedWriter object.
	 * @throws IOException
	 */
	public BufferedWriter getBufferedWriter(String filePath) throws IOException {
		File file = new File(filePath);
		if (!file.exists()) {
			// create parent dirs if it's needed
			if (file.getParent() != null) {
				new File(file.getParent()).mkdirs();
			}
			file.createNewFile();
		}
		return new BufferedWriter(new FileWriter(file));
	}
}
