package org.eclipse.higgins.rpps.core.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Properties;

import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

import org.eclipse.higgins.icard.ICardTemplate;
import org.eclipse.higgins.icard.ITemplateContainer;
import org.eclipse.higgins.icard.ITemplateElement;
import org.eclipse.higgins.icard.ITemplateValue;
//import org.eclipse.higgins.rpps.core.RppsException;
import org.eclipse.higgins.rpps.core.tobj.ICardTemplateTO;
import org.eclipse.higgins.rpps.core.tobj.ITemplateElementTO;

public class RppsHelper {

	/**
	 * Parses a string representation of the certificate
	 * 
	 * @param soapval the security certificate as a String
	 * @return the X509Certificate object
	 */
	public static X509Certificate parseSSLCert(String soapval) {
		X509Certificate sslCert = null;
		if (soapval == null) {
			return null;
		}
		String a[] = soapval.split(",");
		if (a != null) {
			byte ssl[] = new byte[a.length];
			for (int j = 0; j < a.length; j++) {
				ssl[j] = (byte) Integer.parseInt(a[j]);
			}
			ByteArrayInputStream bis = new ByteArrayInputStream(ssl);
			try {
				CertificateFactory cf = CertificateFactory.getInstance("X.509");
				sslCert = (X509Certificate) cf.generateCertificate(bis);
			} catch (Exception ee) {
				ee.printStackTrace();
			}
		}
		return sslCert;
	}

	/**
	 * Creates CallbackHandler object with username/password.
	 * 
	 * @param userId the id to identify the user.
	 * @param password the password to identify the user.
	 * @return the CallbackHandler object.
	 */
	public static CallbackHandler getCallbackHandler(final String userId, final String password) {
		return new CallbackHandler() {
			public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
				for (int i = 0; i < callbacks.length; i++) {
					if (callbacks[i] instanceof NameCallback) {
						NameCallback n = (NameCallback) callbacks[i];
						n.setName(userId);
					} else if (callbacks[i] instanceof PasswordCallback) {
						PasswordCallback p = (PasswordCallback) callbacks[i];
						p.setPassword(password.toCharArray());
					} else {
						throw new UnsupportedCallbackException(callbacks[i]);
					}
				}
			}
		};
	}

	/**
	 * Loads the properties from the string array.
	 * 
	 * @param properties the string array of properties.
	 * @return the properties.
	 */
	public static Properties loadProperties(String[] properties) {
		Properties props = new Properties();
		ByteArrayOutputStream os = new ByteArrayOutputStream();
		// Populates output stream with a property list
		try {
			for (int i = 0; i < properties.length; i++) {
				// writes key and element pair
				os.write(properties[i].getBytes());
				// writes line terminator
				os.write('\r');
				os.write('\n');
			}
		} catch (IOException ex) {
			ex.printStackTrace();
		}
		// Reads a property list (key and element pairs) from the input stream
		try {
			props.load(new ByteArrayInputStream(os.toByteArray()));
		} catch (IOException ex) {
			ex.printStackTrace();
		}
		return props;
	}

	/**
	 * Loads the properties from the string array.
	 * 
	 * @param properties the string array of properties.
	 * @param templeteTO
	 * @return the properties.
	 */
	public static ICardTemplate fillICardTemplate_from_ICardTemplateTO(ICardTemplate[] templates, ICardTemplateTO templeteTO) {
		ICardTemplate template = null;

		if (templates != null) {
			for (int index = 0; index < templates.length; index++) {
				// template.
				if (templates[index].getCardType().getName().equalsIgnoreCase(templeteTO.getCardType())) {
					template = templates[index];
					template.setDescription(templeteTO.getDescription());
					template.setDisplayName(templeteTO.getName());
					int size = templeteTO.getElements().length;
					for (int i = 0; i < size; i++) {
						ITemplateElement element = template.getTemplateElementByID(templeteTO.getElements()[i].getId());
						if (element != null) {
							if (element instanceof ITemplateValue) {
								fillITemplateValue((ITemplateValue) element, templeteTO.getElements()[i].getValue());
							} else {
								fillITemplateContainer((ITemplateContainer) element, templeteTO.getElements()[i].getContainerValue());
							}
						}
					}
				}
			}
		}
		return template;
	}

	/**
	 * 
	 * @param element
	 * @param elementTOValue
	 */
	public static void fillITemplateValue(ITemplateValue element, String elementTOValue) {
		if (element != null) {
			element.setValue(elementTOValue);
		}
	}

	/**
	 * 
	 * @param root
	 * @param elementsTO
	 */
	public static void fillITemplateContainer(ITemplateContainer root, ITemplateElementTO[] elementsTO) {
		if (root != null) {
			int size = elementsTO.length;
			for (int i = 0; i < size; i++) {
				ITemplateElement element = root.getTemplateElementByID(elementsTO[i].getId());
				if (element != null) {
					if (element instanceof ITemplateValue) {
						fillITemplateValue((ITemplateValue) element, elementsTO[i].getValue());
					} else {
						fillITemplateContainer((ITemplateContainer) element, elementsTO[i].getContainerValue());
					}
				}
			}
		}
	}

	/**
	 * 
	 * @param handler the callback handler to be used to request user's identity
	 * @param cardname name of new card
	 * @param surname value of surname field
	 * @param givenname value of givenname field
	 * @param emailaddress value of emailaddress field
	 * @return ICardTemplate object with filling field
	 * @throws Exception
	 */
	public static ICardTemplate fillPersonalCardTemplate(ICardTemplate template, String cardname, String surname, String givenname, String emailaddress, String streetaddress, String locality, String stateorprovince, String postalcode, String country, String homephone, String otherphone, String mobilephone, String dateofbirth, String gender, String webpage) {
		if (template != null) {
			ITemplateValue elementCardName = (ITemplateValue) template.getTemplateElementByID("cardName");
			elementCardName.setValue(cardname);

			ITemplateContainer elementClaimList = (ITemplateContainer) template.getTemplateElementByID("claimList");
			ITemplateValue elementSurName = (ITemplateValue) elementClaimList.getTemplateElementByID("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/surname");
			elementSurName.setValue(surname);
			ITemplateValue elementGivenName = (ITemplateValue) elementClaimList.getTemplateElementByID("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/givenname");
			elementGivenName.setValue(givenname);
			ITemplateValue elementEmailAddress = (ITemplateValue) elementClaimList.getTemplateElementByID("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/emailaddress");
			elementEmailAddress.setValue(emailaddress);
			ITemplateValue elementStreetAddress = (ITemplateValue) elementClaimList.getTemplateElementByID("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/streetaddress");
			elementStreetAddress.setValue(streetaddress);
			ITemplateValue elementlocality = (ITemplateValue) elementClaimList.getTemplateElementByID("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/locality");
			elementlocality.setValue(locality);
			ITemplateValue elementstateorprovince = (ITemplateValue) elementClaimList.getTemplateElementByID("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/stateorprovince");
			elementstateorprovince.setValue(stateorprovince);
			ITemplateValue elementpostalcode = (ITemplateValue) elementClaimList.getTemplateElementByID("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/postalcode");
			elementpostalcode.setValue(postalcode);
			ITemplateValue elementcountry = (ITemplateValue) elementClaimList.getTemplateElementByID("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/country");
			elementcountry.setValue(country);
			ITemplateValue elementhomephone = (ITemplateValue) elementClaimList.getTemplateElementByID("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/homephone");
			elementhomephone.setValue(homephone);
			ITemplateValue elementotherphone = (ITemplateValue) elementClaimList.getTemplateElementByID("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/otherphone");
			elementotherphone.setValue(otherphone);
			ITemplateValue elementmobilephone = (ITemplateValue) elementClaimList.getTemplateElementByID("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/mobilephone");
			elementmobilephone.setValue(mobilephone);
			ITemplateValue elementdateofbirth = (ITemplateValue) elementClaimList.getTemplateElementByID("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/dateofbirth");
			elementdateofbirth.setValue(dateofbirth);
			ITemplateValue elementgender = (ITemplateValue) elementClaimList.getTemplateElementByID("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/gender");
			elementgender.setValue(gender);
			ITemplateValue elementwebpage = (ITemplateValue) elementClaimList.getTemplateElementByID("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/webpage");
			elementwebpage.setValue(webpage);
		}
		return template;
	}

	/**
	 * 
	 * @param obj1
	 * @param obj2
	 * @return true if this object is the same as the obj argument; false otherwise.
	 */
	public static boolean equalsObject(Object obj1, Object obj2) {
		if ((obj1 == null) && (obj2 == null))
			return true;
		if (((obj1 != null) && (obj2 == null)) || ((obj1 == null) && (obj2 != null)))
			return false;
		return obj1.equals(obj2);
	}
}
