package org.eclipse.higgins.rpps.core.impl;

import java.util.Date;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TimeProductivity {
	private Log log = LogFactory.getLog(TimeProductivity.class);

	private boolean isCalculate = false;

	private long startDate_ = 0;

	private StringBuffer buf = new StringBuffer();

	public TimeProductivity() {
	}

	public TimeProductivity(boolean isCalculate) {
		setCalculate(isCalculate);
	}

	public void startProcess(String metodName) {
		if (isCalculate) {
			startDate_ = new Date().getTime();
			buf.append("TimeProductivity: Process was started in ");
			buf.append(metodName);
			buf.append("\n");
		}
	}

	public void addPoint(String metodName) {
		if (isCalculate) {
			if (startDate_ == 0)
				startProcess(metodName);

			buf.append("TimeProductivity: Time point was created in ");
			buf.append(metodName);
			buf.append(" after ");
			buf.append((new Date()).getTime() - startDate_);
			buf.append(" ms\n");
		}
	}

	public void endProcess(String metodName) {
		if (isCalculate) {
			buf.append("TimeProductivity: Process was finished in ");
			buf.append(metodName);
			buf.append(" after ");
			buf.append((new Date()).getTime() - startDate_);
			buf.append(" ms\n");
			log.trace(buf.toString());
			startDate_ = 0;
			buf = new StringBuffer();
		}
	}

	public boolean isCalculate() {
		return isCalculate;
	}

	public void setCalculate(boolean isCalculate) {
		this.isCalculate = isCalculate;
	}
}
