/*
 * RssServlet.java
 *
 */

package org.eclipse.higgins.rpps.core.rss;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.eclipse.higgins.rpps.core.impl.RppsService;
import org.eclipse.higgins.rsse.RssFeed;
import org.eclipse.higgins.rsse.RssItem;

/**
 * Returns the requested RSS feed with completed site verified attributes.
 * 
 * @author Sergei Yakovlev
 * @version
 */
public class RssServlet extends HttpServlet {

	private static final long serialVersionUID = 838906887589824979L;

	private static String rssDir;

	/**
	 * Initializes the servlet.
	 */
	public void init(ServletConfig config) throws ServletException {
		super.init(config);
		if (getRssDir() == null || getRssDir().length() == 0) {
			rssDir = config.getServletContext().getRealPath("") + "/rss";
		}
	}

	/**
	 * Processes requests for both HTTP <code>GET</code> and <code>POST</code> methods.
	 * 
	 * @param request servlet request
	 * @param response servlet response
	 */
	protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		String userId = request.getParameter("userId");
		String password = request.getParameter("password");
		// String cardId = request.getParameter("cardId");
		String file = request.getPathInfo();
		if (file.endsWith(".xml")) {
			response.setContentType("text/xml;charset=UTF-8");
		} else {
			response.setContentType("text/html;charset=UTF-8");
		}
		PrintWriter out = response.getWriter();
		File rssFile = new File(rssDir + "/" + userId + file);
		if (rssFile.exists()) {
			try {
				String ALIAS = "alias";
				String VALIDATE = "validate";
				// loads specified local rss feed
				RssFeed localFeed = RssFeed.load(rssFile);
				List items = localFeed.getItems();
				List aliasItems = new ArrayList();
				List validateItems = new ArrayList();
				for (int i = 0; i < items.size(); i++) {
					RssItem item = (RssItem) items.get(i);
					if (item.getName().startsWith(ALIAS)) {
						aliasItems.add(item);
					} else if (item.getName().startsWith(VALIDATE)) {
						validateItems.add(item);
					}
				}
				for (int i = 0; i < aliasItems.size(); i++) {
					RssItem aliasItem = (RssItem) aliasItems.get(i);
					String index = aliasItem.getName().substring(ALIAS.length());
					StringTokenizer token = new StringTokenizer(aliasItem.getValue(), ",");
					String host = token.hasMoreTokens() ? token.nextToken().trim() : "";
					String username = token.hasMoreTokens() ? token.nextToken().trim() : "";
					try {
						// sets 'validate' items to true if connection is verified.
						if (RppsService.getInstance().connectionVerify(userId, password, host, username)) {
							for (int j = 0; j < validateItems.size(); j++) {
								RssItem validateItem = (RssItem) validateItems.get(j);
								if (validateItem.getName().equals(VALIDATE + index)) {
									validateItem.setValue("true");
								}
							}
						}
					} catch (Exception ex) {
						ex.printStackTrace();
					}
				}
				// saves changes to the local rss feed
				localFeed.save(rssFile);
			} catch (Exception ex) {
				ex.printStackTrace();
			}

			BufferedReader in = new BufferedReader(new FileReader(rssFile));
			try {
				String line;
				while ((line = in.readLine()) != null) {
					out.println(line);
				}
			} finally {
				in.close();
			}
		}

		/*
		 * String link = "http://"+request.getHeader("host")+request.getContextPath()+"/"+request.getPathInfo(); response.setContentType("text/xml;charset=UTF-8"); PrintWriter out = response.getWriter(); ICardTO icard = new RPProtocolSupportDelegate().getICardById(userId, cardId); RssFeed feed = new RssFeed(icard.getId(), link, "Test RSS RP Service Account"); for(int i = 0; icard.getProperties() != null && i < icard.getProperties().length; i++) { String name = icard.getProperties()[i].getName(); String value = icard.getProperties()[i].getValue(); if(value != null) { feed.addItem(new RssItem(name, value, link)); if(name.startsWith("alias")) { StringTokenizer token = new StringTokenizer(value, ","); String host = token.hasMoreTokens() ? token.nextToken().trim() : ""; String username = token.hasMoreTokens() ? token.nextToken().trim() : ""; if(new
		 * RPProtocolSupportDelegate().connectionVerify(userId, host, username)) { feed.addItem(new RssItem("alias-verified", value, link)); } } } } ByteArrayOutputStream baos = new ByteArrayOutputStream(); new RssExporter_2_0(baos, "utf-8").write(feed); out.println(baos.toString());
		 */
		/*
		 * TODO output your page here out.println("<html>"); out.println("<head>"); out.println("<title>Servlet RssServlet</title>"); out.println("</head>"); out.println("<body>"); out.println("<h1>Servlet RssServlet at " + request.getContextPath () + "</h1>"); out.println("</body>"); out.println("</html>");
		 */
		out.close();
	}

	// <editor-fold defaultstate="collapsed" desc="HttpServlet methods. Click on the + sign on the left to edit the
	// code.">
	/**
	 * Handles the HTTP <code>GET</code> method.
	 * 
	 * @param request servlet request
	 * @param response servlet response
	 */
	protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		processRequest(request, response);
	}

	/**
	 * Handles the HTTP <code>POST</code> method.
	 * 
	 * @param request servlet request
	 * @param response servlet response
	 */
	protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		processRequest(request, response);
	}

	/**
	 * Returns a short description of the servlet.
	 */
	public String getServletInfo() {
		return "Short description";
	}

	// </editor-fold>

	/**
	 * Gets the local directory where rss feeds are stored.
	 */
	public static String getRssDir() {
		return rssDir;
	}
}
