/*
 * Copyright (c) 2007 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Sergei Yakovlev - initial API and implementation
 */

package org.eclipse.higgins.rpps.core.tobj;

import java.io.Serializable;

/**
 * A transfer object is a serializable class that groups related attributes, forming a composite value.
 * 
 * Please refer to section 5.3.5 of the spec. If your classes are conformant to the javabean design pattern and also
 * follow the rules as given in this particular section, then JAXRPC runtime will take care of serializing/deserializing
 * your own class. FYI, following are the requirements by JAXRPC:
 * 
 * JavaBeans class must be serializable to and from the corresponding XML representation at runtime. This means that a
 * JavaBeans class must contain properties that are of the JAX-RPC supported Java types. If one or more properties do
 * not have the JAX-RPC supported types, then the JavaBeans class is not mapped. JavaBeans class must have a default
 * constructor. The Java type of a property must be a JAX-RPC 1.0 supported Java type and be mappable to the
 * corresponding XML type.
 * 
 * The standard rules of mapping from a javabean are as well given in the spec in the same section. It should be
 * relatively straight forward to conform your class to javabean design pattern.
 * 
 * Created on 18 Jan 2007, 15:21
 * 
 * @author Sergei Yakovlev
 */
public class BaseTransferObject implements Serializable {

	private static final long serialVersionUID = -8015735426485208811L;
	private String name;

	/** Creates a new instance of UserInterfaceResponse */
	public BaseTransferObject() {
	}

	/**
	 * Gets the name of transfer object.
	 * 
	 * @return the name of transfer object.
	 */
	public String getName() {
		return name;
	}

	/**
	 * Sets the name of transfer object
	 * 
	 * @param name
	 *            the name of transfer object.
	 */
	public void setName(String name) {
		this.name = name;
	}

}
