/*
 * Copyright (c) 2007 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Sergei Yakovlev - initial API and implementation
 */

package org.eclipse.higgins.rpps.core.tobj;

import java.io.Serializable;

/**
 * The transfer object for the i-card property. A transfer object is a serializable class that groups related attributes, 
 * forming a composite value. This class is used as the return type of a WS business method.
 * @author Sergei Yakovlev
 */
public class PropertyTO extends UIDescriptorTO implements Serializable {
    
	private static final long serialVersionUID = 8671893081050591732L;
	
	private String[] value;
	private String valueType;
	private PropertyTO[] complexValue;
	private String claimType;
	
    
	/** Creates a new instance of PropertyTO */
    public PropertyTO() {
        super();
    }

    /**
     * Creates a new instance of simple PropertyTO
     * @param name the property name.
     * @param value the property value array.
     */
    public PropertyTO(String name, String claimType, String valueType, String[] value) {
        setName(name);
        setValueType(valueType);
        setValue(value);
        setClaimType(claimType);
    }
    
    /**
     * Creates a new instance of complex PropertyTO
     * @param name the property name.
     * @param complexValue the complex property value array.
     */
    public PropertyTO(String name, String claimType, PropertyTO[] complexValue) {
        setName(name);
        setComplexValue(complexValue);
        setClaimType(claimType);
    }
    
    /**
     * Gets the simple property values.
     * @return the property value array.
     */
    public String[] getValue() {
        return value;
    }

    /**
     * Sets the simple property values.
     * @param value the property value array.
     */
    public void setValue(String[] value) {
        this.value = value;
    }
    
    /**
     * Gets the complex property values.
     * @return the property value array.
     */
    public PropertyTO[] getComplexValue() {
		return complexValue;
	}

    /**
     * Sets the complex property values.
     * @param complexValue the property value array.
     */
	public void setComplexValue(PropertyTO[] complexValue) {
		this.complexValue = complexValue;
	}

	/**
	 * Gets the simple value type (class) as a string.
	 * @return the simple value type as a string.
	 */
	public String getValueType() {
		return valueType;
	}

	/**
	 * Sets the simple value type (class).
	 * @param valueType the simple value type as a string.
	 */
	public void setValueType(String valueType) {
		this.valueType = valueType;
	}
	
	/**
	 * Gets the claim type as a string.
	 * @return the claim type as a string.
	 */
	public String getClaimType() {
		return claimType;
	}

	/**
	 * Sets the claim type.
	 * @param claimType the claim type as a string.
	 */
	public void setClaimType(String claimType) {
		this.claimType = claimType;
	}

}
