/*******************************************************************************
 * Copyright (c) 2007 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Artem Verhovets - Initial API and implementation
 *******************************************************************************/
package org.eclipse.higgins.rpps.core.tobj;

import java.io.Serializable;


public class ResponseMessage implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 8603714779703505244L;
	
	public static final String noError="0";
	public static final String unknownError="-1";
	
	private String code;
	private String message;
	
	public ResponseMessage()
	{		
	}
	
	public ResponseMessage(String code)
	{		
		setCode(code);
	}
	
	public ResponseMessage(String code,String message)
	{
		this(code);
		setMessage(message);
	}
	
	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public String getMessage() {
		return message;
	}

	public void setMessage(String message) {
		this.message = message;
	}
	

}
