/*
 * Copyright (c) 2007 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Sergei Yakovlev - initial API and implementation
 */

package org.eclipse.higgins.rpps.core.tobj;

import java.io.Serializable;

/**
 * The transfer object for the token response. A transfer object is a serializable class that groups related attributes, 
 * forming a composite value. This class is used as the return type of a WS business method.
 * @author Sergei Yakovlev
 */
public class TokenResponseTO extends BaseTransferObject implements Serializable {
	
	private static final long serialVersionUID = -7407593829356382227L;
	
	private String tkn;
	
	/** Creates a new instance of TokenResponseTO */
	public TokenResponseTO() {
		super();
	}

	/**
	 * Gets security token property as a string
	 * @return the security token as a string
	 */
	public String getTkn() {
		return tkn;
	}

	/**
	 * Sets security token property.
	 * @param token the security token a s a string.
	 */
	public void setTkn(String token) {
		this.tkn = token;
	}

}