/*
 * Copyright (c) 2007 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Sergei Yakovlev - initial API and implementation
 */

package org.eclipse.higgins.rpps.core.tobj;

import java.io.Serializable;

/**
 * The transfer object for the OR element of UserInterfaceResponse. A transfer object is a serializable class that groups related attributes, 
 * forming a composite value. This class is used as the return type of a WS business method.
 * @author Sergei Yakovlev
 */
public class UIResponseOrTO extends BaseTransferObject implements Serializable {
	
	private static final long serialVersionUID = -5855087343584594929L;
	private UIResponseClauseTO clause;
	
	/** Creates a new instance of UIResponseOrTO */
	public UIResponseOrTO() {
		super();
	}

	/**
	 * Gets the CLAUSE element.
	 * @return the CLAUSE element.
	 */
	public UIResponseClauseTO getClause() {
		return clause;
	}
	
	/**
	 * Sets the CLAUSE element.
	 * @param clause the CLAUSE element.
	 */
	public void setClause(UIResponseClauseTO clause) {
		this.clause = clause;
	}
	
}
