/*
 * Copyright (c) 2007 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Sergei Yakovlev - initial API and implementation
 */

package org.eclipse.higgins.rpps.core.tobj;

import java.io.Serializable;

/**
 * The transfer object for the RP element of UserInterfaceResponse. A transfer object is a serializable class that groups related attributes, 
 * forming a composite value. This class is used as the return type of a WS business method.
 * @author Sergei Yakovlev
 */
public class UIResponseRPTO extends BaseTransferObject implements Serializable {
	
	private static final long serialVersionUID = -6036851259621447249L;
	private String addr1;
	private String addr2;
	private String phone;
	private String verifier;
	
	/** Creates a new instance of UIResponseRPTO */
	public UIResponseRPTO() {
		super();
	}

	/**
	 * Gets the address1 property value.
	 * @return the address1 property value.
	 */
	public String getAddr1() {
		return addr1;
	}
	
	/**
	 * Sets the address1 property value.
	 * @param addr1 the address1 property value.
	 */
	public void setAddr1(String addr1) {
		this.addr1 = addr1;
	}

	/**
	 * Gets the address2 property value.
	 * @return the address2 property value.
	 */
	public String getAddr2() {
		return addr2;
	}
	
	/**
	 * Sets the address2 property value.
	 * @param addr2 the address2 property value.
	 */
	public void setAddr2(String addr2) {
		this.addr2 = addr2;
	}

	/**
	 * Gets the phone property value.
	 * @return the phone property value.
	 */
	public String getPhone() {
		return phone;
	}
	
	/**
	 * Sets the phone property value.
	 * @param phone the phone property value.
	 */
	public void setPhone(String phone) {
		this.phone = phone;
	}

	/**
	 * Gets the verifier property value.
	 * @return the verifier property value.
	 */
	public String getVerifier() {
		return verifier;
	}
	
	/**
	 * Sets the verifier property value.
	 * @param verifier the verifier property value.
	 */
	public void setVerifier(String verifier) {
		this.verifier = verifier;
	}
}