/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Michael McIntosh (IBM Corporation) - initial API and implementation
 *******************************************************************************/ 

package org.eclipse.higgins.sts.api;

import javax.xml.namespace.QName;



/**
 * Interface providing access to SOAP Fault information
 * 
 * @author mikemci at us dot ibm dot com
 */
public interface IFault
{
	/**
	 * Gets the FaultCode namespace URI
	 * 
	 * @return the FaultCode namespace URI
	 */
	public abstract java.net.URI getCodeNamespace();
	
	/**
	 * Gets the FaultCode prefix
	 * 
	 * @return the FaultCode prefix
	 */
	public abstract String getCodePrefix();
	
	/**
	 * Gets the FaultCode LocalPart
	 * 
	 * @return the FaultCode LocalPart
	 */
	public abstract String getCodeLocalPart();
	
	/**
	 * Gets the Reason
	 * 
	 * @return the Reason
	 */
	public abstract String getReason();
	
	/**
	 * Gets the Detail
	 * 
	 * @return the Detail
	 */
	public abstract String getDetail();


	/**
	 * Gets the SubCode of fault
	 * @return the SubCode of fault
	 */
	public QName getSubCode();

	/**
	 * Sets the FaultCode namespace URI
	 * 
	 * @param uriCodeNamespace the FaultCode namespace URI
	 */
	public abstract void setCodeNamespace(final java.net.URI uriCodeNamespace);
	
	/**
	 * Sets the FaultCode prefix
	 * 
	 * @param strCodePrefix the FaultCode prefix
	 */
	public abstract void setCodePrefix(final String strCodePrefix);
	
	/**
	 * Sets the FaultCode LocalPart
	 * 
	 * @param strCodeLocalPart the FaultCode LocalPart
	 */
	public abstract void setCodeLocalPart(final String strCodeLocalPart);
	
	/**
	 * Sets the Reason
	 * 
	 * @param strReason the Reason
	 */
	public abstract void setReason(final String strReason);
	
	/**
	 * Sets the Detail
	 * 
	 * @param strDetail the Detail
	 */
	public abstract void setDetail(final String strDetail);

	/**
	 * Sets the SubCode of fault
	 * 
	 * @param subCode the SubCode of fault
	 */
	public void setSubCode(final QName subCode);
}
