/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Michael McIntosh (IBM Corporation) - initial API and implementation
 *******************************************************************************/ 

package org.eclipse.higgins.sts.api;

/**
 * Interface representing WS-Addressing EndpointReference information
 * 
 * @author mikemci at us dot ibm dot com
 */
public interface IEndpointReference
{
	/**
	 * Gets the Address URI
	 * 
	 * @return the Address URI
	 */
	public abstract java.net.URI getAddress();
	
	public abstract String getIdentityCertificate();
	
	public abstract void setIdentityCertificate(String strIdentityCertificate);
	
	/**
	 * Sets the WS-Addressing namespace URI
	 * 
	 * @param uriAddress the WS-Addressing namespace URI
	 */
	public abstract void setAddress(final java.net.URI uriAddress);
	
	/**
	 * Gets the list of any ReferenceParameters elements 
	 * 
	 * @return the list of any ReferenceParameters elements 
	 */
	public abstract java.util.List getReferenceParametersElements();

	/**
	 * Gets the list of any Metadata elements 
	 * 
	 * @return the list of any Metadata elements
	 */
	public abstract java.util.List getMetadataElements();

	/**
	 * Gets the list of any other elements (other than those explicitly named)
	 * 
	 * @return the list of any other elements (other than those explicitly named)
	 */
	public abstract java.util.List getAnyOtherElements();
}
