/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Michael McIntosh (IBM Corporation) - initial API and implementation
 *******************************************************************************/

package org.eclipse.higgins.sts.api;

/**
 * Interface representing the plug-point for the Core Higgins STS implementation.
 * 
 * @author mikemci at us dot ibm dot com
 */
public interface ISecurityTokenService
	extends org.eclipse.higgins.configuration.api.IConfigurableComponent
{	
	/**
	 * This method is called each time the framework receives a RequestSecurityToken message.
	 * 
	 * @param request an ISTSRequest containing values form the RequestSecurityToken
	 * @param response an ISTSResponse containing values to be placed into the RequestSecurityTokenResponse
	 * @param constants an IConstants containing the URIs appropriate for the request and response
	 */
	// TODO: Think about using factory to deal with different versions of Trust (for Pat)
    public abstract void invoke
		(final java.util.Map mapGlobalSettings,
		final String strComponentName,
		final java.util.Map mapComponentSettings,
		final java.util.Map mapInvocationSettings,
		final IConstants constants,
		final ISTSRequest request,
		final ISTSResponse response);
}
