/*******************************************************************************
 * Copyright (c) 2006-2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Michael McIntosh (IBM Corporation) - initial API and implementation
 *******************************************************************************/ 

package org.eclipse.higgins.sts.base64.apache;

import org.eclipse.higgins.sts.spi.IBase64Extension;

/**
 * @author mikemci
 *
 */
public class Base64ApacheExtension implements IBase64Extension
{
	private static final org.eclipse.higgins.sts.utilities.LogHelper log = new org.eclipse.higgins.sts.utilities.LogHelper
		(Base64ApacheExtension.class.getName());
	
	public Base64ApacheExtension()
	{
		System.err.println("Base64ApacheExtension:Base64ApacheExtension");
		log.trace("Base64ApacheExtension:Base64ApacheExtension");	
		
		org.apache.xml.security.Init.init();
	}
	
	public void configure(final java.util.Map mapGlobalSettings, final String strComponentName, final java.util.Map mapComponentSettings)
	{
		System.err.println("Base64ApacheExtension:configure");
		log.trace("Base64ApacheExtension:configure");	
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IBase64Extension#decode(java.lang.String)
	 */
	public byte[] decode(final String strData) throws Exception
	{
		return org.apache.xml.security.utils.Base64.decode(strData);
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IBase64Extension#encode(java.math.BigInteger)
	 */
	public String encode(final java.math.BigInteger biData) throws Exception
	{
		return org.apache.xml.security.utils.Base64.encode(biData);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IBase64Extension#encode(byte[])
	 */
	public String encode(final byte[] byteData) throws Exception
	{
		return org.apache.xml.security.utils.Base64.encode(byteData);
	}

}
