/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Michael McIntosh (IBM Corporation) - initial API and implementation
 *******************************************************************************/ 

package org.eclipse.higgins.sts.binding.axis1x.addressing;

import org.eclipse.higgins.sts.api.IEndpointReference;
import org.eclipse.higgins.sts.common.Element;
import org.eclipse.higgins.sts.utilities.XMLHelper;

/**
 * Implements a handler that processes WS-Addressing headers received by a
 * web service in request messages, placing appropriate header values into
 * properties of the message context, making them available to subsequent handlers. 
 * This class works together with the WSSResponseGeneratorHandler class.
 * 
 * @author mikemci at us dot ibm dot com
 */
public class WSARequestConsumerHandler
	extends org.apache.axis.handlers.BasicHandler
{
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	/**
	 * 
	 */
	private final org.eclipse.higgins.sts.utilities.LogHelper log = new org.eclipse.higgins.sts.utilities.LogHelper
		(WSARequestConsumerHandler.class.getName());
	
	public WSARequestConsumerHandler()
	{
		this.log.trace("WSARequestConsumerHandler::WSARequestConsumerHandler");
	}

	/**
	 * Private implementation method invoked to process each URI header element.
	 */
	private String processURIHeader
		(final org.apache.axis.MessageContext messageContext,
		final org.apache.axis.message.SOAPEnvelope requestEnvelope,
		final String strHeaderName,
		final String strPropertyName)
		throws org.apache.axis.AxisFault
	{
		this.log.trace("processURIHeader: " + strHeaderName);
    	org.apache.axis.message.SOAPHeaderElement elemSOAPHeader = null;
    	String strNamespace = "http://www.w3.org/2005/08/addressing";
    	try
    	{
    		elemSOAPHeader = requestEnvelope.getHeaderByName
    			(strNamespace, 
    			strHeaderName);  
    	}
    	catch (final org.apache.axis.AxisFault af)
    	{
    		org.eclipse.higgins.sts.utilities.ExceptionHelper.Log
				(this.log,
				af);
    		throw af;
    	}
      	if (null == elemSOAPHeader)
      	{
      		strNamespace = "http://schemas.xmlsoap.org/ws/2004/08/addressing";
        	try
        	{
         		elemSOAPHeader = requestEnvelope.getHeaderByName
        			(strNamespace, 
        			strHeaderName);   
        	}
        	catch (final org.apache.axis.AxisFault af)
        	{
        		org.eclipse.higgins.sts.utilities.ExceptionHelper.Log
    				(this.log,
    				af);
        		throw af;
        	}
      	}
      	if (null == elemSOAPHeader)
      	{
      		strNamespace = null;
      	}
      	else
      	{
      		this.log.trace("Name: " + strPropertyName + " Value: " + elemSOAPHeader.getValue());
      		messageContext.setProperty
  				(strPropertyName,
  				java.net.URI.create(elemSOAPHeader.getValue()));
      		elemSOAPHeader.setProcessed
  		 		(true);
      	}
      	return strNamespace;
	}

	/**
	 * Private implementation method invoked to process each EPR header element.
	 */
	private String processEPRHeader
		(final org.apache.axis.MessageContext messageContext,
		final org.apache.axis.message.SOAPEnvelope requestEnvelope,
		final String strHeaderName,
		final String strPropertyName)
		throws org.apache.axis.AxisFault
	{
		this.log.trace("processEPRHeader: " + strHeaderName);
		final IEndpointReference endpointReference = new org.eclipse.higgins.sts.common.EndpointReference();
    	org.apache.axis.message.SOAPHeaderElement elemSOAPHeader = null;
    	String strNamespace = "http://www.w3.org/2005/08/addressing";
    	try
    	{
    		elemSOAPHeader = requestEnvelope.getHeaderByName
    			(strNamespace, 
    			strHeaderName);    		
    	}
    	catch (final org.apache.axis.AxisFault af)
    	{
    		org.eclipse.higgins.sts.utilities.ExceptionHelper.Log
				(this.log,
				af);
    		throw af;
    	}
      	if (null == elemSOAPHeader)
      	{
      		strNamespace = "http://schemas.xmlsoap.org/ws/2004/08/addressing";
        	try
        	{
        		elemSOAPHeader = requestEnvelope.getHeaderByName
        			(strNamespace, 
        			strHeaderName);    
        	}
        	catch (final org.apache.axis.AxisFault af)
        	{
        		org.eclipse.higgins.sts.utilities.ExceptionHelper.Log
    				(this.log,
    				af);
        		throw af;
        	}
      	}
      	if (null == elemSOAPHeader)
      	{
      		strNamespace = null;
      	}
      	else
      	{
       		final java.util.Iterator iterChildren = elemSOAPHeader.getChildElements();
      		final java.util.List listReferenceParametersElements = endpointReference.getReferenceParametersElements();
      		final java.util.List listMetadataElements = endpointReference.getMetadataElements();
      		final java.util.List listAnyOtherElements = endpointReference.getAnyOtherElements();
      		while (iterChildren.hasNext())
      		{
      			final javax.xml.soap.SOAPElement seChild = (javax.xml.soap.SOAPElement)iterChildren.next();
      			final String strLocalName = seChild.getLocalName();
      			if (strLocalName.equals("Address"))
      			{
      				final String strAddress = seChild.getValue();
      				java.net.URI uriAddress = null;
      				try
      				{
      					uriAddress = new java.net.URI(strAddress);
      					uriAddress = uriAddress.normalize();
      				}
      				catch (final Exception e)
      				{
      	        		org.eclipse.higgins.sts.utilities.ExceptionHelper.Log
  	        				(this.log,
  	        				e);      					
      				}
      				endpointReference.setAddress(uriAddress);
      			}
      			else
      			{
      				final org.eclipse.higgins.sts.api.IElement element = new Element();
      				try
      				{
      					element.set(seChild);
      				}
      				catch (final Exception e)
      				{
      	        		org.eclipse.higgins.sts.utilities.ExceptionHelper.Log
      	        			(this.log,
      	        			e);
      				}
      				if (strLocalName.equals("ReferenceParameters"))
      				{
     					listReferenceParametersElements.add(element);
      				}
      				else if (strLocalName.equals("Metadata"))
      				{
      					listMetadataElements.add(element); 
      				}
      				else 
      				{
      					listAnyOtherElements.add(element);  
      				}
      			}
      		}
      		messageContext.setProperty
  				(strPropertyName,
  				endpointReference);
      		elemSOAPHeader.setProcessed
  		 		(true);
      	}
      	return strNamespace;
	}

	/**
	 * Invoked by the framework to perform the main processing for the class. 
	 * Places the values contained in the supported WS-Addressing headers into
	 * properties of the MessageContext, making them available to subsequent
	 * handlers in the same context.
	 * 
	 * @param  messageContext the MessageContext associated with the request.
	 * @throws org.apache.axis.AxisFault
	 */	
	public void invoke
		(final org.apache.axis.MessageContext messageContext)
		throws org.apache.axis.AxisFault
	{
		this.log.trace("WSARequestConsumerHandler::invoke");

    	final org.apache.axis.Message requestMessage = messageContext.getRequestMessage();
    	org.apache.axis.message.SOAPEnvelope requestEnvelope = null;
    	try
    	{
    		requestEnvelope = requestMessage.getSOAPEnvelope();    		
    	}
    	catch (final org.apache.axis.AxisFault af)
    	{
    		org.eclipse.higgins.sts.utilities.ExceptionHelper.Log
				(this.log,
				af);
			throw af;
    	}
    	org.w3c.dom.Element domEnvelope = null;
		try
		{
			domEnvelope = requestEnvelope.getAsDOM();
			/****** Mask password out of trace ******/
			if (log.getLog().isTraceEnabled()) {
				String tmpStr = XMLHelper.toString(domEnvelope);
				String tmpStrLc = tmpStr.toLowerCase();
				if (tmpStrLc.indexOf("password") == -1 ) {
					// This request does not contain the string "password"
					// so go ahead and put it into the trace
					this.log.trace("Request: " + tmpStr);
				}
				else {
					// Mask out password
					org.w3c.dom.Element domEnvelope2 = null;
					domEnvelope2 = XMLHelper.toDOM(tmpStr);
					if (domEnvelope2.hasAttribute("Password")) {
						domEnvelope2.setAttribute("Password", "XXX");
					}
					else if (domEnvelope2.hasAttribute("password")) {
						domEnvelope2.setAttribute("password", "XXX");
					}
					this.log.trace("Request: " + XMLHelper.toString(domEnvelope2));
				}
			}
			/***************************************/
		}
		catch (final Exception e)
		{
    		org.eclipse.higgins.sts.utilities.ExceptionHelper.Log
				(this.log,
				e);			
		}
		
    	boolean bNamespaceSet = false;
    	String strAddressingNamespace = null;
    	String strNamespace = this.processURIHeader
    		(messageContext,
    		requestEnvelope,
    		"MessageID",
    		org.eclipse.higgins.sts.binding.axis1x.addressing.Constants.PROPERTY_REQUEST_CONSUMER_MESSAGE_ID_URI);
    	if (null != strNamespace)
    	{
			this.log.trace("Found WS-Addressing " + strNamespace + ":MessageID");
    		if (!bNamespaceSet)
    		{
    			strAddressingNamespace = strNamespace;
    			bNamespaceSet = true;
    		}
    	}
    	else
    	{
    		this.log.trace("wsa:MessageID not found");
    	}
    		
    	strNamespace = this.processURIHeader
			(messageContext,
			requestEnvelope,
			"Action",
    		org.eclipse.higgins.sts.binding.axis1x.addressing.Constants.PROPERTY_REQUEST_CONSUMER_ACTION_URI);
    	if (null != strNamespace)
    	{
    		this.log.trace("Found WS-Addressing " + strNamespace + ":Action");
    		if (!bNamespaceSet)
    		{
    			strAddressingNamespace = strNamespace;
    			bNamespaceSet = true;
    		}
    	}
    	else
    	{
    		this.log.trace("wsa:Action not found");
    	}
    	
    	strNamespace = this.processURIHeader
			(messageContext,
			requestEnvelope,
			"To",
    		org.eclipse.higgins.sts.binding.axis1x.addressing.Constants.PROPERTY_REQUEST_CONSUMER_TO_URI);
    	if (null != strNamespace)
    	{
			this.log.trace("Found WS-Addressing " + strNamespace + ":To");
    		if (!bNamespaceSet)
    		{
    			strAddressingNamespace = strNamespace;
    			bNamespaceSet = true;
    		}
    	}
    	else
    	{
    		this.log.trace("wsa:To not found - disabling WSAResponseGeneratorHandler");
    		messageContext.setProperty
				(org.eclipse.higgins.sts.binding.axis1x.addressing.Constants.PROPERTY_RESPONSE_GENERATOR_DISABLE,
				new Boolean(true));
    	}
    	
    	strNamespace = this.processURIHeader
			(messageContext,
			requestEnvelope,
			"RelatesTo",
			org.eclipse.higgins.sts.binding.axis1x.addressing.Constants.PROPERTY_REQUEST_CONSUMER_RELATES_TO_URI);
		if (null != strNamespace)
		{
			this.log.trace("Found WS-Addressing " + strNamespace + ":RelatesTo");
			if (!bNamespaceSet)
			{
				strAddressingNamespace = strNamespace;
				bNamespaceSet = true;
			}	
		}  
		else
		{
			this.log.trace("wsa:RelatesTo not found");
		}
		
    	strNamespace = this.processEPRHeader
			(messageContext,
			requestEnvelope,
			"From",
    		org.eclipse.higgins.sts.binding.axis1x.addressing.Constants.PROPERTY_REQUEST_CONSUMER_FROM_EPR);
    	if (null != strNamespace)
    	{
    		this.log.trace("Found WS-Addressing " + strNamespace + ":From");
    		if (!bNamespaceSet)
    		{
    			strAddressingNamespace = strNamespace;
    			bNamespaceSet = true;
    		}
    	}
    	else
    	{
    		this.log.trace("wsa:From not found");
    	}
    	
    	strNamespace = this.processEPRHeader
			(messageContext,
			requestEnvelope,
			"ReplyTo",
    		org.eclipse.higgins.sts.binding.axis1x.addressing.Constants.PROPERTY_REQUEST_CONSUMER_REPLY_TO_EPR);   	
    	if (null != strNamespace)
    	{
    		this.log.trace("Found WS-Addressing " + strNamespace + ":ReplyTo");
    		if (!bNamespaceSet)
    		{
    			strAddressingNamespace = strNamespace;
    			bNamespaceSet = true;
    		}
    	}
    	else
    	{
    		this.log.trace("wsa:ReplyTo not found");
    	}
    	
    	strNamespace = this.processEPRHeader
			(messageContext,
			requestEnvelope,
			"FaultTo",
			org.eclipse.higgins.sts.binding.axis1x.addressing.Constants.PROPERTY_REQUEST_CONSUMER_FAULT_TO_EPR);   	
    	if (null != strNamespace)
    	{
    		this.log.trace("Found WS-Addressing " + strNamespace + ":FaultTo");
    		if (!bNamespaceSet)
    		{
    			strAddressingNamespace = strNamespace;
    			bNamespaceSet = true;
    		}
    	}
    	else
    	{
    		this.log.trace("wsa:FaultTo not found");
    	}
    	
    	if (bNamespaceSet)
    	{
    		this.log.trace("Setting WS-Addressing namespace: " + strAddressingNamespace);
      		messageContext.setProperty
      			(org.eclipse.higgins.sts.binding.axis1x.addressing.Constants.PROPERTY_REQUEST_CONSUMER_NAMESPACE_URI,
      			java.net.URI.create(strAddressingNamespace));
    	}
		this.log.trace("WSARequestConsumerHandler::invoke(done)");

	}
}