/*******************************************************************************
 * Copyright (c) 2006-2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Michael McIntosh (IBM Corporation) - initial API and implementation
 *******************************************************************************/ 

package org.oasis_open.docs.wss._2004._01.oasis_200401_wss_wssecurity_secext_1_0_xsd;


/**
 * This type represents a reference to an external security token.
 */
public class ReferenceType  implements java.io.Serializable {
    /**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private org.apache.axis.types.URI URI;  // attribute

    private org.apache.axis.types.URI valueType;  // attribute

    public ReferenceType() {
    }

    public ReferenceType(
           final org.apache.axis.types.URI URI,
           final org.apache.axis.types.URI valueType) {
           this.URI = URI;
           this.valueType = valueType;
    }


    /**
     * Gets the URI value for this ReferenceType.
     * 
     * @return URI
     */
    public org.apache.axis.types.URI getURI() {
        return this.URI;
    }


    /**
     * Sets the URI value for this ReferenceType.
     * 
     * @param URI
     */
    public void setURI(final org.apache.axis.types.URI URI) {
        this.URI = URI;
    }


    /**
     * Gets the valueType value for this ReferenceType.
     * 
     * @return valueType
     */
    public org.apache.axis.types.URI getValueType() {
        return this.valueType;
    }


    /**
     * Sets the valueType value for this ReferenceType.
     * 
     * @param valueType
     */
    public void setValueType(final org.apache.axis.types.URI valueType) {
        this.valueType = valueType;
    }

    private java.lang.Object __equalsCalc = null;
    public synchronized boolean equals(final java.lang.Object obj) {
        if (!(obj instanceof ReferenceType)) {
			return false;
		}
        final ReferenceType other = (ReferenceType) obj;
        if (obj == null) {
			return false;
		}
        if (this == obj) {
			return true;
		}
        if (this.__equalsCalc != null) {
            return (this.__equalsCalc == obj);
        }
        this.__equalsCalc = obj;
        boolean _equals;
        _equals = true && 
            (((this.URI==null) && (other.getURI()==null)) || 
             ((this.URI!=null) &&
              this.URI.equals(other.getURI()))) &&
            (((this.valueType==null) && (other.getValueType()==null)) || 
             ((this.valueType!=null) &&
              this.valueType.equals(other.getValueType())));
        this.__equalsCalc = null;
        return _equals;
    }

    private boolean __hashCodeCalc = false;
    public synchronized int hashCode() {
        if (this.__hashCodeCalc) {
            return 0;
        }
        this.__hashCodeCalc = true;
        int _hashCode = 1;
        if (this.getURI() != null) {
            _hashCode += this.getURI().hashCode();
        }
        if (this.getValueType() != null) {
            _hashCode += this.getValueType().hashCode();
        }
        this.__hashCodeCalc = false;
        return _hashCode;
    }

    // Type metadata
    private static final org.apache.axis.description.TypeDesc typeDesc =
        new org.apache.axis.description.TypeDesc(ReferenceType.class, true);

    static {
        ReferenceType.typeDesc.setXmlType(new javax.xml.namespace.QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "ReferenceType"));
        org.apache.axis.description.AttributeDesc attrField = new org.apache.axis.description.AttributeDesc();
        attrField.setFieldName("URI");
        attrField.setXmlName(new javax.xml.namespace.QName("", "URI"));
        attrField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "anyURI"));
        ReferenceType.typeDesc.addFieldDesc(attrField);
        attrField = new org.apache.axis.description.AttributeDesc();
        attrField.setFieldName("valueType");
        attrField.setXmlName(new javax.xml.namespace.QName("", "ValueType"));
        attrField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "anyURI"));
        ReferenceType.typeDesc.addFieldDesc(attrField);
    }

    /**
     * Return type metadata object
     */
    public static org.apache.axis.description.TypeDesc getTypeDesc() {
        return ReferenceType.typeDesc;
    }

    /**
     * Get Custom Serializer
     */
    public static org.apache.axis.encoding.Serializer getSerializer(
           final java.lang.String mechType, 
           final java.lang.Class _javaType,  
           final javax.xml.namespace.QName _xmlType) {
        return 
          new  org.apache.axis.encoding.ser.BeanSerializer(
            _javaType, _xmlType, ReferenceType.typeDesc);
    }

    /**
     * Get Custom Deserializer
     */
    public static org.apache.axis.encoding.Deserializer getDeserializer(
           final java.lang.String mechType, 
           final java.lang.Class _javaType,  
           final javax.xml.namespace.QName _xmlType) {
        return 
          new  org.apache.axis.encoding.ser.BeanDeserializer(
            _javaType, _xmlType, ReferenceType.typeDesc);
    }

}
