/*******************************************************************************
 * Copyright (c) 2006-2007 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Michael McIntosh (IBM Corporation) - initial design and implementation
 *******************************************************************************/ 
package org.eclipse.higgins.sts.binding.axis1x.security;

import org.apache.axis.AxisFault;
import org.apache.axis.MessageContext;
import org.apache.axis.handlers.BasicHandler;

/**
 * @author mikemci
 *
 */
public class WSSRequestGeneratorHandler extends BasicHandler {

	private static final long serialVersionUID = 1L;
	
	private final org.eclipse.higgins.sts.utilities.LogHelper log = new org.eclipse.higgins.sts.utilities.LogHelper
		(WSSRequestGeneratorHandler.class.getName());
	
	private final org.eclipse.higgins.sts.api.IConstants constants = new org.eclipse.higgins.sts.common.Constants();

	public WSSRequestGeneratorHandler()
	{
		this.log.trace("WSSRequestGeneratorHandler::WSSRequestGeneratorHandler");
	}
	
	/* (non-Javadoc)
	 * @see org.apache.axis.Handler#invoke(org.apache.axis.MessageContext)
	 */
	public void invoke(MessageContext mc) throws AxisFault
	{
		this.log.trace("WSSRequestGeneratorHandler::invoke");

		try
		{
			java.security.PrivateKey authenticationPrivateKey = (java.security.PrivateKey)mc.getProperty
				("AUTHENTICATIONPRIVATEKEY");
			java.security.PublicKey authenticationPublicKey = (java.security.PublicKey)mc.getProperty
				("AUTHENTICATIONPUBLICKEY");
			org.eclipse.higgins.sts.spi.IXMLSecurityExtension xmlSecurityExtension = (org.eclipse.higgins.sts.spi.IXMLSecurityExtension)mc.getProperty
				("XMLSECURITYEXTENSION");
				
			org.apache.axis.Message msg = mc.getRequestMessage();
			org.apache.axis.message.SOAPEnvelope envelope = msg.getSOAPEnvelope();
			org.w3c.dom.Element domEnvelope = envelope.getAsDOM();

			String strEnvelope = org.eclipse.higgins.sts.utilities.XMLHelper.toString(domEnvelope);
			log.trace("WSSRequestGeneratorHandler: " + strEnvelope);
			
			if (null == authenticationPrivateKey)
				return;
			domEnvelope = org.eclipse.higgins.sts.utilities.XMLHelper.toDOM(strEnvelope);
			org.w3c.dom.NodeList nlEnvelopeChildren = domEnvelope.getChildNodes();
			org.w3c.dom.Element domHeader = null;
			org.w3c.dom.Element domBody = null;
			for (int i = 0; i < nlEnvelopeChildren.getLength(); ++i)
			{
				org.w3c.dom.Node nodeChild = nlEnvelopeChildren.item(i);
				if (org.w3c.dom.Node.ELEMENT_NODE == nodeChild.getNodeType())
				{
					org.w3c.dom.Element domChild = (org.w3c.dom.Element)nodeChild;
					String strLocalName = domChild.getLocalName();
					String strTagName = domChild.getTagName();
					log.trace("LocalName: " + strLocalName + " TagName: " + strTagName);
					if (strLocalName.equals("Body"))
						domBody = domChild;
					if (strLocalName.equals("Header"))
						domHeader = domChild;
				}
			}
			org.w3c.dom.NodeList nlBodyElements = domBody.getElementsByTagName("*");
			org.w3c.dom.Element domBodyElement = (org.w3c.dom.Element)nlBodyElements.item(0);
			String strBodyId = domBodyElement.getAttributeNS
				(constants.getWSSecurityUtilityNamespace().toString(),
				"Id");
			if ((null == strBodyId) || (strBodyId.equals("")))
			{
				strBodyId = "theBody";
				domBodyElement.setAttributeNS
					(constants.getWSSecurityUtilityNamespace().toString(), 
					"wsu:Id",
					strBodyId);
			}
			org.w3c.dom.NodeList nlSecurityElements = domHeader.getElementsByTagNameNS
				(constants.getWSSecurityNamespace().toString(),
				"Security");
			org.w3c.dom.Element domSecurityElement = (org.w3c.dom.Element)nlSecurityElements.item(0);
			org.w3c.dom.Element domSecurity = (org.w3c.dom.Element)nlSecurityElements.item(0);
			org.eclipse.higgins.sts.api.IElement elemSecurity = new org.eclipse.higgins.sts.common.Element();
			elemSecurity.set(domSecurity);
			org.w3c.dom.NodeList nlBST = domSecurity.getElementsByTagNameNS
				(constants.getWSSecurityNamespace().toString(),
				"BinarySecurityToken");
			org.w3c.dom.Element domBST = (org.w3c.dom.Element)nlBST.item(0);
			String strBSTId = domBST.getAttributeNS
				(constants.getWSSecurityUtilityNamespace().toString(),
				"Id");
			if ((null == strBSTId) || (strBSTId.equals("")))
			{
				strBSTId = "theToken";
				domBST.setAttributeNS
					(constants.getWSSecurityUtilityNamespace().toString(), 
					"wsu:Id",
					strBSTId);
			}
			org.w3c.dom.NodeList nlTS = domSecurity.getElementsByTagNameNS
				(constants.getWSSecurityUtilityNamespace().toString(), "Timestamp");
			org.w3c.dom.Element domTS = (org.w3c.dom.Element)nlTS.item(0);
			String strTSId = domTS.getAttributeNS
				(constants.getWSSecurityUtilityNamespace().toString(), "Id");
			if ((null == strTSId) || (strTSId.equals("")))
			{
				strTSId = "theTimestamp";
				domTS.setAttributeNS
					(constants.getWSSecurityUtilityNamespace().toString(), 
					"wsu:Id",
					strTSId);
			}
			org.eclipse.higgins.sts.api.IElement elemSignature = xmlSecurityExtension.SignDetached
				(new String [] { strTSId, strBodyId},
				elemSecurity,
				authenticationPrivateKey,
				authenticationPublicKey,
				strBSTId,
				constants);
			org.w3c.dom.Element domSignature = (org.w3c.dom.Element)elemSignature.getAs(org.w3c.dom.Element.class);
			domSecurity.appendChild(domSignature);
			strEnvelope = org.eclipse.higgins.sts.utilities.XMLHelper.toString(domEnvelope);
		    final java.io.ByteArrayInputStream inputStream = new java.io.ByteArrayInputStream
				(strEnvelope.getBytes("UTF-8"));
		    envelope = new org.apache.axis.message.SOAPEnvelope(inputStream);
		    msg = new org.apache.axis.Message(envelope, false);
		    mc.setCurrentMessage(msg);
		}
		catch (Exception e)
		{
			org.eclipse.higgins.sts.utilities.ExceptionHelper.Log(log, e);
		}
	}
}
