/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Michael McIntosh (IBM Corporation) - initial API and implementation
 *******************************************************************************/

package org.eclipse.higgins.sts.binding.axis1x.security;

/**
 * Used to process WS-Security headers on received request messages
 * 
 * @author mikemci@us.ibm.com
 */
//TODO: Finish commenting this class
//TODO: Finish implementing this class
//TODO: Finish the marshalling on the other side
public class WSSResponseConsumerHandler
	extends org.apache.axis.handlers.BasicHandler
{
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	private final org.eclipse.higgins.sts.utilities.LogHelper log = new org.eclipse.higgins.sts.utilities.LogHelper
		(WSSResponseConsumerHandler.class.getName());
	
	public WSSResponseConsumerHandler()
	{
		this.log.trace("WSSResponseConsumerHandler::WSSResponseConsumerHandler");
	}

	public void invoke
		(final org.apache.axis.MessageContext messageContext)
		throws org.apache.axis.AxisFault
	{
		this.log.trace("WSSResponseConsumerHandler::invoke");
		
		final org.apache.axis.Message mResponse = messageContext.getResponseMessage();
		org.apache.axis.message.SOAPEnvelope seResponse = null;
		try
		{
			seResponse = mResponse.getSOAPEnvelope();
		}
		catch (final org.apache.axis.AxisFault af)
		{
    		org.eclipse.higgins.sts.utilities.ExceptionHelper.Log
				(this.log,
				af);
			throw af;
		}
    	org.apache.axis.message.SOAPHeaderElement sheSecurity = null;
    	try
    	{
    		sheSecurity = seResponse.getHeaderByName
    			("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", 
    			"Security");
    	}
    	catch (final org.apache.axis.AxisFault af)
    	{
    		org.eclipse.higgins.sts.utilities.ExceptionHelper.Log
    			(this.log,
    			af);
			throw af;
    	}
    	if (null == sheSecurity)
    	{
    		this.log.trace("Security header not found.");
    		return;
    	}
      	if (null != sheSecurity) {
			sheSecurity.setProcessed
      		 	(true);
		}
	}
}