/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Michael McIntosh (IBM Corporation) - initial API and implementation
 *******************************************************************************/ 

package org.eclipse.higgins.sts.binding.axis1x.security;

import org.eclipse.higgins.messages.utilities.MsgHelper;

/**
 * Used to add WS-Addressing headers to response messages
 * 
 * @author mikemci at us dot ibm dot com
 */
//TODO: Finish commenting this class
//TODO: Finish implementing this class
public class WSSResponseGeneratorHandler extends org.apache.axis.handlers.BasicHandler
{
//	private org.eclipse.higgins.sts.IConstants constants = new org.eclipse.higgins.sts.impl.Constants();

	private static final long serialVersionUID = 1L;

	private final org.eclipse.higgins.sts.utilities.LogHelper log = new org.eclipse.higgins.sts.utilities.LogHelper
		(WSSResponseGeneratorHandler.class.getName());
	
	public WSSResponseGeneratorHandler()
	{
		this.log.trace("WSSResponseGeneratorHandler::WSSResponseGeneratorHandler");		
	}

	public void invoke
		(final org.apache.axis.MessageContext messageContext)
		throws org.apache.axis.AxisFault
	{
		this.log.trace("WSSResponseGeneratorHandler::invoke");
		
    	final org.apache.axis.Message responseMessage = messageContext.getResponseMessage();
        final org.apache.axis.soap.SOAPConstants soapConstants = messageContext.getSOAPConstants();
        this.log.trace("SOAPConstants: " + soapConstants.getClass().getName());
    	org.apache.axis.message.SOAPEnvelope responseEnvelope = null;
    	try
    	{
    		responseEnvelope = responseMessage.getSOAPEnvelope();
    	}
    	catch (final org.apache.axis.AxisFault af)
    	{
    		org.eclipse.higgins.sts.utilities.ExceptionHelper.Log
    			(this.log,
    			af);
			throw af;
    	}
        
		final org.apache.axis.message.SOAPHeaderElement headerSecurity = new org.apache.axis.message.SOAPHeaderElement
			("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", 
			"Security");
		final org.apache.axis.message.MessageElement meTimestamp = new org.apache.axis.message.MessageElement
			("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd",
			"Timestamp");
		final org.apache.axis.message.MessageElement meCreated = new org.apache.axis.message.MessageElement
			("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd",
			"Created");		
		final org.apache.axis.message.MessageElement meExpires = new org.apache.axis.message.MessageElement
			("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd",
			"Expires");	
		final java.util.Date dateNow = new java.util.Date();
		final java.util.Date dateLater = new java.util.Date(dateNow.getTime() + (1000*60*60*24*7));
		final String strNow = org.eclipse.higgins.sts.utilities.DateHelper.getIso8601Date(dateNow);
		final String strLater = org.eclipse.higgins.sts.utilities.DateHelper.getIso8601Date(dateLater);
		try
		{
			meCreated.addTextNode(strNow);
			meExpires.addTextNode(strLater);
			meTimestamp.addChild(meCreated);
			meTimestamp.addChild(meExpires);
			headerSecurity.addChild(meTimestamp);
		}
		catch (final javax.xml.soap.SOAPException se)
		{
	    	org.eclipse.higgins.sts.utilities.ExceptionHelper.Log
				(this.log,
				se);

	    		String errMsg = MsgHelper.getString(MsgHelper.caught_exception,"WSSResponseGeneratorHandler", "invoke", "org.apache.axis.message.SOAPHeaderElement.getAsDOM");
			throw new org.apache.axis.AxisFault(errMsg,se);
		}
		headerSecurity.setRole(null);
		headerSecurity.setMustUnderstand(true);
		responseEnvelope.addHeader(headerSecurity);
	}
}
