/*******************************************************************************
 * Copyright (c) 2006-2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Michael McIntosh (IBM Corporation) - initial API and implementation
 *******************************************************************************/ 

package org.w3.www._2000._09.xmldsig;

public class ReferenceType  implements java.io.Serializable {
    /**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private org.w3.www._2000._09.xmldsig.TransformType[] transforms;

    private org.w3.www._2000._09.xmldsig.DigestMethodType digestMethod;

    private byte[] digestValue;

    private org.apache.axis.types.Id id;  // attribute

    private org.apache.axis.types.URI URI;  // attribute

    private org.apache.axis.types.URI type;  // attribute

    public ReferenceType() {
    }

    public ReferenceType(
           final org.w3.www._2000._09.xmldsig.TransformType[] transforms,
           final org.w3.www._2000._09.xmldsig.DigestMethodType digestMethod,
           final byte[] digestValue,
           final org.apache.axis.types.Id id,
           final org.apache.axis.types.URI URI,
           final org.apache.axis.types.URI type) {
           this.transforms = transforms;
           this.digestMethod = digestMethod;
           this.digestValue = digestValue;
           this.id = id;
           this.URI = URI;
           this.type = type;
    }


    /**
     * Gets the transforms value for this ReferenceType.
     * 
     * @return transforms
     */
    public org.w3.www._2000._09.xmldsig.TransformType[] getTransforms() {
        return this.transforms;
    }


    /**
     * Sets the transforms value for this ReferenceType.
     * 
     * @param transforms
     */
    public void setTransforms(final org.w3.www._2000._09.xmldsig.TransformType[] transforms) {
        this.transforms = transforms;
    }


    /**
     * Gets the digestMethod value for this ReferenceType.
     * 
     * @return digestMethod
     */
    public org.w3.www._2000._09.xmldsig.DigestMethodType getDigestMethod() {
        return this.digestMethod;
    }


    /**
     * Sets the digestMethod value for this ReferenceType.
     * 
     * @param digestMethod
     */
    public void setDigestMethod(final org.w3.www._2000._09.xmldsig.DigestMethodType digestMethod) {
        this.digestMethod = digestMethod;
    }


    /**
     * Gets the digestValue value for this ReferenceType.
     * 
     * @return digestValue
     */
    public byte[] getDigestValue() {
        return this.digestValue;
    }


    /**
     * Sets the digestValue value for this ReferenceType.
     * 
     * @param digestValue
     */
    public void setDigestValue(final byte[] digestValue) {
        this.digestValue = digestValue;
    }


    /**
     * Gets the id value for this ReferenceType.
     * 
     * @return id
     */
    public org.apache.axis.types.Id getId() {
        return this.id;
    }


    /**
     * Sets the id value for this ReferenceType.
     * 
     * @param id
     */
    public void setId(final org.apache.axis.types.Id id) {
        this.id = id;
    }


    /**
     * Gets the URI value for this ReferenceType.
     * 
     * @return URI
     */
    public org.apache.axis.types.URI getURI() {
        return this.URI;
    }


    /**
     * Sets the URI value for this ReferenceType.
     * 
     * @param URI
     */
    public void setURI(final org.apache.axis.types.URI URI) {
        this.URI = URI;
    }


    /**
     * Gets the type value for this ReferenceType.
     * 
     * @return type
     */
    public org.apache.axis.types.URI getType() {
        return this.type;
    }


    /**
     * Sets the type value for this ReferenceType.
     * 
     * @param type
     */
    public void setType(final org.apache.axis.types.URI type) {
        this.type = type;
    }

    private java.lang.Object __equalsCalc = null;
    public synchronized boolean equals(final java.lang.Object obj) {
        if (!(obj instanceof ReferenceType)) {
			return false;
		}
        final ReferenceType other = (ReferenceType) obj;
        if (obj == null) {
			return false;
		}
        if (this == obj) {
			return true;
		}
        if (this.__equalsCalc != null) {
            return (this.__equalsCalc == obj);
        }
        this.__equalsCalc = obj;
        boolean _equals;
        _equals = true && 
            (((this.transforms==null) && (other.getTransforms()==null)) || 
             ((this.transforms!=null) &&
              java.util.Arrays.equals(this.transforms, other.getTransforms()))) &&
            (((this.digestMethod==null) && (other.getDigestMethod()==null)) || 
             ((this.digestMethod!=null) &&
              this.digestMethod.equals(other.getDigestMethod()))) &&
            (((this.digestValue==null) && (other.getDigestValue()==null)) || 
             ((this.digestValue!=null) &&
              java.util.Arrays.equals(this.digestValue, other.getDigestValue()))) &&
            (((this.id==null) && (other.getId()==null)) || 
             ((this.id!=null) &&
              this.id.equals(other.getId()))) &&
            (((this.URI==null) && (other.getURI()==null)) || 
             ((this.URI!=null) &&
              this.URI.equals(other.getURI()))) &&
            (((this.type==null) && (other.getType()==null)) || 
             ((this.type!=null) &&
              this.type.equals(other.getType())));
        this.__equalsCalc = null;
        return _equals;
    }

    private boolean __hashCodeCalc = false;
    public synchronized int hashCode() {
        if (this.__hashCodeCalc) {
            return 0;
        }
        this.__hashCodeCalc = true;
        int _hashCode = 1;
        if (this.getTransforms() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(this.getTransforms());
                 i++) {
                final java.lang.Object obj = java.lang.reflect.Array.get(this.getTransforms(), i);
                if ((obj != null) &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (this.getDigestMethod() != null) {
            _hashCode += this.getDigestMethod().hashCode();
        }
        if (this.getDigestValue() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(this.getDigestValue());
                 i++) {
                final java.lang.Object obj = java.lang.reflect.Array.get(this.getDigestValue(), i);
                if ((obj != null) &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (this.getId() != null) {
            _hashCode += this.getId().hashCode();
        }
        if (this.getURI() != null) {
            _hashCode += this.getURI().hashCode();
        }
        if (this.getType() != null) {
            _hashCode += this.getType().hashCode();
        }
        this.__hashCodeCalc = false;
        return _hashCode;
    }

    // Type metadata
    private static final org.apache.axis.description.TypeDesc typeDesc =
        new org.apache.axis.description.TypeDesc(ReferenceType.class, true);

    static {
        ReferenceType.typeDesc.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2000/09/xmldsig#", "ReferenceType"));
        org.apache.axis.description.AttributeDesc attrField = new org.apache.axis.description.AttributeDesc();
        attrField.setFieldName("id");
        attrField.setXmlName(new javax.xml.namespace.QName("", "Id"));
        attrField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "ID"));
        ReferenceType.typeDesc.addFieldDesc(attrField);
        attrField = new org.apache.axis.description.AttributeDesc();
        attrField.setFieldName("URI");
        attrField.setXmlName(new javax.xml.namespace.QName("", "URI"));
        attrField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "anyURI"));
        ReferenceType.typeDesc.addFieldDesc(attrField);
        attrField = new org.apache.axis.description.AttributeDesc();
        attrField.setFieldName("type");
        attrField.setXmlName(new javax.xml.namespace.QName("", "Type"));
        attrField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "anyURI"));
        ReferenceType.typeDesc.addFieldDesc(attrField);
        org.apache.axis.description.ElementDesc elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("transforms");
        elemField.setXmlName(new javax.xml.namespace.QName("http://www.w3.org/2000/09/xmldsig#", "Transforms"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2000/09/xmldsig#", "TransformsType"));
        elemField.setMinOccurs(0);
        elemField.setNillable(false);
        ReferenceType.typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("digestMethod");
        elemField.setXmlName(new javax.xml.namespace.QName("http://www.w3.org/2000/09/xmldsig#", "DigestMethod"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2000/09/xmldsig#", "DigestMethodType"));
        elemField.setNillable(false);
        ReferenceType.typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("digestValue");
        elemField.setXmlName(new javax.xml.namespace.QName("http://www.w3.org/2000/09/xmldsig#", "DigestValue"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2000/09/xmldsig#", "DigestValueType"));
        elemField.setNillable(false);
        ReferenceType.typeDesc.addFieldDesc(elemField);
    }

    /**
     * Return type metadata object
     */
    public static org.apache.axis.description.TypeDesc getTypeDesc() {
        return ReferenceType.typeDesc;
    }

    /**
     * Get Custom Serializer
     */
    public static org.apache.axis.encoding.Serializer getSerializer(
           final java.lang.String mechType, 
           final java.lang.Class _javaType,  
           final javax.xml.namespace.QName _xmlType) {
        return 
          new  org.apache.axis.encoding.ser.BeanSerializer(
            _javaType, _xmlType, ReferenceType.typeDesc);
    }

    /**
     * Get Custom Deserializer
     */
    public static org.apache.axis.encoding.Deserializer getDeserializer(
           final java.lang.String mechType, 
           final java.lang.Class _javaType,  
           final javax.xml.namespace.QName _xmlType) {
        return 
          new  org.apache.axis.encoding.ser.BeanDeserializer(
            _javaType, _xmlType, ReferenceType.typeDesc);
    }

}
