/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Michael McIntosh (IBM Corporation) - initial API and implementation
 *******************************************************************************/ 

package org.eclipse.higgins.sts.client.samples;

import java.util.HashMap;
import java.util.Map;

import org.eclipse.higgins.sts.api.ISTSResponse;
import org.eclipse.higgins.sts.client.TokenRequestFactory;
import org.eclipse.higgins.sts.common.STSResponse;

/**
 * @author mikemci at us dot ibm dot com
 *
 */
public class TestManaged
{
	private java.util.Map mapGlobalSettings = null;

	private final org.eclipse.higgins.sts.utilities.LogHelper log = new org.eclipse.higgins.sts.utilities.LogHelper
		(TestManaged.class.getName());
	
	private static final String strTestRPCertificate = 
		"MIICVDCCAb2gAwIBAgIERWUHrzANBgkqhkiG9w0BAQUFADBQMQswCQYDVQQGEwJVUzEYMBYGA1UEChMPSUJNIENvcnBvcmF0aW9uMRUwEwYDVQQLEwxJQk0gUmVzZWFyY2gxEDAOBgNVBAMTB1Jvb3QgQ0EwHhcNMDYxMTIzMDIyOTU3WhcNMjYxMTE4MDIyOTU3WjBFMQswCQYDVQQGEwJVUzEQMA4GA1UEChMHRWNsaXBzZTEQMA4GA1UECxMHSGlnZ2luczESMBAGA1UEAxMJbG9jYWxob3N0MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCUFDtM2/nLEhSJqF7zqayW8gQ183KCiKME53VkSjl6C7O9J2hEiBMWsI9a+qBm13VWKvmTc3h3EsLaR/dOreXyCLKEwDIpwHojW3+i037OOxL6U3Ij094rqfHBCJP2xEyLNpPXdIioEgP5H6MTRPXShsBsTQ7bEhZs0QKyXwTNHwIDAQABo0YwRDAdBgNVHQ4EFgQUTHM9O3KViNYsvuGeg4eANMCFHuMwEwYDVR0lBAwwCgYIKwYBBQUHAwEwDgYDVR0PAQH/BAQDAgSwMA0GCSqGSIb3DQEBBQUAA4GBADkZZ34T637gwxp/EmRlRd4ru1Y2ribGoLRpY1icJYlyrUB3552f1K7r69EQxuwnyUnFYVhB+4ZnzhralkKtNs8UVo7RZHSE8jKWOi4YU3RXSqEHKs10ttQLLcHPuH4o9t2OJLeaVtaijbdicbxUEwqhgcNnNrQHe6+f5fgwzSYM";

	private static final String strTestRootCertificate = 
		"MIICbDCCAdWgAwIBAgIERWUHpTANBgkqhkiG9w0BAQUFADBQMQswCQYDVQQGEwJVUzEYMBYGA1UEChMPSUJNIENvcnBvcmF0aW9uMRUwEwYDVQQLEwxJQk0gUmVzZWFyY2gxEDAOBgNVBAMTB1Jvb3QgQ0EwHhcNMDYxMTIzMDIyOTU3WhcNMjYxMTE4MDIyOTU3WjBQMQswCQYDVQQGEwJVUzEYMBYGA1UEChMPSUJNIENvcnBvcmF0aW9uMRUwEwYDVQQLEwxJQk0gUmVzZWFyY2gxEDAOBgNVBAMTB1Jvb3QgQ0EwgZ8wDQYJKoZIhvcNAQEBBQADgY0AMIGJAoGBAIcFIvEB2pWBf/B3Xh156Pia3OkgT88FyTZs4WyhN18Zf05nXr7ebSkUNy71emoHpYY5AF3mpgf5ltTaVE09XF4aFJm+MkVkkI7Wx75yPkbGvBV9lHrVKlH+y6Gj7RNcms6DNwpjUqjnNyqG3HSQIXU5xcSS9Qfkqj7i72QdDodpAgMBAAGjUzBRMB0GA1UdDgQWBBQWbV9hrYalWfkZz6REmhtZfBsqfjAfBgNVHSMEGDAWgBQWbV9hrYalWfkZz6REmhtZfBsqfjAPBgNVHRMBAf8EBTADAQH/MA0GCSqGSIb3DQEBBQUAA4GBAFEjuPi00CV+He2xPWbhGPL8F89tKNmjOCZQL2ZpyFbhAq6mnev9MrwuSs60ig+LFiTbTc6qg3LcTRph6pf9soqinBea3uv4ZksjTDPoIEquzP5aIAe620dr6ghcruG6A5wpIoScSHFyZAxfi6cZAXoPNt6c18Ba1d1kADBhPOPy";

	private java.net.URI uriTestRP = null;
	
	private final java.net.URI uriTestSTS = java.net.URI.create("https://localhost/TokenService/services/Trust");
	
	private final java.net.URI uriTestMex = java.net.URI.create("https://localhost/TokenService/services/MetadataUsernameToken");
	
	public static void main(final String [] args)
	{
		final TestManaged t = new TestManaged();
		t.Run();
	}
	
	public String Run()
	{
		System.out.println("TestManaged");
		
		//System.setProperty("axis.socketSecureFactory", "org.apache.axis.components.net.IBMFakeTrustSocketFactory");

		//org.eclipse.higgins.sts.utilities.SSLSecurityProvider.AllowUntrustedSSL();
		
		try
		{	
			uriTestRP = java.net.URI.create
				(org.eclipse.higgins.sts.utilities.XMLHelper.escapedString
					("https://pamelaproject.com/jostest/index.php?option=com_pwjos&task=process#test#test"));
			// Setup STS Binding
			final org.eclipse.higgins.configuration.xml.ConfigurationHandler configurationHandler = new org.eclipse.higgins.configuration.xml.ConfigurationHandler();
			
			final String strConfigurationBase = System.getProperty
				("org.eclipse.higgins.sts.conf");
			if (null == strConfigurationBase)
			{
				throw new Exception("org.eclipse.higgins.sts.conf System property not found");
			}
			configurationHandler.setConfigurationBase(strConfigurationBase);
			configurationHandler.setFileName("ManagedClientConfiguration.xml");
				
			boolean bInitialized = configurationHandler.configure(null);
			if (!bInitialized)
			{
				this.log.error
					("Not Initialized!");
				System.err.println
					("Not Initialized!");				
				return "Error";
			}
			mapGlobalSettings = configurationHandler.getSettings();
			
			final org.eclipse.higgins.sts.api.ISecurityTokenService sts = (org.eclipse.higgins.sts.api.ISecurityTokenService)mapGlobalSettings.get
				("SecurityTokenService");
			final org.eclipse.higgins.sts.api.ISecurityTokenService stsBinding = (org.eclipse.higgins.sts.api.ISecurityTokenService)mapGlobalSettings.get
				("SecurityTokenServiceBinding");
			
			final java.security.KeyStore ksTrusted = (java.security.KeyStore)mapGlobalSettings.get
				("TrustedKeyStore");
	
			java.util.Collection collCertificates = new java.util.ArrayList();
			java.util.Enumeration enumCertificates = ksTrusted.aliases();
			while (enumCertificates.hasMoreElements())
			{
				String strAlias = (String)enumCertificates.nextElement();
				java.security.cert.Certificate cert = ksTrusted.getCertificate(strAlias);
				collCertificates.add(cert);
			}
			
			java.security.cert.CollectionCertStoreParameters collCSP = new java.security.cert.CollectionCertStoreParameters
				(collCertificates);
			

			java.security.cert.CertStore certStoreTrust = java.security.cert.CertStore.getInstance
				("Collection",
				collCSP);
/*						
			final org.eclipse.higgins.sts.api.IMetadataExchangeService mex = (org.eclipse.higgins.sts.api.IMetadataExchangeService)mapGlobalSettings.get
				("MetadataExchangeService");
			final org.eclipse.higgins.sts.api.IMetadataExchangeService mexBinding = (org.eclipse.higgins.sts.api.IMetadataExchangeService)mapGlobalSettings.get
				("MetadataExchangeServiceBinding");
*/			
			// Create a Card
			final ManagedCard informationCard = new ManagedCard();
			informationCard.setID(java.net.URI.create("urn:Higgins-LDAP-Server"));
			informationCard.setVersion("1");
			informationCard.setIssuer(uriTestSTS.toString());
			informationCard.setIssuerName(uriTestSTS.toString());
/*
			// Need to do this for each request
			final java.net.URI uriMetadataService = java.net.URI.create(uriTestMex.toString()); // This should come form card
			mapGlobalSettings.put("MetadataServiceURI", uriMetadataService);
			mexBinding.configure(mapGlobalSettings, "MetadataExchangeService", null);
*/
			// Get the Metadata
			final org.eclipse.higgins.sts.api.IConstants constants = new org.eclipse.higgins.sts.common.Constants();
/*
			final org.eclipse.higgins.sts.api.IMEXResponse mexResponse = mex.getMetadata
				(mapGlobalSettings,
				"MetadataExchangeService",
				null,
				null,
				constants,
				uriMetadataService);
			if (null != mexResponse.getFault())
			{
				System.err.println("Returning MEX Fault");
				this.log.trace("Returning MEX Fault");
				final org.eclipse.higgins.sts.api.IFault fault = mexResponse.getFault();
				System.err.println("Returning MEX Fault: " + fault.getDetail());
				return "MEX Fault";
			}
			log.trace(mexResponse.getMetadata().getAs(String.class));
*/
			final java.security.cert.X509Certificate certRP = org.eclipse.higgins.sts.utilities.CertificateHelper.fromString(strTestRPCertificate);
			
			final java.security.cert.X509Certificate certRoot = org.eclipse.higgins.sts.utilities.CertificateHelper.fromString(strTestRootCertificate);

			java.security.cert.X509Certificate [] certChain = new java.security.cert.X509Certificate[2];
			certChain[0] = certRP;
			certChain[1] = certRoot;
	
			// Create a Request			
			final java.net.URI uriTokenService = java.net.URI.create(informationCard.getIssuer());
			Map invocationSettings = new HashMap();
			invocationSettings.put("TokenServiceTrustURI", uriTokenService); 
			stsBinding.configure(mapGlobalSettings, "SecurityTokenService", null, null, null);

			final TokenRequestFactory factoryRequest = new TokenRequestFactory();
			final org.eclipse.higgins.sts.api.IElement elemClaims = new org.eclipse.higgins.sts.common.Element();
			elemClaims.set("<wst:Claims xmlns:ic=\"http://schemas.xmlsoap.org/ws/2005/05/identity\" xmlns:wst=\"http://schemas.xmlsoap.org/ws/2005/02/trust\" wst:Dialect=\"http://schemas.xmlsoap.org/ws/2005/05/identity\"><ic:ClaimType Uri=\"http://schemas.xmlsoap.org/ws/2005/05/identity/claims/givenname\"/><ic:ClaimType Uri=\"http://schemas.xmlsoap.org/ws/2005/05/identity/claims/surname\"/><ic:ClaimType Uri=\"http://schemas.xmlsoap.org/ws/2005/05/identity/claims/privatepersonalidentifier\"/></wst:Claims>");
	
			final ISTSResponse stsResponse = new STSResponse();
			final org.eclipse.higgins.sts.api.ISTSRequest stsRequest = factoryRequest.createManagedRequest
				(this.uriTestRP,
				certChain,
				certStoreTrust,
				uriTokenService,
				null,
				java.net.URI.create("urn:oasis:names:tc:SAML:1.0:assertion"),
				informationCard,
				elemClaims,
				"mikemci@us.ibm.com",
				"secret");
		
			// Invoke the STS
			sts.invoke
				(mapGlobalSettings,
				null,
				null,
				invocationSettings,
				constants,
				stsRequest,
				stsResponse);
			if (null != stsResponse.getFault())
			{
				System.err.println("Returning STS Fault");
				this.log.trace("Returning STS Fault");
				return "STS Fault";
			}
			org.eclipse.higgins.sts.api.IElement elemResponse = stsResponse.getMessage();
			String strResponse = (String)elemResponse.getAs(String.class);
			this.log.trace(strResponse);
			
			// Print the Token
			final java.util.List listRSTR = stsResponse.getRequestSecurityTokenResponseCollection();
			if (1 == listRSTR.size())
			{
				final org.eclipse.higgins.sts.api.IRequestSecurityTokenResponse RSTR = (org.eclipse.higgins.sts.api.IRequestSecurityTokenResponse)listRSTR.get(0);
				final org.eclipse.higgins.sts.api.IElement elemRequestedSecurityToken = RSTR.getRequestedSecurityToken();
				final String strRequestedSecurityToken = (String)elemRequestedSecurityToken.getAs(String.class);
				System.err.println("Token: " + strRequestedSecurityToken);
				
				/// This must be done before the Token is handed off to a Browser to be POSTed to the RP.
				final org.apache.axiom.om.OMElement omRequestedSecurityToken = (org.apache.axiom.om.OMElement)elemRequestedSecurityToken.getAs
					(org.apache.axiom.om.OMElement.class);
				final javax.xml.namespace.QName qnameEncryptedData = new javax.xml.namespace.QName
					(constants.getXMLEncryptionNamespace().toString(),
					"EncryptedData"); 	
				final javax.xml.namespace.QName qnameSAMLAssertion = new javax.xml.namespace.QName
					(constants.getSAML10AssertionNamespace().toString(),
					"Assertion"); 
				final org.apache.axiom.om.OMElement omReturnedSAMLAssertion = omRequestedSecurityToken.getFirstChildWithName
					(qnameSAMLAssertion);
				org.apache.axiom.om.OMElement omEncryptedSecurityToken = null;
				if (null != omReturnedSAMLAssertion)
				{
					org.eclipse.higgins.sts.spi.IXMLSecurityExtension xmlSecurity = (org.eclipse.higgins.sts.spi.IXMLSecurityExtension)mapGlobalSettings.get
						("XMLSecurityExtension");
					if (null == xmlSecurity)
					{
						final org.eclipse.higgins.configuration.api.IConfigurableComponentFactory xmlSecurityFactory = new org.eclipse.higgins.sts.xmlsecurity.apache.XMLSecurityApacheExtensionFactory();
						xmlSecurity = (org.eclipse.higgins.sts.spi.IXMLSecurityExtension)xmlSecurityFactory.getSingletonInstance();
						xmlSecurity.configure(mapGlobalSettings, null, null, null, null);
					}
				    final org.eclipse.higgins.sts.api.IElement elemEncryptedRequestedSecurityToken = xmlSecurity.EncryptElement
						("saml:Assertion",
						elemRequestedSecurityToken,
						strTestRPCertificate);
				    final org.apache.axiom.om.OMElement omEncryptedRequestedSecurityToken = (org.apache.axiom.om.OMElement)elemEncryptedRequestedSecurityToken.getAs(org.apache.axiom.om.OMElement.class);
				    omEncryptedSecurityToken = omEncryptedRequestedSecurityToken.getFirstElement();
					final String strEncryptedStringToken = org.eclipse.higgins.sts.utilities.XMLHelper.toString(omEncryptedSecurityToken);
					System.err.println("Encrypted Token: " + strEncryptedStringToken);
				}
				else
				{
					final org.apache.axiom.om.OMElement omReturnedEncryptedData = omRequestedSecurityToken.getFirstChildWithName
						(qnameEncryptedData);
					if (null != omReturnedEncryptedData)
					{
						omEncryptedSecurityToken = omReturnedEncryptedData;
					}
					else
					{
						System.err.println("Unexpected RequestedSecurityToken");
					}
				}
				// At this point the omEncryptedToken should be POSTed to the RP.
			}
		}
		catch (final Exception e)
		{
			org.eclipse.higgins.sts.utilities.ExceptionHelper.Log
				(this.log,
				e);
			e.printStackTrace(System.err);
			return "Error";			
		}
				
		System.out.println("Success");
		return "Success";
	}
}
