/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Michael McIntosh (IBM Corporation) - initial API and implementation
 *******************************************************************************/ 

package org.eclipse.higgins.sts.api.client;

import java.net.URI;
import java.security.cert.X509Certificate;

import org.eclipse.higgins.sts.api.IElement;
import org.eclipse.higgins.sts.api.ISTSRequest;

/**
 * @author mikemci at us dot ibm dot com
 *
 */
public interface IRequestFactory
{
/*
	public abstract org.eclipse.higgins.sts.api.ISTSRequest createRequestByTokenType
		(String strTokenType,
		String strUsername,
		String strPassword);
	
	public abstract org.eclipse.higgins.sts.api.ISTSRequest createRequestByRequestType
		(java.net.URI requestType,
		String strUsername,
		String strPassword);
	
	public abstract org.eclipse.higgins.sts.api.ISTSRequest createRequestByRequestType
		(java.net.URI requestType,
		java.net.URI tokenType,
		String strUsername,
		String strPassword);
*/
	public abstract org.eclipse.higgins.sts.api.ISTSRequest createRequest
		(final java.net.URI uriRelyingParty,
		final java.net.URI uriTokenService,
		final java.net.URI uriTokenType,
		final org.eclipse.higgins.sts.api.IElement claims,
		final String strUsername,
		final String strPassword);
	
	public abstract org.eclipse.higgins.sts.api.ISTSRequest createPersonalRequest
		(final URI uriRelyingParty,
		final java.security.cert.X509Certificate [] certRelyingPartyChain,
		final java.security.cert.CertStore certStore,
		final URI uriTokenType,
		final org.eclipse.higgins.icard.IInformationCard informationCard,
		final IElement claims);
	
	public abstract org.eclipse.higgins.sts.api.ISTSRequest createManagedRequest
		(final java.net.URI uriRelyingParty,
		final java.security.cert.X509Certificate [] certRelyingPartyChain,
		final java.security.cert.CertStore certStore,
		final java.net.URI uriTokenService,
		final X509Certificate certificateTokenService,
		final java.net.URI uriTokenType,
		final org.eclipse.higgins.icard.IInformationCard informationCard,
		final org.eclipse.higgins.sts.api.IElement claims,
		final String strUsername,
		final String strPassword);
	
	public abstract org.eclipse.higgins.sts.api.ISTSRequest createManagedRequest
		(final URI uriRelyingParty,
		final java.security.cert.X509Certificate [] certRelyingPartyChain,
		final java.security.cert.CertStore certStore,
		final URI uriTokenService,
		final X509Certificate certificateTokenService,
		final URI uriTokenType,
		final org.eclipse.higgins.icard.IInformationCard informationCard,
		final IElement claims,
		final org.eclipse.higgins.sts.api.ISecurityToken authenticationToken);

	public abstract org.eclipse.higgins.sts.api.ISTSRequest createManagedRequest
		(final URI uriRelyingParty,
		final java.security.cert.X509Certificate [] certRelyingPartyChain,
		final java.security.cert.CertStore certStore,
		final URI uriTokenService,
		final X509Certificate certificateTokenService,
		final URI uriTokenType,
		final org.eclipse.higgins.icard.IInformationCard informationCard,
		final IElement claims,
		final java.security.PrivateKey authenticationKey,
		final org.eclipse.higgins.sts.api.ISecurityToken authenticationToken);

}
