/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Michael McIntosh (IBM Corporation) - initial API and implementation
 *******************************************************************************/ 

package org.eclipse.higgins.sts.client;

import java.net.URI;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.icard.IManagedInformationCard;
import org.eclipse.higgins.sts.api.IElement;
import org.eclipse.higgins.sts.api.ISTSRequest;
import org.eclipse.higgins.sts.api.client.IRequestFactory;
import org.eclipse.higgins.sts.common.Element;
import org.eclipse.higgins.sts.common.STSRequest;

/**
 * @author mikemci at us dot ibm dot com
 *
 */
public class TokenRequestFactory implements IRequestFactory
{
	private static Log log = LogFactory.getLog(TokenRequestFactory.class);
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.client.IRequestFactory#createRSTByTokenType(java.lang.String)
	 */
	/*
	public org.eclipse.higgins.sts.api.ISTSRequest createRequestByTokenType
		(final String strTokenType,
		final String strUsername,
		final String strPassword)
	{
		final org.eclipse.higgins.sts.api.IConstants constants = new org.eclipse.higgins.sts.common.Constants();
		final org.eclipse.higgins.sts.common.RequestSecurityToken rst = new org.eclipse.higgins.sts.common.RequestSecurityToken();
		rst.setRequestType(constants.getIssueRequestType());
		rst.setTokenType(java.net.URI.create(strTokenType));
		final ISTSRequest request = new STSRequest();
		final org.eclipse.higgins.sts.api.ISecurityInformation securityInformation = new org.eclipse.higgins.sts.common.SecurityInformation();
		final org.eclipse.higgins.sts.api.IUsernameToken usernameToken = new org.eclipse.higgins.sts.common.UsernameToken();
		usernameToken.setUsername(strUsername);
		usernameToken.setPassword(strPassword);
		securityInformation.addSecurityElement(usernameToken);
		request.setSecurityInformation(securityInformation);
		final java.util.List listRST = request.getRequestSecurityTokenCollection();
		listRST.add(rst);
		return request;
	}

	public org.eclipse.higgins.sts.api.ISTSRequest createRequestByRequestType
		(final java.net.URI requestType,
		final String strUsername,
		final String strPassword)
	{	
		final org.eclipse.higgins.sts.api.IRequestSecurityToken rst = new org.eclipse.higgins.sts.common.RequestSecurityToken();
		rst.setRequestType(requestType);		
		final ISTSRequest request = new STSRequest();
		final org.eclipse.higgins.sts.api.ISecurityInformation securityInformation = new org.eclipse.higgins.sts.common.SecurityInformation();
		final org.eclipse.higgins.sts.api.IUsernameToken usernameToken = new org.eclipse.higgins.sts.common.UsernameToken();
		usernameToken.setUsername(strUsername);
		usernameToken.setPassword(strPassword);
		securityInformation.addSecurityElement(usernameToken);
		request.setSecurityInformation(securityInformation);
		final java.util.List listRST = request.getRequestSecurityTokenCollection();
		listRST.add(rst);
		return request;
	}
	
	public org.eclipse.higgins.sts.api.ISTSRequest createRequestByRequestType
		(final java.net.URI requestType,
        final java.net.URI tokenType,
		final String strUsername,
		final String strPassword)
	{	
		final org.eclipse.higgins.sts.api.IRequestSecurityToken rst = new org.eclipse.higgins.sts.common.RequestSecurityToken();
		rst.setRequestType(requestType);
		rst.setTokenType(tokenType);
		final ISTSRequest request = new STSRequest();
		final org.eclipse.higgins.sts.api.ISecurityInformation securityInformation = new org.eclipse.higgins.sts.common.SecurityInformation();
		final org.eclipse.higgins.sts.api.IUsernameToken usernameToken = new org.eclipse.higgins.sts.common.UsernameToken();
		usernameToken.setUsername(strUsername);
		usernameToken.setPassword(strPassword);
		securityInformation.addSecurityElement(usernameToken);
		request.setSecurityInformation(securityInformation);
		final java.util.List listRST = request.getRequestSecurityTokenCollection();
		listRST.add(rst);
		return request;
	}
	*/
	
	private org.eclipse.higgins.sts.api.ISTSRequest createRequest
		(final java.net.URI uriRelyingParty,
		final java.security.cert.X509Certificate [] certRelyingPartyChain,
		final java.security.cert.CertStore certStore,
		final java.net.URI uriTokenService,
		final X509Certificate certificateTokenService,
		final java.net.URI uriTokenType,
		final org.eclipse.higgins.icard.IInformationCard informationCard,
		final org.eclipse.higgins.sts.api.IElement claims,
		final boolean requestDisplayToken)
	{
		final ISTSRequest request = new STSRequest();
		final org.eclipse.higgins.sts.api.IRequestSecurityToken rst = new org.eclipse.higgins.sts.common.RequestSecurityToken();
		final org.eclipse.higgins.sts.api.IConstants constants = new org.eclipse.higgins.sts.common.Constants();
		rst.setRequestType(constants.getIssueRequestType());
		rst.setTokenType(uriTokenType);	
		final org.eclipse.higgins.sts.api.IEndpointReference eprIssuer = new org.eclipse.higgins.sts.common.EndpointReference();
		eprIssuer.setAddress(uriTokenService);
		rst.setIssuer(eprIssuer);
		if (certificateTokenService != null) {
			try {
				String stsCertificate = new String(org.apache.commons.codec.binary.Base64.encodeBase64(certificateTokenService.getEncoded()));
				eprIssuer.setIdentityCertificate(stsCertificate);
			}
			catch(CertificateEncodingException e) {
				log.error("Issuer certificate could not be included into RST", e);
			}
		}
		final org.eclipse.higgins.sts.api.ISecurityInformation securityInformation = new org.eclipse.higgins.sts.common.SecurityInformation();
		final org.eclipse.higgins.sts.api.ITimestamp timestamp = new org.eclipse.higgins.sts.common.Timestamp();
		final java.util.Date dateNow = new java.util.Date();
		final java.util.Date dateLater = new java.util.Date(dateNow.getTime() + (1000*60*60*24*7));
		timestamp.setCreated(dateNow);
		timestamp.setExpires(dateLater);
		securityInformation.addSecurityElement(timestamp);
		request.setSecurityInformation(securityInformation);
		final org.eclipse.higgins.sts.api.IInformationCardReference informationCardReference = new org.eclipse.higgins.sts.common.InformationCardReference();
		informationCardReference.setCardId(java.net.URI.create(informationCard.getID()));
		informationCardReference.setCardVersion(informationCard.getVersion());
		rst.setInformationCardReference(informationCardReference);
		try
		{
			byte [] computeClaimValuePPID = PPIDHelper.computeClaimValuePPID(informationCard,certRelyingPartyChain,certStore, (uriRelyingParty != null) ? uriRelyingParty.toString() : null);
			String strPPID = null;
			if (computeClaimValuePPID!=null)
			{
				strPPID = new String(org.apache.commons.codec.binary.Base64.encodeBase64(computeClaimValuePPID));
			
				final String strClientPseudonym = "<ic:ClientPseudonym xmlns:ic=\"http://schemas.xmlsoap.org/ws/2005/05/identity\">"
					+ "<ic:PPID>"
					+ strPPID
					+ "</ic:PPID>"
					+ "</ic:ClientPseudonym>";
				final org.eclipse.higgins.sts.api.IElement elemClientPseudonym = new org.eclipse.higgins.sts.common.Element();
				elemClientPseudonym.set(strClientPseudonym);
				rst.setClientPseudonym(elemClientPseudonym);
			}
			String strCertificate=null;
			if (certRelyingPartyChain != null && certRelyingPartyChain.length > 0)
			{
				strCertificate = new String(org.apache.commons.codec.binary.Base64.encodeBase64(certRelyingPartyChain[0].getEncoded()));
			}
			boolean bSendAppliesTo = false;
			java.lang.Boolean boolRequireAppliesTo = null;
			if (informationCard instanceof IManagedInformationCard)
			{
				boolRequireAppliesTo = ((IManagedInformationCard) informationCard).getRequireAppliesTo();
				if (null != boolRequireAppliesTo)
					bSendAppliesTo = !(boolRequireAppliesTo.booleanValue());
			}
			else
			{
				bSendAppliesTo = true;
			}

			if ((null != uriRelyingParty) && (bSendAppliesTo))
			{
				final org.eclipse.higgins.sts.api.IAppliesTo appliesTo = new org.eclipse.higgins.sts.common.AppliesTo();
				final org.eclipse.higgins.sts.api.IEndpointReference epr = new org.eclipse.higgins.sts.common.EndpointReference();
				appliesTo.setEndpointReference(epr);
				epr.setAddress(uriRelyingParty);
				if ((null != strCertificate) && (informationCard instanceof IManagedInformationCard))
				{
					epr.setIdentityCertificate(strCertificate);
				}
				rst.setAppliesTo(appliesTo);
			}
			rst.setKeyType(constants.getNoProofKeyKeyType());
		}
		catch (final Exception e)
		{
			e.printStackTrace();
		}

		if (null != claims) {
			rst.setClaims(claims);
		}
		if (requestDisplayToken) {
			addRequestSecurityToken(rst);
		}
		final java.util.List listRST = request.getRequestSecurityTokenCollection();
		listRST.add(rst);
		return request;
	}
	
	public org.eclipse.higgins.sts.api.ISTSRequest createManagedRequest
		(final java.net.URI uriRelyingParty,
		final java.security.cert.X509Certificate [] certRelyingPartyChain,
		final java.security.cert.CertStore certStore,
		final java.net.URI uriTokenService,
		final X509Certificate certificateTokenService,
		final java.net.URI uriTokenType,
		final org.eclipse.higgins.icard.IInformationCard informationCard,
		final org.eclipse.higgins.sts.api.IElement claims,
		final String strUsername,
		final String strPassword)
	{
		final ISTSRequest request = createRequest
			(uriRelyingParty,
			certRelyingPartyChain,
			certStore,
			uriTokenService,
			certificateTokenService,
			uriTokenType,
			informationCard,
			claims,
			true);
		final org.eclipse.higgins.sts.api.ISecurityInformation securityInformation = request.getSecurityInformation();
		final org.eclipse.higgins.sts.api.IUsernameToken usernameToken = new org.eclipse.higgins.sts.common.UsernameToken();
		usernameToken.setUsername(strUsername);
		usernameToken.setPassword(strPassword);
		securityInformation.addSecurityElement(usernameToken);
		return request;
	}

	public ISTSRequest createManagedRequest
		(final URI uriRelyingParty,
		final java.security.cert.X509Certificate [] certRelyingPartyChain,
		final java.security.cert.CertStore certStore,
		final URI uriTokenService,
		final X509Certificate certificateTokenService,
		final URI uriTokenType,
		final org.eclipse.higgins.icard.IInformationCard informationCard,
		final IElement claims,
		final org.eclipse.higgins.sts.api.ISecurityToken authenticationToken)
	{
		final ISTSRequest request = createRequest
			(uriRelyingParty,
			certRelyingPartyChain,
			certStore,
			uriTokenService,
			certificateTokenService,
			uriTokenType,
			informationCard,
			claims,
			true);
		final org.eclipse.higgins.sts.api.ISecurityInformation securityInformation = request.getSecurityInformation();
		securityInformation.addSecurityElement(authenticationToken);
		return request;
	}

	public ISTSRequest createManagedRequest
		(final URI uriRelyingParty,
		final java.security.cert.X509Certificate [] certRelyingPartyChain,
		final java.security.cert.CertStore certStore,
		final URI uriTokenService,
		final X509Certificate certificateTokenService,
		final URI uriTokenType,
		final org.eclipse.higgins.icard.IInformationCard informationCard,
		final IElement claims,
		final java.security.PrivateKey authenticationKey,
		final org.eclipse.higgins.sts.api.ISecurityToken authenticationToken)
	{
		final ISTSRequest request = createRequest
			(uriRelyingParty,
			certRelyingPartyChain,
			certStore,
			uriTokenService,
			certificateTokenService,
			uriTokenType,
			informationCard,
			claims,
			true);
		final org.eclipse.higgins.sts.api.ISecurityInformation securityInformation = request.getSecurityInformation();
		securityInformation.addSecurityElement(authenticationToken);
		securityInformation.setAuthenticationKey(authenticationKey);
		return request;
	}

	public ISTSRequest createPersonalRequest
		(final URI uriRelyingParty,
		final java.security.cert.X509Certificate [] certRelyingPartyChain,
		final java.security.cert.CertStore certStore,
		final URI uriTokenType,
		final org.eclipse.higgins.icard.IInformationCard informationCard,
		final IElement claims)
	{
		final ISTSRequest request = createRequest
			(uriRelyingParty,
			certRelyingPartyChain,
			certStore,
			java.net.URI.create("http://schemas.xmlsoap.org/ws/2005/05/identity/issuer/self"),
			null,
			uriTokenType,
			informationCard,
			claims,
			false);
		try
		{
			byte [] byteRPIdentifier = RelyingPartyIdentifierV15Helper.getRelyingPartyIdentifierForSigningKey
				(uriRelyingParty.toString(), certRelyingPartyChain);
			java.security.KeyPair kpSelf = org.eclipse.higgins.sts.utilities.KeyGenHelper.generateRSAKeyPair
				(informationCard.getMasterKey(),
				byteRPIdentifier,
				2048);
			request.setSelfSigningKeyPair(kpSelf);
		}
		catch (final Exception e)
		{
			e.printStackTrace();
		}
		return request;
	}

	// FIXME This is hardcoded now. Should be parametrized when creating a request
	private void addRequestSecurityToken (org.eclipse.higgins.sts.api.IRequestSecurityToken request) {
		try {
			Element rdt = new Element();
			rdt.set("<ic:RequestDisplayToken xmlns:ic=\"http://schemas.xmlsoap.org/ws/2005/05/identity\" xml:lang=\"en-us\"/>");
			request.setRequestDisplayToken(rdt);
		} catch (Exception e) {
			log.error(e, e);
		}
	}

	public ISTSRequest createRequest
		(URI uriRelyingParty,
		URI uriTokenService,
		URI uriTokenType,
		IElement claims,
		String strUsername,
		String strPassword)
	{
		final ISTSRequest request = new STSRequest();
		final org.eclipse.higgins.sts.api.IRequestSecurityToken rst = new org.eclipse.higgins.sts.common.RequestSecurityToken();
		final org.eclipse.higgins.sts.api.IConstants constants = new org.eclipse.higgins.sts.common.Constants();
		rst.setRequestType(constants.getIssueRequestType());
		rst.setTokenType(uriTokenType);	
		final org.eclipse.higgins.sts.api.IEndpointReference eprIssuer = new org.eclipse.higgins.sts.common.EndpointReference();
		eprIssuer.setAddress(uriTokenService);
		rst.setIssuer(eprIssuer);
		final org.eclipse.higgins.sts.api.ISecurityInformation securityInformation = new org.eclipse.higgins.sts.common.SecurityInformation();
		final org.eclipse.higgins.sts.api.ITimestamp timestamp = new org.eclipse.higgins.sts.common.Timestamp();
		final java.util.Date dateNow = new java.util.Date();
		final java.util.Date dateLater = new java.util.Date(dateNow.getTime() + (1000*60*60*24*7));
		timestamp.setCreated(dateNow);
		timestamp.setExpires(dateLater);
		securityInformation.addSecurityElement(timestamp);
		request.setSecurityInformation(securityInformation);
		try
		{
			if (null != uriRelyingParty)
			{
				final org.eclipse.higgins.sts.api.IAppliesTo appliesTo = new org.eclipse.higgins.sts.common.AppliesTo();
				final org.eclipse.higgins.sts.api.IEndpointReference epr = new org.eclipse.higgins.sts.common.EndpointReference();
				appliesTo.setEndpointReference(epr);
				epr.setAddress(uriRelyingParty);
				rst.setAppliesTo(appliesTo);
			}
			rst.setKeyType(constants.getNoProofKeyKeyType());
		}
		catch (final Exception e)
		{
			e.printStackTrace();
		}

		if (null != claims) {
			rst.setClaims(claims);
		}
		final java.util.List listRST = request.getRequestSecurityTokenCollection();
		listRST.add(rst);
		final org.eclipse.higgins.sts.api.IUsernameToken usernameToken = new org.eclipse.higgins.sts.common.UsernameToken();
		usernameToken.setUsername(strUsername);
		usernameToken.setPassword(strPassword);
		securityInformation.addSecurityElement(usernameToken);
		return request;
	}
}
