/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.sts.client;

import java.util.LinkedHashMap;

public class DNParser {
    private static final char SEP = '=';
    private static final char QUOTE = '\"';
    private static final char DELIM = ',';
    private static final char ESCAPE = '\\';

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LinkedHashMap parse(String dn) throws Exception {
        LinkedHashMap<String, String> dnMap = new LinkedHashMap<String, String>();
        boolean isKeyProcessed = true;
        boolean startedQuote = false;
        String key = "";
        StringBuffer currentToken = new StringBuffer();
        char current = '\u0000';
        char previous = '\u0000';
        int i = 0;
        int size = dn.length();
        while (i < size) {
            previous = current;
            current = dn.charAt(i);
            if (current == '=') {
                if (isKeyProcessed) {
                    key = currentToken.toString();
                    currentToken = new StringBuffer();
                    isKeyProcessed = false;
                } else {
                    if (!startedQuote) throw new Exception("Unexpected symbol at possition " + i + ", " + dn);
                    currentToken.append(current);
                }
            } else if (current == '\\') {
                if (previous == '\\') {
                    currentToken.append(current);
                }
            } else if (current == '\"') {
                if (previous == '\\') {
                    currentToken.append(current);
                } else {
                    if (isKeyProcessed) throw new Exception("Unexpected symbol at possition " + i + ", " + dn);
                    startedQuote = !startedQuote;
                    currentToken.append(current);
                }
            } else if (current == ',') {
                if (previous == '\\') {
                    currentToken.append(current);
                } else {
                    if (isKeyProcessed) throw new Exception("Unexpected symbol at possition " + i + ", " + dn);
                    if (startedQuote) {
                        currentToken.append(current);
                    } else {
                        String value = currentToken.toString();
                        dnMap.put(key.trim(), value.trim());
                        isKeyProcessed = true;
                        startedQuote = false;
                        key = "";
                        currentToken = new StringBuffer();
                    }
                }
            } else {
                currentToken.append(current);
            }
            ++i;
        }
        if (isKeyProcessed) return dnMap;
        String value = currentToken.toString();
        dnMap.put(key.trim(), value.trim());
        return dnMap;
    }
}

