/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.sts.client;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertStore;
import java.security.cert.X509Certificate;
import org.apache.axiom.om.util.Base64;
import org.eclipse.higgins.icard.IInformationCard;
import org.eclipse.higgins.sts.client.RelyingPartyIdentifierV15Helper;

public class PPIDHelper {
    private static final char[] userFriendlyPPIDValuetabe = new char[]{'Q', 'L', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'J', 'K', 'M', 'N', 'P', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};

    public static byte[] computeClaimValuePPID(IInformationCard informationCard, X509Certificate[] rp, CertStore certStore, String rpURI) throws Exception {
        byte[] ppid;
        byte[] rpId = RelyingPartyIdentifierV15Helper.getRelyingPartyIdentifier(rpURI, rp);
        if (informationCard.isSelfIssued()) {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            byte[] cardIdB = informationCard.getID().getBytes("UTF-16LE");
            byte[] canonicalCardId = md.digest(cardIdB);
            md.reset();
            md.update(rpId);
            md.update(canonicalCardId);
            ppid = md.digest();
        } else {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            byte[] masterKey = informationCard.getMasterKey();
            byte[] salt = informationCard.getHashSalt();
            md.update(masterKey);
            md.update(rpId);
            md.update(salt);
            ppid = md.digest();
        }
        return ppid;
    }

    public static String getUserFriendlyPPID(byte[] ppid) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        byte[] ppidh = md.digest(ppid);
        StringBuffer res = new StringBuffer();
        int i = 0;
        while (i < 10) {
            int value = ppidh[i];
            if ((value %= 32) < 0) {
                value += 32;
            }
            char A_i = userFriendlyPPIDValuetabe[value];
            res.append(A_i);
            if (i == 2 || i == 6) {
                res.append('-');
            }
            ++i;
        }
        return res.toString();
    }

    public static String getUserFriendlyPPID(String ppid) throws Exception {
        byte[] bppid = Base64.decode((String)ppid);
        return PPIDHelper.getUserFriendlyPPID(bppid);
    }
}

