/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Michael McIntosh (IBM Corporation) - initial API and implementation
 *******************************************************************************/ 

package org.eclipse.higgins.sts.client;

import org.eclipse.higgins.configuration.api.ISettingDescriptor;
import org.eclipse.higgins.sts.api.IConstants;

/**
 * Implements the Higgins Security Token Service Client.
 * 
 * @author mikemci at us dot ibm dot com
 */
// TODO: Implement some form of Java Authorization
public class MetadataExchangeService
	implements org.eclipse.higgins.sts.api.IMetadataExchangeService
{
	private final org.eclipse.higgins.sts.utilities.LogHelper log = new org.eclipse.higgins.sts.utilities.LogHelper
		(MetadataExchangeService.class.getName());
	
	org.eclipse.higgins.sts.api.IMetadataExchangeService bindingMetadataExchangeServiceClient = null;
	
	/**
	 * Indicates whether Initialize was called successfully.
	 */
	private boolean bInitialized = false;
	
	/**
	 *  Creates and initializes the Class. 
	 */
	protected MetadataExchangeService()
		throws Exception
	{
		this.log.trace("SecurityTokenService::SecurityTokenService");
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.client.ISecurityTokenService#configure()
	 */
	public void configure
		(final java.util.Map mapGlobalSettings,
		final String strComponentName,
		final java.util.Map mapComponentSettings,
		final ISettingDescriptor componentDescriptor,
		final ISettingDescriptor globalDescriptor)
	{
		this.log.trace("SecurityTokenService::initialize");
		
		this.bindingMetadataExchangeServiceClient = (org.eclipse.higgins.sts.api.IMetadataExchangeService)mapGlobalSettings.get
			("MetadataExchangeServiceBinding");
		
		this.bInitialized = true;
	}
	
	public org.eclipse.higgins.sts.api.IMEXResponse getMetadata
		(final java.util.Map mapGlobalSettings,
		final String strComponentName,
		final java.util.Map mapComponentSettings,
		final java.util.Map mapInvocationSettings,
		final IConstants constants,
		final java.net.URI uriRequest) throws Exception
	{
		this.log.trace("SecurityTokenService::getMetadata");

		if (!this.bInitialized)
		{/*
			log.error("Not Initialized");
			Fault fault = new Fault
				(constants.getWSTrustNamespace(),
				"wst",
				constants.getRequestFailedFaultCode(),
				"The specified request failed",
				"Not initialized.");
			response.setFault(fault);	*/		
			return null;
		}
		return this.bindingMetadataExchangeServiceClient.getMetadata
			(mapGlobalSettings,
			strComponentName,
			mapComponentSettings,
			mapInvocationSettings,
			constants,
			uriRequest);
	}
	
	public ISettingDescriptor getComponentDescriptor() {
		return null;
	}

}
