/*******************************************************************************
 * Copyright (c) 2006-2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Michael McIntosh (IBM Corporation) - initial API and implementation
 *******************************************************************************/ 

package org.eclipse.higgins.sts.common;

import java.net.URI;

import org.eclipse.higgins.sts.api.IDigitalIdentity;

/**
 * @author mikemci
 */
public class DigitalIdentity
	implements IDigitalIdentity
{
	boolean bIncludePPIClaim = false;
	
	java.net.URI uriSubjectNameIdentifier = null;
	
	java.util.List listClaims = new java.util.ArrayList();
	
	java.util.Map mapClaims = new java.util.Hashtable();
	
	URI type = null;
	
	public void addClaim(final org.eclipse.higgins.sts.api.IClaim claim)
	{
		final org.eclipse.higgins.sts.api.IClaimType claimType = claim.getType();
		this.listClaims.add(claim);
		this.mapClaims.put(claimType.getName(), claim);
	}
	
	public org.eclipse.higgins.sts.api.IClaim getClaim(final java.net.URI uriClaimType)
	{
		return (org.eclipse.higgins.sts.api.IClaim)this.mapClaims.get(uriClaimType);
	}
	
	public java.util.List getClaims()
	{
		return this.listClaims;
	}
	
	

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IDigitalIdentity#getSerialized()
	 */
	public Object getSerialized()
	{
		return null;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IDigitalIdentity#getType()
	 */
	public URI getType()
	{
		return this.type;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IDigitalIdentity#setType(java.net.URI)
	 */
	public void setType(final URI uriType)
	{
		this.type = uriType;
	}

	/**
	 * @return the bIncludePPIClaim
	 */
	public boolean getIncludePPIClaim() {
		return bIncludePPIClaim;
	}

	/**
	 * @param includePPIClaim the bIncludePPIClaim to set
	 */
	public void setIncludePPIClaim(boolean includePPIClaim) {
		bIncludePPIClaim = includePPIClaim;
	}

	/**
	 * @return the uriSubjectNameIdentifier
	 */
	public java.net.URI getSubjectNameIdentifierURI() {
		return uriSubjectNameIdentifier;
	}

	/**
	 * @param uriSubjectNameIdentifier the uriSubjectNameIdentifier to set
	 */
	public void setSubjectNameIdentifierURI(java.net.URI uriSubjectNameIdentifier) {
		this.uriSubjectNameIdentifier = uriSubjectNameIdentifier;
	}
}
