/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Michael McIntosh (IBM Corporation) - initial API and implementation
 *******************************************************************************/ 

package org.eclipse.higgins.sts.common;

import org.eclipse.higgins.sts.api.IDigitalIdentity;
import org.eclipse.higgins.sts.api.IElement;
import org.eclipse.higgins.sts.api.IRequestSecurityToken;

/**
 * Framework independent encapsulation of the WS-Trust RequestSecurityToken contents
 * 
 * @author mikemci at us dot ibm dot com
 */
public class RequestSecurityToken implements IRequestSecurityToken
{
	private final org.eclipse.higgins.sts.utilities.LogHelper log = new org.eclipse.higgins.sts.utilities.LogHelper
		(RequestSecurityToken.class.getName());

	private org.eclipse.higgins.sts.api.IInformationCardReference informationCardReference = null;

	/**
	 * Digital Subject
	 */
	private org.eclipse.higgins.sts.api.IDigitalIdentity digitalIdentity = null;

	private IElement elemClientPseudonym = null;

	/**
	 * @return the elemClientPseudonym
	 */
	public IElement getClientPseudonym() {
		return this.elemClientPseudonym;
	}

	/**
	 * @param elemClientPseudonym the elemClientPseudonym to set
	 */
	public void setClientPseudonym(final IElement elemClientPseudonym) {
		this.elemClientPseudonym = elemClientPseudonym;
	}

	/**
	 * @return the informationCardReference
	 */
	public org.eclipse.higgins.sts.api.IInformationCardReference getInformationCardReference()
	{
		return this.informationCardReference;
	}

	/**
	 * @param informationCardReference the informationCardReference to set
	 */
	public void setInformationCardReference
		(final org.eclipse.higgins.sts.api.IInformationCardReference informationCardReference)
	{
		this.informationCardReference = informationCardReference;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityToken#getDigitalIdentity()
	 */
	public IDigitalIdentity getDigitalIdentity()
	{
		this.log.trace("getDigitalIdentity");
		return this.digitalIdentity;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityToken#setDigitalSubject(org.eclipse.higgins.sts.IDigitalIdentity)
	 */
	public void setDigitalIdentity
		(final org.eclipse.higgins.sts.api.IDigitalIdentity digitalIdentity)
	{
		this.digitalIdentity = digitalIdentity;
	}
	
	/**
	 * The value of the Context attribute associated with the RequestSecurityToken element
	 */
	private String strContext = null;

	/**
	 * The Base element associated with the RequestSecurityToken element
	 */
	private IElement elemBase = null;

	/**
	 * The ComputedKeyAlgorithm URI associated with the RequestSecurityToken element
	 */
	private java.net.URI uriComputedKeyAlgorithm = null;

	/**
	 * The RequestDisplayToken URI associated with the RequestSecurityToken element
	 */
	private IElement elemRequestDisplayToken = null;

	/**
	 * The TokenType URI associated with the RequestSecurityToken element
	 */
	private java.net.URI uriTokenType = null;

	/**
	 * The RequestType URI associated with the RequestSecurityToken element
	 */
	private java.net.URI uriRequestType = null;
	
	/**
	 * The AppliesTo associated with the RequestSecurityToken element
	 */
	private org.eclipse.higgins.sts.api.IAppliesTo appliesTo = null;
	
	/**
	 * The CancelTarget element associated with the RequestSecurityToken element
	 */
	private IElement elemCancelTarget = null;
	
	/**
	 * The ValidateTarget element associate with the RequestSecurityToken element
	 */
	private IElement elemValidateTarget = null;

	/**
	 * The RenewTarget element associate with the RequestSecurityToken element
	 */
	private IElement elemRenewTarget = null;

	/**
	 * The Claims element associated with the RequestSecurityToken element
	 */
	private IElement elemClaims = null;

	/**
	 * The Entropy element associated with the RequestSecurityToken element
	 */
	private IElement elemEntropy = null;

	/**
	 * The Lifetime associated with the RequestSecurityToken element
	 */
	private org.eclipse.higgins.sts.api.ILifetime ltLifetime = null;

	/**
	 * The AllowPostdating element associated with the RequestSecurityToken element
	 */
	private IElement elemAllowPostdating = null;

	/**
	 * The Renewing element associated with the RequestSecurityToken element
	 */
	private IElement elemRenewing = null;

	/**
	 * The OnBehalfOf element associated with the RequestSecurityToken element
	 */
	private IElement elemOnBehalfOf = null;

	/**
	 * The Issuer EPR associated with the RequestSecurityToken element
	 */
	private org.eclipse.higgins.sts.api.IEndpointReference eprIssuer = null;

	/**
	 * The AuthenticationType element associated with the RequestSecurityToken element
	 */
	private java.net.URI uriAuthenticationType = null;

	/**
	 * The KeyType element associated with the RequestSecurityToken element
	 */
	private java.net.URI uriKeyType = null;

	/**
	 * The KeySize element associated with the RequestSecurityToken element
	 */
	private java.lang.Integer intKeySize = null;

	/**
	 * The SignatureAlgorithm element associated with the RequestSecurityToken element
	 */
	private java.net.URI uriSignatureAlgorithm = null;

	/**
	 * The Encryption element associated with the RequestSecurityToken element
	 */
	private IElement elemEncryption = null;

	/**
	 * The EncryptionAlgorithm element associated with the RequestSecurityToken element
	 */
	private java.net.URI uriEncryptionAlgorithm = null;

	/**
	 * The EncryptionAlgorithm element associated with the RequestSecurityToken element
	 */
	private java.net.URI uriCanonicalizationAlgorithm = null;

	/**
	 * The ProofEncryption element associated with the RequestSecurityToken element
	 */
	private IElement elemProofEncryption = null;

	/**
	 * The UseKey element associated with the RequestSecurityToken element
	 */
	private IElement elemUseKey = null;
	
	/**
	 * The SignWith element associated with the RequestSecurityToken element
	 */
	private java.net.URI uriSignWith = null;

	/**
	 * The EncryptWith element associated with the RequestSecurityToken element
	 */
	private java.net.URI uriEncryptWith = null;
	
	/**
	 * The DelegateTo element associated with the RequestSecurityToken element
	 */
	private IElement elemDelegateTo = null;

	/**
	 * The Forwardable element associated with the RequestSecurityToken element
	 */
	private java.lang.Boolean boolForwardable = null;

	/**
	 * The Delegatable element associated with the RequestSecurityToken element
	 */
	private java.lang.Boolean boolDelegatable = null;

	/**
	 * The Policy element associated with the RequestSecurityToken element
	 */
	private IElement elemPolicy = null;

	/**
	 * The PolicyReference element associated with the RequestSecurityToken element
	 */
	private IElement elemPolicyReference = null;
	
	/**
	 * Any other miscellaneous elements associated with the RequestSecurityToken element
	 */
	private final java.util.List listAnyOtherElements = new java.util.ArrayList();
	
	/**
	 * This object can contain any non-XML data to be associated with the RequestSecurityToken
	 */
	private java.lang.Object objectData = null;

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityToken#getContext()
	 */
	public String getContext()
	{
		return this.strContext;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityToken#getBase()
	 */
	public IElement getBase()
	{
		return this.elemBase;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityToken#getComputedKeyAlgorithm()
	 */
	public java.net.URI getComputedKeyAlgorithm()
	{
		return this.uriComputedKeyAlgorithm;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityToken#getTokenType()
	 */
	public java.net.URI getTokenType()
	{
		return this.uriTokenType;
	}
	
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityToken#getRequestDisplayToken()
	 */
	public IElement getRequestDisplayToken()
	{
		return this.elemRequestDisplayToken;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityToken#getRequestType()
	 */
	public java.net.URI getRequestType()
	{
		return this.uriRequestType;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityToken#getAppliesTo()
	 */
	public org.eclipse.higgins.sts.api.IAppliesTo getAppliesTo()
	{
		return this.appliesTo;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityToken#getCancelTarget()
	 */
	public IElement getCancelTarget()
	{
		return this.elemCancelTarget;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityToken#getValidateTarget()
	 */
	public IElement getValidateTarget()
	{
		return this.elemValidateTarget;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityToken#getRenewTarget()
	 */
	public IElement getRenewTarget()
	{
		return this.elemRenewTarget;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityToken#getClaims()
	 */
	public IElement getClaims()
	{
		return this.elemClaims;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityToken#getEntropy()
	 */
	public IElement getEntropy()
	{
		return this.elemEntropy;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityToken#getLifetime()
	 */
	public org.eclipse.higgins.sts.api.ILifetime getLifetime()
	{
		return this.ltLifetime;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityToken#getAllowPostdating()
	 */
	public IElement getAllowPostdating()
	{
		return this.elemAllowPostdating;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityToken#getRenewing()
	 */
	public IElement getRenewing()
	{
		return this.elemRenewing;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityToken#getOnBehalfOf()
	 */
	public IElement getOnBehalfOf()
	{
		return this.elemOnBehalfOf;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityToken#getIssuer()
	 */
	public org.eclipse.higgins.sts.api.IEndpointReference getIssuer()
	{
		return this.eprIssuer;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityToken#getAuthenticationType()
	 */
	public java.net.URI getAuthenticationType()
	{
		return this.uriAuthenticationType;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityToken#getKeyType()
	 */
	public java.net.URI getKeyType()
	{
		return this.uriKeyType;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityToken#getKeySize()
	 */
	public java.lang.Integer getKeySize()
	{
		return this.intKeySize;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityToken#getSignatureAlgorithm()
	 */
	public java.net.URI getSignatureAlgorithm()
	{
		return this.uriSignatureAlgorithm;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityToken#getEncryption()
	 */
	public IElement getEncryption()
	{
		return this.elemEncryption;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityToken#getEncryptionAlgorithm()
	 */
	public java.net.URI getEncryptionAlgorithm()
	{
		return this.uriEncryptionAlgorithm;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityToken#getCanonicalizationAlgorithm()
	 */
	public java.net.URI getCanonicalizationAlgorithm()
	{
		return this.uriCanonicalizationAlgorithm;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityToken#getProofEncryption()
	 */
	public IElement getProofEncryption()
	{
		return this.elemProofEncryption;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityToken#getUseKey()
	 */
	public IElement getUseKey()
	{
		return this.elemUseKey;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityToken#getSignWith()
	 */
	public java.net.URI getSignWith()
	{
		return this.uriSignWith;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityToken#getEncryptWith()
	 */	
	public java.net.URI getEncryptWith()
	{
		return this.uriEncryptWith;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityToken#getDelegateTo()
	 */
	public IElement getDelegateTo()
	{
		return this.elemDelegateTo;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityToken#getForwardable()
	 */
	public java.lang.Boolean getForwardable()
	{
		return this.boolForwardable;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityToken#getDelegatable()
	 */
	public java.lang.Boolean getDelegatable()
	{
		return this.boolDelegatable;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityToken#getPolicy()
	 */
	public IElement getPolicy()
	{
		return this.elemPolicy;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityToken#getPolicyReference()
	 */
	public IElement getPolicyReference()
	{
		return this.elemPolicyReference;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityToken#getAnyOtherElements()
	 */
	public java.util.List getAnyOtherElements()
	{
		return this.listAnyOtherElements;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityToken#getData()
	 */
	public java.lang.Object getData()
	{
		return this.objectData;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityToken#setBase(org.eclipse.higgins.sts.IElement)
	 */
	public void setBase
		(final IElement elemBase)
	{
		this.elemBase = elemBase;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityToken#setComputedKeyAlgorithm(java.net.URI)
	 */
	public void setComputedKeyAlgorithm
		(final java.net.URI uriComputedKeyAlgorithm)
	{
		this.uriComputedKeyAlgorithm = uriComputedKeyAlgorithm;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityToken#setTokenType(java.net.URI)
	 */
	public void setTokenType
		(final java.net.URI uriTokenType)
	{
		this.uriTokenType = uriTokenType;
	}


	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityToken#setRequestDisplayToken(org.eclipse.higgins.sts.IElement)
	 */
	public void setRequestDisplayToken
		(final IElement elemRequestDisplayToken)
	{
		this.elemRequestDisplayToken = elemRequestDisplayToken;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityToken#setRequestType(java.net.URI)
	 */
	public void setRequestType
		(final java.net.URI uriRequestType)
	{
		this.uriRequestType = uriRequestType;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityToken#setAppliesTo(org.eclipse.higgins.sts.IEndpointReference)
	 */
	public void setAppliesTo
		(final org.eclipse.higgins.sts.api.IAppliesTo appliesTo)
	{
		this.appliesTo = appliesTo;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityToken#setCancelTarget(org.eclipse.higgins.sts.IElement)
	 */
	public void setCancelTarget
		(final IElement elemCancelTarget)
	{
		this.elemCancelTarget = elemCancelTarget;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityToken#setValidateTarget(org.eclipse.higgins.sts.IElement)
	 */
	public void setValidateTarget
		(final IElement elemValidateTarget)
	{
		this.elemValidateTarget = elemValidateTarget;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityToken#setRenewTarget(org.eclipse.higgins.sts.IElement)
	 */
	public void setRenewTarget
		(final IElement elemRenewTarget)
	{
		this.elemRenewTarget = elemRenewTarget;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityToken#setClaims(org.eclipse.higgins.sts.IElement)
	 */
	public void setClaims
		(final IElement elemClaims)
	{
		this.elemClaims = elemClaims;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityToken#setEntropy(org.eclipse.higgins.sts.IElement)
	 */
	public void setEntropy
		(final IElement elemEntropy)
	{
		this.elemEntropy = elemEntropy;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityToken#setLifetime(org.eclipse.higgins.sts.ILifetime)
	 */
	public void setLifetime
		(final org.eclipse.higgins.sts.api.ILifetime ltLifetime)
	{
		this.ltLifetime = ltLifetime;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityToken#setAllowPostdating(org.eclipse.higgins.sts.IElement)
	 */
	public void setAllowPostdating
		(final IElement elemAllowPostdating)
	{
		this.elemAllowPostdating = elemAllowPostdating;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityToken#setRenewing(org.eclipse.higgins.sts.IElement)
	 */
	public void setRenewing
		(final IElement elemRenewing)
	{
		this.elemRenewing = elemRenewing;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityToken#setOnBehalfOf(org.eclipse.higgins.sts.IElement)
	 */
	public void setOnBehalfOf
		(final IElement elemOnBehalfOf)
	{
		this.elemOnBehalfOf = elemOnBehalfOf;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityToken#setIssuer(org.eclipse.higgins.sts.IEndpointReference)
	 */
	public void setIssuer
		(final org.eclipse.higgins.sts.api.IEndpointReference eprIssuer)
	{
		this.eprIssuer = eprIssuer;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityToken#setAuthenticationType(java.net.URI)
	 */
	public void setAuthenticationType
		(final java.net.URI uriAuthenticationType)
	{
		this.uriAuthenticationType = uriAuthenticationType;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityToken#setKeyType(java.net.URI)
	 */
	public void setKeyType
		(final java.net.URI uriKeyType)
	{
		this.uriKeyType = uriKeyType;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityToken#setKeySize(integer)
	 */
	public void setKeySize
		(final int nKeySize)
	{
		this.intKeySize = new Integer(nKeySize);
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityToken#setSignatureAlgorithm(java.net.URI)
	 */
	public void setSignatureAlgorithm
		(final java.net.URI uriSignatureAlgorithm)
	{
		this.uriSignatureAlgorithm = uriSignatureAlgorithm;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityToken#setEncryption(org.eclipse.higgins.sts.IElement)
	 */
	public void setEncryption
		(final IElement elemEncryption)
	{
		this.elemEncryption = elemEncryption;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityToken#setEncryptionAlgorithm(java.net.URI)
	 */
	public void setEncryptionAlgorithm
		(final java.net.URI uriEncryptionAlgorithm)
	{
		this.uriEncryptionAlgorithm = uriEncryptionAlgorithm;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityToken#setCanonicalizationAlgorithm(java.net.URI)
	 */
	public void setCanonicalizationAlgorithm
		(final java.net.URI uriCanonicalizationAlgorithm)
	{
		this.uriCanonicalizationAlgorithm = uriCanonicalizationAlgorithm;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityToken#setProofEncryption(org.eclipse.higgins.sts.IElement)
	 */
	public void setProofEncryption
		(final IElement elemProofEncryption)
	{
		this.elemProofEncryption = elemProofEncryption;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityToken#setUseKey(org.eclipse.higgins.sts.IElement)
	 */
	public void setUseKey
		(final IElement elemUseKey)
	{
		this.elemUseKey = elemUseKey;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityToken#setSignWith(java.net.URI)
	 */
	public void setSignWith
		(final java.net.URI uriSignWith)
	{
		this.uriSignWith = uriSignWith;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityToken#setEncryptWith(java.net.URI)
	 */
	public void setEncryptWith
		(final java.net.URI uriEncryptWith)
	{
		this.uriEncryptWith = uriEncryptWith;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityToken#setDelegateTo(org.eclipse.higgins.sts.IElement)
	 */
	public void setDelegateTo
		(final IElement elemDelegateTo)
	{
		this.elemDelegateTo = elemDelegateTo;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityToken#setForwardable(boolean)
	 */
	public void setForwardable
		(final boolean bForwardable)
	{
		this.boolForwardable = new java.lang.Boolean(bForwardable);
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityToken#setDelegatable(boolean)
	 */
	public void setDelegatable
		(final boolean bDelegatable)
	{
		this.boolDelegatable = new java.lang.Boolean(bDelegatable);
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityToken#setPolicy(org.eclipse.higgins.sts.IElement)
	 */
	public void setPolicy
		(final IElement elemPolicy)
	{
		this.elemPolicy = elemPolicy;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityToken#setPolicyReference(org.eclipse.higgins.sts.IElement)
	 */
	public void setPolicyReference
		(final IElement elemPolicyReference)
	{
		this.elemPolicyReference = elemPolicyReference;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityToken#setContext(String)
	 */
	public void setContext
		(final String strContext)
	{
		this.strContext = strContext;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityToken#setData(java.lang.Object)
	 */
	public void setData
		(final java.lang.Object objectData)
	{
		this.objectData = objectData;
	}
}
