/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Michael McIntosh (IBM Corporation) - initial API and implementation
 *******************************************************************************/ 

package org.eclipse.higgins.sts.utilities;

/**
 * Used to help with common XML processing functions
 * 
 * @author mikemci at us dot ibm dot com
 */
//TODO: Finish commenting this class
//TODO: Finish implementing this class
public class XMLHelper
{
	static private final org.eclipse.higgins.sts.utilities.LogHelper log = new org.eclipse.higgins.sts.utilities.LogHelper
		(XMLHelper.class.getName());
	
    /****** Mask password out of trace ******/
	public static void maskPasswordForChildren(org.w3c.dom.Element element)
	{	
		if (element.hasAttribute("password"))
		{
			try
			{
				element.setAttribute("password", "xxxxx");				
			}
			catch (Exception e){}
		}
		
		if (element.getLocalName().equalsIgnoreCase("password"))
		{
			setTextContent(element, "xxxxx");
		}
		
		org.w3c.dom.NodeList nlist = element.getChildNodes();
		if (null != nlist)
		{
			int nlen = nlist.getLength();
			for (int i=0;i<nlen;i++)
			{
				org.w3c.dom.Node childNode = nlist.item(i);
				if (childNode.getNodeType() == org.w3c.dom.Node.ELEMENT_NODE)
				{
					org.w3c.dom.Element childElem = (org.w3c.dom.Element)childNode;
					maskPasswordForChildren(childElem);
				}
			}
		}
	}        			
    /****************************************/

    public static String htmlEncode(String pText)
    {
    	java.util.StringTokenizer tokenizer = new java.util.StringTokenizer(pText, "&<>\"", true);
        int tokenCount = tokenizer.countTokens();
        /* no encoding's needed */
        if (tokenCount == 1)
            return pText;
        /*
         * text.length + (tokenCount * 6) gives buffer large enough so no
         * addition memory would be needed and no costly copy operations would
         * occur
         */
        StringBuffer buffer = new StringBuffer(pText.length() + tokenCount * 6);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.length() == 1) {
                switch (token.charAt(0)) {
                case '&':
                    buffer.append("&amp;");
                    break;
                case '<':
                    buffer.append("&lt;");
                    break;
                case '>':
                    buffer.append("&gt;");
                    break;
                case '"':
                    buffer.append("&quot;");
                    break;
                default:
                    buffer.append(token);
                }
            } else {
                buffer.append(token);
            }
        }
        return buffer.toString();
    }

    static String[] htmlEncode(String[] strs)
    {
        String[] result = null;
        if (strs != null) {
            result = new String[strs.length];

            for (int i = 0; i < strs.length; i++) {
                result[i] = htmlEncode(strs[i]);
            }
        }
        return result;
    }
	
	static public String escapedString(final String strUnescaped)
	{
		final String strEscapedAmps = strUnescaped.replaceAll("&", "&amp;");
		final String strEscapedHash = strEscapedAmps.replaceAll("#", "%23");
		final String strResult = strEscapedHash.replaceFirst("%23", "#");
		return strResult;
	}

    static public byte[] toByteArr(final String no) {
		final byte[] number = new byte[no.length() / 2];
		int i;
		for (i = 0; i < no.length(); i += 2) {
			final int j = Integer.parseInt(no.substring(i, i + 2), 16);
			number[i / 2] = (byte) (j & 0x000000ff);
		}
		return number;
	}

	static public void printHex(final byte[] b) {
		XMLHelper.printHex(b, b.length);
	}

	static public void printHex(final short[] b) {
		XMLHelper.printHex(b, b.length);
	}

	static public void printHex(final int[] b) {
		XMLHelper.printHex(b, b.length);
	}

	static public void printHex(final String label, final byte[] b) {
		XMLHelper.printHex(label, b, b.length);
	}

	static public void printHex(final String label, final short[] b) {
		XMLHelper.printHex(label, b, b.length);
	}

	static public void printHex(final String label, final int[] b) {
		XMLHelper.printHex(label, b, b.length);
	}

	static public String toHexF(final String label, final byte[] b) {
		return XMLHelper.toHexF(label, b, b.length);
	}

	static public String toHexF(final String label, final short[] b) {
		return XMLHelper.toHexF(label, b, b.length);
	}

	static public String toHexF(final String label, final int[] b) {
		return XMLHelper.toHexF(label, b, b.length);
	}

	static public String toHexF(final int[] b) {
		return XMLHelper.toHexF(b, b.length);
	}

	static public String toHexF(final short[] b) {
		return XMLHelper.toHexF(b, b.length);
	}

	static public String toHexF(final byte[] b) {
		return XMLHelper.toHexF(b, b.length);
	}

	static public String toHex(final byte[] b) {
		return XMLHelper.toHex(b, b.length);
	}

	static public String toHex(final short[] b) {
		return XMLHelper.toHex(b, b.length);
	}

	static public String toHex(final int[] b) {
		return XMLHelper.toHex(b, b.length);
	}

	static public void printHex(final String label, final byte[] b, final int len) {
		System.out.println(label);
		XMLHelper.printHex(b, len);
	}

	static public void printHex(final String label, final short[] b, final int len) {
		System.out.println(label);
		XMLHelper.printHex(b, len);
	}

	static public void printHex(final String label, final int[] b, final int len) {
		System.out.println(label);
		XMLHelper.printHex(b, len);
	}

	static public void printHex(final byte[] b, final int len) {
		System.out.print(XMLHelper.toHexF(b, len));
	}

	static public void printHex(final short[] b, final int len) {
		System.out.print(XMLHelper.toHexF(b, len));
	}

	static public void printHex(final int[] b, final int len) {
		System.out.print(XMLHelper.toHexF(b, len));
	}

	static public String toHexF(final String label, final int[] b, final int len) {
		return label + "\n" + XMLHelper.toHexF(b, len);
	}

	static public String toHexF(final String label, final short[] b, final int len) {
		return label + "\n" + XMLHelper.toHexF(b, len);
	}

	static public String toHexF(final String label, final byte[] b, final int len) {
		return label + "\n" + XMLHelper.toHexF(b, len);
	}

	static public String toHexF(final byte[] b, final int len) {
		final StringBuffer s = new StringBuffer("");
		int i;

		if (b == null) {
			return "<null>";
		}

		for (i = 0; i < len; i++) {
			s.append(" " + XMLHelper.toHex(b[i]));
			if (i % 16 == 15) {
				s.append("\n");
			} else if (i % 8 == 7) {
				s.append(" ");
			} else if (i % 4 == 3) {
				s.append(" ");
			}
		}
		if (i % 16 != 0) {
			s.append("\n");
		}

		return s.toString();
	}

	static public String toHexF(final short[] b, final int len) {
		final StringBuffer s = new StringBuffer("");
		int i;

		if (b == null) {
			return "<null>";
		}

		for (i = 0; i < len; i++) {
			s.append(" " + XMLHelper.toHex(b[i]));
			if (i % 16 == 7) {
				s.append("\n");
			} else if (i % 4 == 3) {
				s.append(" ");
			}
		}
		if (i % 8 != 0) {
			s.append("\n");
		}

		return s.toString();
	}

	static public String toHexF(final int[] b, final int len) {
		final StringBuffer s = new StringBuffer("");
		int i;

		if (b == null) {
			return "<null>";
		}

		for (i = 0; i < len; i++) {
			s.append(" " + XMLHelper.toHex(b[i]));
			if (i % 4 == 3) {
				s.append("\n");
			}
		}
		if (i % 4 != 0) {
			s.append("\n");
		}
		return s.toString();
	}

	static public String toHex(final int[] b, final int len)
    {
    if (b==null) {
		return "";
	}
    final StringBuffer s = new StringBuffer("");
    int i;
    for (i=0; i<len; i++) {
		s.append(XMLHelper.toHex(b[i]));
	}
    return s.toString();
    }

	static public String toHex(final short[] b, final int len)
    {
    if (b==null) {
		return "";
	}
    final StringBuffer s = new StringBuffer("");
    int i;
    for (i=0; i<len; i++) {
		s.append(XMLHelper.toHex(b[i]));
	}
    return s.toString();
    }

	static public String toHex(final byte[] b, final int len)
    {
    if (b==null) {
		return "";
	}
    final StringBuffer s = new StringBuffer("");
    int i;
    for (i=0; i<len; i++) {
		s.append(XMLHelper.toHex(b[i]));
	}
    return s.toString();
    }

	static public String toHex(final byte b)
    {
    final Integer I = new Integer(((b) << 24) >>> 24);
    final int i = I.intValue();

    if ( i < (byte)16 ) {
		return "0"+Integer.toString(i, 16);
	} else {
		return     Integer.toString(i, 16);
	}
    }

	static public String toHex(final short i) {
		final byte b[] = new byte[2];
		b[0] = (byte) ((i & 0xff00) >>> 8);
		b[1] = (byte) ((i & 0x00ff));

		return XMLHelper.toHex(b[0]) + XMLHelper.toHex(b[1]);
	}

	static public String toHex(final int i) {
		final byte b[] = new byte[4];
		b[0] = (byte) ((i & 0xff000000) >>> 24);
		b[1] = (byte) ((i & 0x00ff0000) >>> 16);
		b[2] = (byte) ((i & 0x0000ff00) >>> 8);
		b[3] = (byte) ((i & 0x000000ff));

		return XMLHelper.toHex(b[0]) + XMLHelper.toHex(b[1]) + XMLHelper.toHex(b[2]) + XMLHelper.toHex(b[3]);
	}

	public static String stripNewLinesFromString
		(String strValue)
	{
		int nCR = strValue.indexOf(13);
	    while (-1 != nCR)
	    {
	    	final StringBuffer sbValue = new StringBuffer(strValue);
	    	sbValue.deleteCharAt(nCR);
	    	strValue = sbValue.toString();
	    	nCR = strValue.indexOf(13);
	    }
	    int nLF = strValue.indexOf(10);
	    while (-1 != nLF)
	    {
	    	final StringBuffer sbValue = new StringBuffer(strValue);
	    	sbValue.deleteCharAt(nLF);
	    	strValue = sbValue.toString();
	    	nLF = strValue.indexOf(10);
	    }
		return strValue;
	}
	
	public static String stripWhiteSpaceFromString
		(String strValue)
	{
		int nCR = strValue.indexOf(13);
	    while (-1 != nCR)
	    {
	    	final StringBuffer sbValue = new StringBuffer(strValue);
	    	sbValue.deleteCharAt(nCR);
	    	strValue = sbValue.toString();
	    	nCR = strValue.indexOf(13);
	    }
	    int nLF = strValue.indexOf(10);
	    while (-1 != nLF)
	    {
	    	final StringBuffer sbValue = new StringBuffer(strValue);
	    	sbValue.deleteCharAt(nLF);
	    	strValue = sbValue.toString();
	    	nLF = strValue.indexOf(10);
	    }
	    int nSP = strValue.indexOf(' ');
	    while (-1 != nSP)
	    {
	    	final StringBuffer sbValue = new StringBuffer(strValue);
	    	sbValue.deleteCharAt(nSP);
	    	strValue = sbValue.toString();
	    	nSP = strValue.indexOf(' ');
	    }
		return strValue;
	}

	/**
	* Converts an OMElement to an equivalent Element
	*
	* @param omElement an OMElement to be converted into a Element
	* @return the converted Element
	*/
	public static org.eclipse.higgins.sts.api.IElement toElement
		(final org.apache.axiom.om.OMElement omElement)
		throws Exception
	{
		final org.eclipse.higgins.sts.api.IElement element = new org.eclipse.higgins.sts.common.Element();
		element.set(omElement);
		return element;
	}

	/**
	* Converts an DOM Element to an equivalent Element
	*
	* @param domElement a DOM Element to be converted into a Element
	* @return the converted Element
	*/
	public static org.eclipse.higgins.sts.api.IElement toElement
		(final org.w3c.dom.Element domElement)
		throws Exception
	{
		final org.eclipse.higgins.sts.api.IElement element = new org.eclipse.higgins.sts.common.Element();
		element.set(domElement);
		return element;
	}

	/**
	* Converts an OMElement to an equivalent DOM Element
	*
	* @param omElement an OMElement to be converted into a DOM Element
	* @return the converted DOM Element
	*/
	public static org.w3c.dom.Element toDOM
		(final org.apache.axiom.om.OMElement omElement)
		throws Exception
	{
		if (null == omElement) {
			return null;
		}		
		final java.io.ByteArrayOutputStream outputStream = new java.io.ByteArrayOutputStream();
		try
		{
			omElement.serialize
				(outputStream);
		}
		catch (final Exception e)
		{
			org.eclipse.higgins.sts.utilities.ExceptionHelper.Log
				(XMLHelper.log,
				e);
			return null;
		}
		if (0 == outputStream.size())
		{
			return null;
		}
		final java.io.ByteArrayInputStream inputStream = new java.io.ByteArrayInputStream
			(outputStream.toByteArray());
		final javax.xml.parsers.DocumentBuilderFactory documentBuilderFactory = javax.xml.parsers.DocumentBuilderFactory.newInstance();
		documentBuilderFactory.setNamespaceAware
			(true);
		final javax.xml.parsers.DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
		final org.w3c.dom.Document domDocument = documentBuilder.parse(inputStream);
		return domDocument.getDocumentElement();
	}
	
	/**
	* Converts an OMElement to an equivalent String
	*
	* @param omElement an OMElement to be converted into a String
	* @return the converted a String
	*/
	public static String toString
		(final org.apache.axiom.om.OMElement omElement)
		throws Exception
	{
		if (null == omElement) {
			return null;
		}
		final java.io.ByteArrayOutputStream outputStream = new java.io.ByteArrayOutputStream();
		omElement.serialize
			(outputStream);
	    String strElement = null;
	    try
	    {
	    	strElement = outputStream.toString("UTF-8");
	    	strElement = XMLHelper.StripNamespaceDeclaration(strElement);
	    }
	    catch (final java.io.UnsupportedEncodingException uee)
	    {
    		org.eclipse.higgins.sts.utilities.ExceptionHelper.Log
				(XMLHelper.log,
				uee);
			throw uee;
	    }
	    return strElement;
	}
	
	public static String StripNamespaceDeclaration(final String strElement)
	{
		boolean bNamespaceDeclaration = strElement.startsWith
			("<?xml");
		if (!bNamespaceDeclaration) {
			return strElement;
		}
		final String strResult = strElement.substring(1);
		final int nBegin = strResult.indexOf
			("<");
		return strResult.substring
			(nBegin);
	}

	/**
	* Converts an DOM Element into an equivalent OMElement
	*
	* @param domElement an Element to be converted
	* @return the converted DOM Element
	*/
	public static org.apache.axiom.om.OMElement toOM
		(final org.w3c.dom.Element domElement)
		throws Exception
	{
		if (null == domElement) {
			return null;
		}
		final java.io.ByteArrayOutputStream outputStream = new java.io.ByteArrayOutputStream();
        final java.util.Properties prop = org.apache.xml.serializer.OutputPropertiesFactory.getDefaultMethodProperties("xml");
        final org.apache.xml.serializer.Serializer ser = org.apache.xml.serializer.SerializerFactory.getSerializer(prop);
        ser.setOutputFormat(prop);
        ser.setOutputStream(outputStream);
        final org.apache.xml.serializer.DOMSerializer domSerializer = ser.asDOMSerializer();
        domSerializer.serialize(domElement);
		final java.io.ByteArrayInputStream inputStream = new java.io.ByteArrayInputStream
			(outputStream.toByteArray());
        final javax.xml.stream.XMLInputFactory xif = javax.xml.stream.XMLInputFactory.newInstance();
        final javax.xml.stream.XMLStreamReader reader = xif.createXMLStreamReader
        	(inputStream);
        final org.apache.axiom.om.impl.builder.StAXOMBuilder builder = new org.apache.axiom.om.impl.builder.StAXOMBuilder
        	(reader);
        return builder.getDocumentElement();
	}
	
	public static String getTextContent(final org.w3c.dom.Text text)
	{
		return text.getNodeValue();
	}
	
	public static void setTextContent(final org.w3c.dom.Text text, final String value)
	{
		text.setNodeValue(value);
	}
	
	public static String getTextContent(final org.w3c.dom.Element element)
	{
		org.w3c.dom.NodeList nlChildren = element.getChildNodes();
		for (int i = 0; i < nlChildren.getLength(); ++i)
		{
			org.w3c.dom.Node nodeChild = nlChildren.item(i);
			if (org.w3c.dom.Node.TEXT_NODE == nodeChild.getNodeType())
			{
				org.w3c.dom.Text textChild = (org.w3c.dom.Text)nodeChild;
				return textChild.getData();
			}
		}
		return null;
	}
	
	public static void setTextContent(final org.w3c.dom.Element element, final String value)
	{
		org.w3c.dom.NodeList nlChildren = element.getChildNodes();
		for (int i = 0; i < nlChildren.getLength(); ++i)
		{
			org.w3c.dom.Node nodeChild = nlChildren.item(i);
			if (org.w3c.dom.Node.TEXT_NODE == nodeChild.getNodeType())
			{
				org.w3c.dom.Text textChild = (org.w3c.dom.Text)nodeChild;
				textChild.setData(value);
				return;
			}
		}
		org.w3c.dom.Text textNode = element.getOwnerDocument().createTextNode(value);
		element.appendChild(textNode);
	}
	
	public static void stripNewLinesFromElement
		(final org.w3c.dom.Element domElement)
	{
		if (null == domElement) {
			return;
		}
		domElement.normalize();
		final org.w3c.dom.NodeList nlChildren = domElement.getChildNodes();
		for (int i = 0; i < nlChildren.getLength(); ++i)
		{
			final org.w3c.dom.Node nodeChild = nlChildren.item(i);
			if (org.w3c.dom.Node.TEXT_NODE == nodeChild.getNodeType())
			{
				final org.w3c.dom.Text text = (org.w3c.dom.Text)nodeChild;
				String strContent = XMLHelper.getTextContent(text);
				strContent = XMLHelper.stripNewLinesFromString(strContent);
				XMLHelper.setTextContent(text, strContent);
			}
			if (org.w3c.dom.Node.ELEMENT_NODE == nodeChild.getNodeType())
			{
				XMLHelper.stripNewLinesFromElement
					((org.w3c.dom.Element)nodeChild);
			}
		}
	}
	
	public static void stripWhiteSpaceFromElement
		(final org.w3c.dom.Element domElement)
	{
		if (null == domElement) {
			return;
		}
		domElement.normalize();
		final org.w3c.dom.NodeList nlChildren = domElement.getChildNodes();
		for (int i = 0; i < nlChildren.getLength(); ++i)
		{
			final org.w3c.dom.Node nodeChild = nlChildren.item(i);
			if (org.w3c.dom.Node.TEXT_NODE == nodeChild.getNodeType())
			{
				final org.w3c.dom.Text text = (org.w3c.dom.Text)nodeChild;
				String strContent = XMLHelper.getTextContent(text);
				strContent = XMLHelper.stripWhiteSpaceFromString(strContent);
				XMLHelper.setTextContent(text, strContent);
			}
			if (org.w3c.dom.Node.ELEMENT_NODE == nodeChild.getNodeType())
			{
				XMLHelper.stripWhiteSpaceFromElement
					((org.w3c.dom.Element)nodeChild);
			}
		}
	}

	public static String toString
		(final org.w3c.dom.Element domElement)
		throws java.io.IOException
	{
		if (null == domElement) {
			return null;
		}
		final java.io.ByteArrayOutputStream outputStream = new java.io.ByteArrayOutputStream();
        final java.util.Properties prop = org.apache.xml.serializer.OutputPropertiesFactory.getDefaultMethodProperties
        	("xml");
        final org.apache.xml.serializer.Serializer ser = org.apache.xml.serializer.SerializerFactory.getSerializer
        	(prop); 
        ser.setOutputStream
        	(outputStream);
        final org.apache.xml.serializer.DOMSerializer domSerializer = ser.asDOMSerializer();
        domSerializer.serialize
        	(domElement);
	    String strElement = null;
	    try
	    {
	    	strElement = outputStream.toString
	    		("UTF-8");
	    	strElement = XMLHelper.StripNamespaceDeclaration
	    		(strElement);
	    }
	    catch (final java.io.UnsupportedEncodingException uee)
	    {
    		org.eclipse.higgins.sts.utilities.ExceptionHelper.Log
				(XMLHelper.log,
				uee);
			throw uee;
	    }
	    return strElement;
	}
	
	public static void logElement
		(final org.w3c.dom.Element domElement)
		throws java.io.IOException
	{
		final String strElement = XMLHelper.toString
			(domElement);
		XMLHelper.log.trace(strElement);
	}
	
	public static org.w3c.dom.Element toDOM
		(final String strElement)
		throws java.io.IOException, Exception
	{
		if (null == strElement) {
			return null;
		}
	    final java.io.ByteArrayInputStream inputStream = new java.io.ByteArrayInputStream
			(strElement.getBytes("UTF-8"));
	    javax.xml.parsers.DocumentBuilder documentBuilder = null;
	    final javax.xml.parsers.DocumentBuilderFactory documentBuilderFactory = javax.xml.parsers.DocumentBuilderFactory.newInstance();
	    documentBuilderFactory.setNamespaceAware(true);
	    try
	    {
	    	documentBuilder = documentBuilderFactory.newDocumentBuilder();
	    }
	    catch (final Exception e)
	    {
			org.eclipse.higgins.sts.utilities.ExceptionHelper.Log
				(XMLHelper.log,
				e);
			throw e;
	    }
	    org.w3c.dom.Document docElement = null;
	    try
	    {
	    	docElement = documentBuilder.parse(inputStream);
	    }
	    catch (final Exception e)
	    {	
			org.eclipse.higgins.sts.utilities.ExceptionHelper.Log
				(XMLHelper.log,
				e);
			throw e;
	    }
	    return docElement.getDocumentElement();
	}

	public static org.w3c.dom.Element reparseElement
		(final org.w3c.dom.Element domElement)
		throws java.io.IOException, Exception
	{
		if (null == domElement) {
			return null;
		}
		final org.w3c.dom.Document docIn = domElement.getOwnerDocument();
		final String strElement = XMLHelper.toString
			(domElement);
	    final org.w3c.dom.Element domParsed = XMLHelper.toDOM(strElement);
	    final org.w3c.dom.Element domResult = (org.w3c.dom.Element)docIn.importNode(domParsed, true);
	    return domResult;
	}
	
	public static org.w3c.dom.Element domFromStream
		(final java.io.InputStream inputStream)
		throws java.io.FileNotFoundException,
			Exception
	{
	    javax.xml.parsers.DocumentBuilder documentBuilder = null;
	    final javax.xml.parsers.DocumentBuilderFactory documentBuilderFactory = javax.xml.parsers.DocumentBuilderFactory.newInstance();
	    documentBuilderFactory.setNamespaceAware(true);
	    try
	    {
	    	documentBuilder = documentBuilderFactory.newDocumentBuilder();
	    }
	    catch (final Exception e)
	    {
			org.eclipse.higgins.sts.utilities.ExceptionHelper.Log
				(XMLHelper.log,
				e);
			throw e;
	    }
	    org.w3c.dom.Document docElement = null;
	    try
	    {
	    	docElement = documentBuilder.parse
	    		(inputStream);
	    }
	    catch (final Exception e)
	    {	
			org.eclipse.higgins.sts.utilities.ExceptionHelper.Log
				(XMLHelper.log,
				e);
			throw e;
	    }
	    return docElement.getDocumentElement();
	}
	
	public static org.w3c.dom.Element domFromFile
		(final String strFileName)
		throws java.io.FileNotFoundException,
			Exception
	{
	    java.io.FileInputStream inputStream = null;
	    try
	    {
	    	inputStream = new java.io.FileInputStream
	    		(strFileName);
	    }
	    catch (final java.io.FileNotFoundException fnfe)
	    {
    		org.eclipse.higgins.sts.utilities.ExceptionHelper.Log
				(XMLHelper.log,
				fnfe);
			throw fnfe;
	    }
	    return XMLHelper.domFromStream(inputStream);
	}
	
	public static org.apache.axiom.om.OMElement omFromStream
		(final java.io.InputStream inputStream)
		throws java.io.FileNotFoundException,
			Exception
	{
        final javax.xml.stream.XMLInputFactory xif = javax.xml.stream.XMLInputFactory.newInstance();
        final javax.xml.stream.XMLStreamReader reader = xif.createXMLStreamReader
        	(inputStream);
        final org.apache.axiom.om.impl.builder.StAXOMBuilder builder = new org.apache.axiom.om.impl.builder.StAXOMBuilder
        	(reader);
        return builder.getDocumentElement();
	}
	
	public static org.apache.axiom.om.OMElement omFromFile
		(final String strFileName)
		throws java.io.FileNotFoundException,
			Exception
	{
	    java.io.FileInputStream inputStream = null;
	    try
	    {
	    	inputStream = new java.io.FileInputStream
	    		(strFileName);
	    }
	    catch (final java.io.FileNotFoundException fnfe)
	    {
			org.eclipse.higgins.sts.utilities.ExceptionHelper.Log
				(XMLHelper.log,
				fnfe);
			throw fnfe;
	    }
	    return XMLHelper.omFromStream(inputStream);
	}
	
	public static org.apache.axiom.om.OMElement toOM
		(final String strElement)
		throws Exception
	{
	    final java.io.ByteArrayInputStream inputStream = new java.io.ByteArrayInputStream
			(strElement.getBytes("UTF-8"));
	    final javax.xml.stream.XMLInputFactory xif = javax.xml.stream.XMLInputFactory.newInstance();
	    final javax.xml.stream.XMLStreamReader reader = xif.createXMLStreamReader
	    	(inputStream);
	    final org.apache.axiom.om.impl.builder.StAXOMBuilder builder = new org.apache.axiom.om.impl.builder.StAXOMBuilder
	    	(reader);
	    return builder.getDocumentElement();
	}
}
