/*******************************************************************************
 * Copyright (c) 2006-2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Michael McIntosh (IBM Corporation) - initial API and implementation
 *******************************************************************************/ 

package org.eclipse.higgins.sts.common;

import java.net.URI;

import org.eclipse.higgins.sts.api.IBinarySecurityToken;

/**
 * @author mikemci
 *
 */
public class BinarySecurityToken implements IBinarySecurityToken
{
	URI uriEncodingType = null;
	
	URI uriValueType = null;
	
//	URI uriTokenType = null;
	
	String strValue = null;
	
	private org.apache.axiom.om.OMElement omBinarySecurityToken = null;

	private java.net.URI uriWSSExtension = java.net.URI.create
	("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");

	private java.net.URI uriWSSUtility = java.net.URI.create
	("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
	
	private javax.xml.namespace.QName qnameValueType = new javax.xml.namespace.QName
	("", "ValueType");

	private javax.xml.namespace.QName qnameEncodingType = new javax.xml.namespace.QName
	("", "EncodingType");

	private final org.apache.axiom.om.OMFactory omFactory = org.apache.axiom.om.OMAbstractFactory.getOMFactory();

	private final org.apache.axiom.om.OMNamespace omWSSExtensionNamespace = omFactory.createOMNamespace
	(uriWSSExtension.toString(),
	"wsse");

	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.api.IBinarySecurityToken#getEncodingType()
	 */
	public URI getEncodingType()
	{
		return uriEncodingType;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.api.IBinarySecurityToken#getValueType()
	 */
	public URI getValueType()
	{
		return uriValueType;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.api.IBinarySecurityToken#setEncodingType(java.net.URI)
	 */
	public void setEncodingType(URI uriEncodingType)
	{
		this.uriEncodingType = uriEncodingType;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.api.IBinarySecurityToken#setValueType(java.net.URI)
	 */
	public void setValueType(URI uriValueType)
	{
		this.uriValueType = uriValueType;
	}

//	/* (non-Javadoc)
//	 * @see org.eclipse.higgins.sts.api.ISecurityToken#getTokenType()
//	 */
//	public URI getTokenType()
//	{
//		return this.uriTokenType;
//	}
	
	public void setEncodedValue(String strValue)
	{
		this.strValue = strValue;
	}
	
	public String getEncodedValue()
	{
		return this.strValue;
	}
	
	public org.eclipse.higgins.sts.api.IElement toElement() throws Exception
	{
		createBinarySecurityToken();
		if (null != uriEncodingType)
			omBinarySecurityToken.addAttribute("EncodingType", uriEncodingType.toString(), null);
		if (null != uriValueType)
			omBinarySecurityToken.addAttribute("ValueType", uriValueType.toString(), null);
		omBinarySecurityToken.setText(strValue);
		org.eclipse.higgins.sts.api.IElement elemToken = new org.eclipse.higgins.sts.common.Element();	
		elemToken.set(omBinarySecurityToken);
		return elemToken;
	}
	
	public void fromElement(org.eclipse.higgins.sts.api.IElement element) throws Exception
	{
		omBinarySecurityToken = (org.apache.axiom.om.OMElement)element.getAs(org.apache.axiom.om.OMElement.class);
		if (null != omBinarySecurityToken) {
			this.strValue = omBinarySecurityToken.getText();
			if (null != omBinarySecurityToken.getAttribute(this.qnameValueType))
				this.setValueType(new URI(omBinarySecurityToken.getAttributeValue(this.qnameValueType)));
			if (null != omBinarySecurityToken.getAttribute(this.qnameEncodingType))
				this.setEncodingType(new URI(omBinarySecurityToken.getAttributeValue(this.qnameEncodingType)));
		}
	}
	
	private void createBinarySecurityToken()
	{
		if (null == omBinarySecurityToken)
			omBinarySecurityToken = omFactory.createOMElement("BinarySecurityToken", omWSSExtensionNamespace);
	}


/*
	public org.eclipse.higgins.sts.api.IElement getAsElement() throws Exception
	{
		String strToken = "<wsse:BinarySecurityToken "
			+ "xmlns:wsse=\"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd\" "
			+ "ValueType=\"" + this.uriValueType.toString() + "\" "
			+ "EncodingType=\"" + this.uriEncodingType.toString() + "\">"
			+ this.strValue
			+ "</wsse:BinarySecurityToken>";
		org.eclipse.higgins.sts.api.IElement elemToken = new org.eclipse.higgins.sts.common.Element();
		elemToken.set(strToken);
		return elemToken;
	}
*/
}
