/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Michael McIntosh (IBM Corporation) - initial API and implementation
 *******************************************************************************/ 

package org.eclipse.higgins.sts.common;

import org.eclipse.higgins.sts.api.IFault;

/**
 * @author mikemci at us dot ibm dot com
 */
public class Fault
	implements IFault
{
	private java.net.URI uriCodeNamespace = null;
	
	private String strCodePrefix = null;
	
	private String strCodeLocalPart = null;
	
	private String strReason = null;
	
	private String strDetail = null;
	
	public Fault
		(final java.net.URI uriCodeNamespace,
		final String strCodePrefix,
		final String strCodeLocalPart,
		final String strReason,
		final String strDetail)
	{
		this.uriCodeNamespace = uriCodeNamespace;
		this.strCodePrefix = strCodePrefix;
		this.strCodeLocalPart = strCodeLocalPart;
		this.strReason = strReason;
		this.strDetail = strDetail;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IFault#getCodeNamespace()
	 */
	public java.net.URI getCodeNamespace()
	{
		return this.uriCodeNamespace;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IFault#getCodePrefix()
	 */
	public String getCodePrefix()
	{
		return this.strCodePrefix;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IFault#getCodeLocalPart()
	 */
	public String getCodeLocalPart()
	{
		return this.strCodeLocalPart;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IFault#getReason()
	 */
	public String getReason()
	{
		return this.strReason;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IFault#getDetail()
	 */
	public String getDetail()
	{
		return this.strDetail;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IFault#setCodeNamespace(java.net.URI)
	 */
	public void setCodeNamespace
		(final java.net.URI uriCodeNamespace)
	{
		this.uriCodeNamespace = uriCodeNamespace;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IFault#setCodePrefix(java.lang.String)
	 */
	public void setCodePrefix
		(final String strCodePrefix)
	{
		this.strCodePrefix = strCodePrefix;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IFault#setCodeLocalPart(java.lang.String)
	 */
	public void setCodeLocalPart
		(final String strCodeLocalPart)
	{
		this.strCodeLocalPart = strCodeLocalPart;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IFault#setReason(java.lang.String)
	 */
	public void setReason
		(final String strReason)
	{
		this.strReason = strReason;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IFault#setDetail(java.lang.String)
	 */
	public void setDetail
		(final String strDetail)
	{
		this.strDetail = strDetail;
	}
}
