/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Michael McIntosh (IBM Corporation) - initial API and implementation
 *******************************************************************************/ 

package org.eclipse.higgins.sts.common;

import java.util.Date;

import org.eclipse.higgins.sts.api.IElement;
import org.eclipse.higgins.sts.api.ITimestamp;

/**
 * @author mikemci
 *
 */
public class Timestamp implements ITimestamp
{
	private org.apache.axiom.om.OMElement omTimestamp = null;

	private org.apache.axiom.om.OMElement omCreated = null;
	
	private org.apache.axiom.om.OMElement omExpires = null;

	private java.net.URI uriWSSUtility = java.net.URI.create
		("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");

	private javax.xml.namespace.QName qnameCreated = new javax.xml.namespace.QName
		(uriWSSUtility.toString(), "Created");
	
	private javax.xml.namespace.QName qnameExpires = new javax.xml.namespace.QName
		(uriWSSUtility.toString(), "Expires");

	private final org.apache.axiom.om.OMFactory omFactory = org.apache.axiom.om.OMAbstractFactory.getOMFactory();
	
	private final org.apache.axiom.om.OMNamespace omWSSUtilityNamespace = omFactory.createOMNamespace
		(uriWSSUtility.toString(),
		"wsu");

	private void createTimestamp()
	{
		if (null == omTimestamp)
			omTimestamp = omFactory.createOMElement("Timestamp", omWSSUtilityNamespace);
	}
	
	private void createCreated()
	{
		createTimestamp();
		if (null == omCreated)
			omCreated = omFactory.createOMElement("Created", omWSSUtilityNamespace, omTimestamp);
	}

	private void createExpires()
	{
		createTimestamp();
		if (null == omExpires)
			omExpires = omFactory.createOMElement("Expires", omWSSUtilityNamespace, omTimestamp);
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.api.ITimestamp#getCreated()
	 */
	public Date getCreated()
	{
		Date dtCreated = null;
		if (null != omCreated)
		{
			String strCreated = omCreated.getText();
			dtCreated = org.eclipse.higgins.sts.utilities.DateHelper.getDateFromIso8601(strCreated);
		}
		return dtCreated;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.api.ITimestamp#getExpires()
	 */
	public Date getExpires()
	{
		Date dtExpires = null;
		if (null != omExpires)
		{
			String strExpires = omExpires.getText();
			dtExpires = org.eclipse.higgins.sts.utilities.DateHelper.getDateFromIso8601(strExpires);
		}
		return dtExpires;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.api.ITimestamp#setCreated(java.util.Date)
	 */
	public void setCreated(Date dtCreated)
	{
		createCreated();
		omCreated.setText(org.eclipse.higgins.sts.utilities.DateHelper.getIso8601Date(dtCreated));
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.api.ITimestamp#setExpires(java.util.Date)
	 */
	public void setExpires(Date dtExpires)
	{
		createExpires();
		omExpires.setText(org.eclipse.higgins.sts.utilities.DateHelper.getIso8601Date(dtExpires));
	}

	public void fromElement(IElement element) throws Exception
	{
		omTimestamp = (org.apache.axiom.om.OMElement)element.getAs(org.apache.axiom.om.OMElement.class);
		if (null != omTimestamp)
		{
			omCreated = omTimestamp.getFirstChildWithName(qnameCreated);
			omExpires = omTimestamp.getFirstChildWithName(qnameExpires);
		}
	}

	public IElement toElement() throws Exception
	{
		org.eclipse.higgins.sts.api.IElement elemTimestamp = new org.eclipse.higgins.sts.common.Element();
		elemTimestamp.set(omTimestamp);
		return elemTimestamp;
	}
}
