/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Michael McIntosh (IBM Corporation) - initial API and implementation
 *******************************************************************************/ 

package org.eclipse.higgins.sts.utilities;

/**
 * @author mikemci
 *
 */
public class CertificateHelper
{
	static private final org.eclipse.higgins.sts.utilities.LogHelper log = new org.eclipse.higgins.sts.utilities.LogHelper
		(CertificateHelper.class.getName());

	static private java.security.cert.CertificateFactory certificateFactory = null;
	
	static public java.security.cert.X509Certificate fromString(String cert)
	{
		try
		{
			if (null == certificateFactory)
				certificateFactory = java.security.cert.CertificateFactory.getInstance
					("X.509");
			final String strCertificate = "-----BEGIN CERTIFICATE-----\n"
				+ cert
				+ "\n-----END CERTIFICATE-----\n";
			final java.io.ByteArrayInputStream streamCertificate = new java.io.ByteArrayInputStream
				(strCertificate.getBytes("UTF-8"));
			return (java.security.cert.X509Certificate)certificateFactory.generateCertificate
				(streamCertificate);
		}
		catch (Exception ex)
		{
			ExceptionHelper.Log(log, ex);
		}
		return null;
	}
}
