/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Suresh Chari (IBM Corporation) - initial API and implementation
 *******************************************************************************/ 

package org.eclipse.higgins.sts.utilities;

/**
 * @author Suresh Chari
 *
 * X9.31 exception for invalid random parameters in code
 */
public class InvalidRandomParameterException extends Exception {
	
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private int statusCode;
	
	public static final int INVALID_INPUT_DATA = 100;
	
	public static final int INSUFFICIENT_PRIME_DISTANCE = 101;
	
	public static final int INVALID_PRIVATE_EXPONENT = 102; 
	
	
	public InvalidRandomParameterException( int code ){
		super();
		statusCode = code;
	}
	/**
	 * @return Returns the statusCode.
	 */
	public int getStatusCode() {
		return statusCode;
	}
	

}
