/*******************************************************************************
 * Copyright (c) 2006-2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Michael McIntosh (IBM Corporation) - initial API and implementation
 *******************************************************************************/ 

package org.eclipse.higgins.sts.common;

import java.net.URI;

import org.eclipse.higgins.sts.api.IDisplayClaim;

/**
 * @author mikemci
 *
 */
public class DisplayClaim implements IDisplayClaim {
	
	protected URI type = null;
	
	protected String displayTag = "";
	
	protected String displayValue = "";

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.api.IDisplayClaim#getDisplayTag()
	 */
	public String getDisplayTag() {
		return displayTag;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.api.IDisplayClaim#getDisplayValue()
	 */
	public String getDisplayValue() {
		return displayValue;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.api.IDisplayClaim#getType()
	 */
	public URI getType() {
		return type;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.api.IDisplayClaim#setDisplayTag(java.lang.String)
	 */
	public void setDisplayTag(String strDisplayTag) {
		displayTag = strDisplayTag;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.api.IDisplayClaim#setDisplayValue(java.lang.String)
	 */
	public void setDisplayValue(String strDisplayValue) {
		displayValue = strDisplayValue;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.api.IDisplayClaim#setType(java.net.URI)
	 */
	public void setType(URI uriType) {
		type = uriType;
	}

}
