/*******************************************************************************
 * Copyright (c) 2006-2007 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Michael McIntosh (IBM Corporation) - initial design and implementation
 *******************************************************************************/ 
package org.eclipse.higgins.sts.common;

import org.eclipse.higgins.sts.api.ISAML11Token;

/**
 * @author mikemci
 *
 */
public class SAML11Token extends SAMLToken implements ISAML11Token
{
	private javax.xml.namespace.QName qnameAssertionID = new javax.xml.namespace.QName
		("AssertionID");

	private javax.xml.namespace.QName qnameMajorVersion = new javax.xml.namespace.QName
		("MajorVersion");

	private javax.xml.namespace.QName qnameMinorVersion = new javax.xml.namespace.QName
		("MinorVersion");
	
	private java.net.URI uriSAMLAssertion = java.net.URI.create
		("urn:oasis:names:tc:SAML:1.0:assertion");
	
	private final org.apache.axiom.om.OMFactory omFactory = org.apache.axiom.om.OMAbstractFactory.getOMFactory();
	
	private final org.apache.axiom.om.OMNamespace omSAMLNamespace = omFactory.createOMNamespace
		(uriSAMLAssertion.toString(),
		"saml");
	
	protected void createAssertion()
	{
		if (null == omAssertion)
			omAssertion = omFactory.createOMElement("Assertion", omSAMLNamespace);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.api.ISAML10Token#getAssertionID()
	 */
	public String getAssertionID()
	{
		String strAssertionID = null;
		if (null != omAssertion)
			strAssertionID = omAssertion.getAttributeValue(qnameAssertionID);
		return strAssertionID;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.api.ISAML10Token#getMajorVersion()
	 */
	public String getMajorVersion()
	{
		String strMajorVersion = null;
		if (null != omAssertion)
			strMajorVersion = omAssertion.getAttributeValue(qnameMajorVersion);
		return strMajorVersion;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.api.ISAML10Token#getMinorVersion()
	 */
	public String getMinorVersion()
	{
		String strMinorVersion = null;
		if (null != omAssertion)
			strMinorVersion = omAssertion.getAttributeValue(qnameMinorVersion);
		return strMinorVersion;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.api.ISAML10Token#setAssertionID(java.lang.String)
	 */
	public void setAssertionID(String strAssertionID)
	{
		createAssertion();
		org.apache.axiom.om.OMAttribute omAssertionID = omAssertion.getAttribute(qnameAssertionID);
		if (null == omAssertionID)
			omAssertionID = omAssertion.addAttribute("AssertionID", strAssertionID, null);
		else
			omAssertionID.setAttributeValue(strAssertionID);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.api.ISAML10Token#setMajorVersion(java.lang.String)
	 */
	public void setMajorVersion(String strMajorVersion)
	{
		createAssertion();
		org.apache.axiom.om.OMAttribute omMajorVersion = omAssertion.getAttribute(qnameMajorVersion);
		if (null == omMajorVersion)
			omMajorVersion = omAssertion.addAttribute("MajorVersion", strMajorVersion, null);
		else
			omMajorVersion.setAttributeValue(strMajorVersion);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.api.ISAML10Token#setMinorVersion(java.lang.String)
	 */
	public void setMinorVersion(String strMinorVersion)
	{
		createAssertion();
		org.apache.axiom.om.OMAttribute omMinorVersion = omAssertion.getAttribute(qnameMinorVersion);
		if (null == omMinorVersion)
			omMinorVersion = omAssertion.addAttribute("MinorVersion", strMinorVersion, null);
		else
			omMinorVersion.setAttributeValue(strMinorVersion);
	}
}
