/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Michael McIntosh (IBM Corporation) - initial API and implementation
 *******************************************************************************/ 

package org.eclipse.higgins.sts.common;

import java.security.KeyPair;

/**
 * Encapsulates values associated with the STS Request (RequestSecurityToken[Collection])
 * 
 * @author mikemci at us dot ibm dot com
 */
public class STSRequest
	extends org.eclipse.higgins.sts.common.Message
	implements org.eclipse.higgins.sts.api.ISTSRequest
{
	/**
	 * WS-Trust RequestSecurityTokenCollection
	 */
	private final java.util.List requestSecurityTokenCollection = new java.util.ArrayList();
	
	private String strPassword = null;
	
	private String strUsername = null;
	
	private java.security.KeyPair kpSelfSigningKeyPair = null;
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.ISTSRequest#getRequestSecurityTokenCollection()
	 */
	public java.util.List getRequestSecurityTokenCollection()
	{
		return this.requestSecurityTokenCollection;
	}

	public String getTransportPassword() {
		// TODO Auto-generated method stub
		return strPassword;
	}

	public String getTransportUsername() {
		// TODO Auto-generated method stub
		return strUsername;
	}

	public void setTransportPassword(String strPassword) {
		// TODO Auto-generated method stub
		this.strPassword = strPassword;
	}

	public void setTransportUsername(String strUsername) {
		// TODO Auto-generated method stub
		this.strUsername = strUsername;
		
	}

	public KeyPair getSelfSigningKeyPair() {
		return this.kpSelfSigningKeyPair;
	}

	public void setSelfSigningKeyPair(KeyPair kpSelf) {
		this.kpSelfSigningKeyPair = kpSelf;
		
	}	
}