/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Michael McIntosh (IBM Corporation) - initial API and implementation
 *******************************************************************************/ 

package org.eclipse.higgins.sts.common;

import org.eclipse.higgins.sts.api.IDisplayToken;
import org.eclipse.higgins.sts.api.IElement;
import org.eclipse.higgins.sts.api.IRequestSecurityTokenResponse;

/**
 * Framework independent encapsulation of the WS-Trust RequestSecurityToken contents
 * 
 * @author mikemci at us dot ibm dot com
 */
public class RequestSecurityTokenResponse implements IRequestSecurityTokenResponse
{
	private IElement elemClientPseudonym = null;

	/**
	 * @return the elemClientPseudonym
	 */
	public IElement getClientPseudonym() {
		return this.elemClientPseudonym;
	}

	/**
	 * @param elemClientPseudonym the elemClientPseudonym to set
	 */
	public void setClientPseudonym(final IElement elemClientPseudonym) {
		this.elemClientPseudonym = elemClientPseudonym;
	}

	private java.net.URI uriComputedKey = null;

	/**
	 * The value of the Context attribute associated with the RequestSecurityTokenResponse element
	 */
	private String strContext = null;

	/**
	 * The RequestedTokenCancelled element associated with the RequestSecurityTokenResponse element
	 */
	private IElement elemRequestedTokenCancelled = null;

	/**
	 * The RequestedDisplayToken associated with the RequestSecurityTokenResponse element
	 */
	private org.eclipse.higgins.sts.api.IDisplayToken dtRequestedDisplayToken = null;

	/**
	 * The TokenType URI associated with the RequestSecurityTokenResponse element
	 */
	private java.net.URI uriTokenType = null;
	
	/**
	 * The RequestType URI associated with the RequestSecurityTokenResponse element
	 */
	private java.net.URI uriRequestType = null;
	
	/**
	 * The RequestedSecurityToken element associated with the RequestSecurityTokenResponse element
	 */
	private IElement elemRequestedSecurityToken = null;
	
	/**
	 * The AppliesTo EPR associated with the RequestSecurityTokenResponse element
	 */
	private org.eclipse.higgins.sts.api.IEndpointReference eprAppliesTo = null;
	
	/**
	 * The RequestedAttachedReference element associated with the RequestSecurityTokenResponse element
	 */
	private IElement elemRequestedAttachedReference = null;
	
	/**
	 * The RequestedUnattachedReference element associated with the RequestSecurityTokenResponse element
	 */
	private IElement elemRequestedUnattachedReference = null;
	
	/**
	 * The RequestedProofToken element associated with the RequestSecurityTokenResponse element
	 */
	private IElement elemRequestedProofToken = null;
	
	/**
	 * The Entropy element associated with the RequestSecurityTokenResponse element
	 */
	private IElement elemEntropy = null;
	
	/**
	 * The Lifetime associated with the RequestSecurityTokenResponse element
	 */
	private org.eclipse.higgins.sts.api.ILifetime ltLifetime = null;
	
	/**
	 * The Status element associated with the RequestSecurityTokenResponse element
	 */
	private IElement elemStatus = null;
	
	/**
	 * The AllowPostdating element associated with the RequestSecurityTokenResponse element
	 */
	private IElement elemAllowPostdating = null;
	
	/**
	 * The Renewing element associated with the RequestSecurityTokenResponse element
	 */
	private IElement elemRenewing = null;
	
	/**
	 * The OnBehalfOf element associated with the RequestSecurityTokenResponse element
	 */
	private IElement elemOnBehalfOf = null;
	
	/**
	 * The Issuer EPR associated with the RequestSecurityTokenResponse element
	 */
	private org.eclipse.higgins.sts.api.IEndpointReference eprIssuer = null;
	
	/**
	 * The AuthenticationType URI associated with the RequestSecurityTokenResponse element
	 */
	private java.net.URI uriAuthenticationType = null;
	
	/**
	 * The Authenticator element associated with the RequestSecurityTokenResponse element
	 */
	private IElement elemAuthenticator = null;
	
	/**
	 * The KeyType URI associated with the RequestSecurityTokenResponse element
	 */
	private java.net.URI uriKeyType = null;
	
	/**
	 * The KeySize associated with the RequestSecurityTokenResponse element
	 */
	private java.lang.Integer intKeySize = null;
	
	/**
	 * The SignatureAlgorithm URI associated with the RequestSecurityTokenResponse element
	 */
	private java.net.URI uriSignatureAlgorithm = null;
	
	/**
	 * The Encryption element associated with the RequestSecurityTokenResponse element
	 */
	private IElement elemEncryption = null;
	
	/**
	 * The EncryptionAlgorithm element associated with the RequestSecurityTokenResponse element
	 */
	private java.net.URI uriEncryptionAlgorithm = null;
	
	/**
	 * The CanonicalizationAlgorithm element associated with the RequestSecurityTokenResponse element
	 */
	private java.net.URI uriCanonicalizationAlgorithm = null;

	/**
	 * The ProofEncryption element associated with the RequestSecurityTokenResponse element
	 */
	private IElement elemProofEncryption = null;
	
	/**
	 * The UseKey element associated with the RequestSecurityTokenResponse element
	 */
	private IElement elemUseKey = null;
	
	/**
	 * The SignWith URI associated with the RequestSecurityTokenResponse element
	 */
	private java.net.URI uriSignWith = null;
	
	/**
	 * The EncryptWith element associated with the RequestSecurityTokenResponse element
	 */
	private java.net.URI uriEncryptWith = null;
	
	/**
	 * The DelegateTo element associated with the RequestSecurityTokenResponse element
	 */
	private IElement elemDelegateTo = null;
	
	/**
	 * The Forwardable element associated with the RequestSecurityTokenResponse element
	 */
	private java.lang.Boolean boolForwardable = null;
	
	/**
	 * The Delegatable element associated with the RequestSecurityTokenResponse element
	 */
	private java.lang.Boolean boolDelegatable = null;
	
	/**
	 * The Policy element associated with the RequestSecurityTokenResponse element
	 */
	private IElement elemPolicy = null;
	
	/**
	 * The PolicyReference element associated with the RequestSecurityTokenResponse element
	 */
	private IElement elemPolicyReference = null;

	/**
	 * Any other miscellaneous elements associated with the RequestSecurityTokenResponse element
	 */
	private final java.util.List listAnyOtherElements = new java.util.ArrayList();
	
	/**
	 * This object can contain any non-XML data to be associated with the RequestSecurityTokenResponse
	 */
	private java.lang.Object objectData = null;

	public java.net.URI getComputedKey()
	{
		return this.uriComputedKey;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityTokenResponse#getContext()
	 */
	public String getContext()
	{
		return this.strContext;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityTokenResponse#getRequestedDisplayToken()
	 */
	public IDisplayToken getRequestedDisplayToken()
	{
		return this.dtRequestedDisplayToken;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityTokenResponse#getRequestedTokenCancelled()
	 */
	public IElement getRequestedTokenCancelled()
	{
		return this.elemRequestedTokenCancelled;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityTokenResponse#getTokenType()
	 */
	public java.net.URI getTokenType()
	{
		return this.uriTokenType;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityTokenResponse#getRequestType()
	 */
	public java.net.URI getRequestType()
	{
		return this.uriRequestType;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityTokenResponse#getRequestedSecurityToken()
	 */
	public IElement getRequestedSecurityToken()
	{
		return this.elemRequestedSecurityToken;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityTokenResponse#getAppliesTo()
	 */
	public org.eclipse.higgins.sts.api.IEndpointReference getAppliesTo()
	{
		return this.eprAppliesTo;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityTokenResponse#getRequestedAttachedReference()
	 */	
	public IElement getRequestedAttachedReference()
	{
		return this.elemRequestedAttachedReference;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityTokenResponse#getRequestedUnattachedReference()
	 */	
	public IElement getRequestedUnattachedReference()
	{
		return this.elemRequestedUnattachedReference;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityTokenResponse#getRequestedProofToken()
	 */	
	public IElement getRequestedProofToken()
	{
		return this.elemRequestedProofToken;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityTokenResponse#getEntropy()
	 */	
	public IElement getEntropy()
	{
		return this.elemEntropy;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityTokenResponse#getLifetime()
	 */	
	public org.eclipse.higgins.sts.api.ILifetime getLifetime()
	{
		return this.ltLifetime;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityTokenResponse#getStatus()
	 */	
	public IElement getStatus()
	{
		return this.elemStatus;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityTokenResponse#getAllowPostdating()
	 */	
	public IElement getAllowPostdating()
	{
		return this.elemAllowPostdating;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityTokenResponse#getRenewing()
	 */	
	public IElement getRenewing()
	{
		return this.elemRenewing;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityTokenResponse#getOnBehalfOf()
	 */	
	public IElement getOnBehalfOf()
	{
		return this.elemOnBehalfOf;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityTokenResponse#getIssuer()
	 */	
	public org.eclipse.higgins.sts.api.IEndpointReference getIssuer()
	{
		return this.eprIssuer;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityTokenResponse#getAuthenticationType()
	 */	
	public java.net.URI getAuthenticationType()
	{
		return this.uriAuthenticationType;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityTokenResponse#getAuthenticator()
	 */	
	public IElement getAuthenticator()
	{
		return this.elemAuthenticator;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityTokenResponse#getKeyType()
	 */	
	public java.net.URI getKeyType()
	{
		return this.uriKeyType;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityTokenResponse#getKeySize()
	 */	
	public java.lang.Integer getKeySize()
	{
		return this.intKeySize;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityTokenResponse#getSignatureAlgorithm()
	 */	
	public java.net.URI getSignatureAlgorithm()
	{
		return this.uriSignatureAlgorithm;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityTokenResponse#getEncryption()
	 */	
	public IElement getEncryption()
	{
		return this.elemEncryption;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityTokenResponse#getEncryptionAlgorithm()
	 */	
	public java.net.URI getEncryptionAlgorithm()
	{
		return this.uriEncryptionAlgorithm;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityTokenResponse#getCanonicalizationAlgorithm()
	 */	
	public java.net.URI getCanonicalizationAlgorithm()
	{
		return this.uriCanonicalizationAlgorithm;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityTokenResponse#getProofEncryption()
	 */	
	public IElement getProofEncryption()
	{
		return this.elemProofEncryption;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityTokenResponse#getUseKey()
	 */	
	public IElement getUseKey()
	{
		return this.elemUseKey;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityTokenResponse#getSignWith()
	 */	
	public java.net.URI getSignWith()
	{
		return this.uriSignWith;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityTokenResponse#getEncryptWith()
	 */	
	public java.net.URI getEncryptWith()
	{
		return this.uriEncryptWith;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityTokenResponse#getDelegateTo()
	 */	
	public IElement getDelegateTo()
	{
		return this.elemDelegateTo;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityTokenResponse#getForwardable()
	 */	
	public java.lang.Boolean getForwardable()
	{
		return this.boolForwardable;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityTokenResponse#getDelegatable()
	 */	
	public java.lang.Boolean getDelegatable()
	{
		return this.boolDelegatable;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityTokenResponse#getPolicy()
	 */	
	public IElement getPolicy()
	{
		return this.elemPolicy;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityTokenResponse#getPolicyReference()
	 */
	public IElement getPolicyReference()
	{
		return this.elemPolicyReference;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityTokenResponse#getAnyOtherElements()
	 */
	public java.util.List getAnyOtherElements()
	{
		return this.listAnyOtherElements;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityTokenResponse#getData()
	 */
	public java.lang.Object getData()
	{
		return this.objectData;
	}
	
	public void setComputedKey
		(final java.net.URI uriComputedKey)
	{
		this.uriComputedKey = uriComputedKey;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityTokenResponse#setTokenType(org.eclipse.higgins.sts.IElement)
	 */
	public void setTokenType
		(final java.net.URI uriTokenType)
	{
		this.uriTokenType = uriTokenType;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityTokenResponse#setRequestedTokenCancelled(org.eclipse.higgins.sts.IElement)
	 */
	public void setRequestedTokenCancelled
		(final IElement elemRequestedTokenCancelled)
	{
		this.elemRequestedTokenCancelled = elemRequestedTokenCancelled;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityTokenResponse#setRequestedDisplayToken(org.eclipse.higgins.sts.IElement)
	 */
	public void setRequestedDisplayToken
		(final IDisplayToken dtRequestedDisplayToken)
	{
		this.dtRequestedDisplayToken = dtRequestedDisplayToken;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityTokenResponse#setRequestType(org.eclipse.higgins.sts.IElement)
	 */
	public void setRequestType
		(final java.net.URI uriRequestType)
	{
		this.uriRequestType = uriRequestType;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityTokenResponse#setRequestedSecurityToken(org.eclipse.higgins.sts.IElement)
	 */
	public void setRequestedSecurityToken
		(final IElement elemRequestedSecurityToken)
	{
		this.elemRequestedSecurityToken = elemRequestedSecurityToken;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityTokenResponse#setAppliesTo(org.eclipse.higgins.sts.IEndpointReference)
	 */
	public void setAppliesTo
		(final org.eclipse.higgins.sts.api.IEndpointReference eprAppliesTo)
	{
		this.eprAppliesTo = eprAppliesTo;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityTokenResponse#setRequestedAttachedReference(org.eclipse.higgins.sts.IElement)
	 */
	public void setRequestedAttachedReference
		(final IElement elemRequestedAttachedReference)
	{
		this.elemRequestedAttachedReference = elemRequestedAttachedReference;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityTokenResponse#setRequestedUnattachedReference(org.eclipse.higgins.sts.IElement)
	 */
	public void setRequestedUnattachedReference
		(final IElement elemRequestedUnattachedReference)
	{
		this.elemRequestedUnattachedReference = elemRequestedUnattachedReference;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityTokenResponse#setRequestedProofToken(org.eclipse.higgins.sts.IElement)
	 */
	public void setRequestedProofToken
		(final IElement elemRequestedProofToken)
	{
		this.elemRequestedProofToken = elemRequestedProofToken;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityTokenResponse#setEntropy(org.eclipse.higgins.sts.IElement)
	 */
	public void setEntropy
		(final IElement elemEntropy)
	{
		this.elemEntropy = elemEntropy;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityTokenResponse#setLifetime(org.eclipse.higgins.sts.ILifetime)
	 */
	public void setLifetime
		(final org.eclipse.higgins.sts.api.ILifetime ltLifetime)
	{
		this.ltLifetime = ltLifetime;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityTokenResponse#setStatus(org.eclipse.higgins.sts.IElement)
	 */
	public void setStatus
		(final IElement elemStatus)
	{
		this.elemStatus = elemStatus;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityTokenResponse#setAllowPostdating(org.eclipse.higgins.sts.IElement)
	 */
	public void setAllowPostdating
		(final IElement elemAllowPostdating)
	{
		this.elemAllowPostdating = elemAllowPostdating;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityTokenResponse#setRenewing(org.eclipse.higgins.sts.IElement)
	 */
	public void setRenewing
		(final IElement elemRenewing)
	{
		this.elemRenewing = elemRenewing;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityTokenResponse#setOnBehalfOf(org.eclipse.higgins.sts.IElement)
	 */
	public void setOnBehalfOf
		(final IElement elemOnBehalfOf)
	{
		this.elemOnBehalfOf = elemOnBehalfOf;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityTokenResponse#setIssuer(org.eclipse.higgins.sts.IEndpointReference)
	 */
	public void setIssuer
		(final org.eclipse.higgins.sts.api.IEndpointReference eprIssuer)
	{
		this.eprIssuer = eprIssuer;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityTokenResponse#setAuthenticationType(java.net.URI)
	 */
	public void setAuthenticationType
		(final java.net.URI uriAuthenticationType)
	{
		this.uriAuthenticationType = uriAuthenticationType;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityTokenResponse#setAuthenticator(org.eclipse.higgins.sts.IElement)
	 */
	public void setAuthenticator
		(final IElement elemAuthenticator)
	{
		this.elemAuthenticator = elemAuthenticator;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityTokenResponse#setKeyType(org.eclipse.higgins.sts.IElement)
	 */
	public void setKeyType
		(final java.net.URI uriKeyType)
	{
		this.uriKeyType = uriKeyType;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityTokenResponse#setKeySize(org.eclipse.higgins.sts.IElement)
	 */
	public void setKeySize
		(final int nKeySize)
	{
		this.intKeySize = new Integer(nKeySize);
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityTokenResponse#setSignatureAlgorithm(org.eclipse.higgins.sts.IElement)
	 */
	public void setSignatureAlgorithm
		(final java.net.URI uriSignatureAlgorithm)
	{
		this.uriSignatureAlgorithm = uriSignatureAlgorithm;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityTokenResponse#setEncryption(org.eclipse.higgins.sts.IElement)
	 */
	public void setEncryption
		(final IElement elemEncryption)
	{
		this.elemEncryption = elemEncryption;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityTokenResponse#setEncryptionAlgorithm(java.net.URI)
	 */
	public void setEncryptionAlgorithm
		(final java.net.URI uriEncryptionAlgorithm)
	{
		this.uriEncryptionAlgorithm = uriEncryptionAlgorithm;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityTokenResponse#setCanonicalizationAlgorithm(org.eclipse.higgins.sts.IElement)
	 */
	public void setCanonicalizationAlgorithm
		(final java.net.URI uriCanonicalizationAlgorithm)
	{
		this.uriCanonicalizationAlgorithm = uriCanonicalizationAlgorithm;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityTokenResponse#setProofEncryption(org.eclipse.higgins.sts.IElement)
	 */
	public void setProofEncryption
		(final IElement elemProofEncryption)
	{
		this.elemProofEncryption = elemProofEncryption;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityTokenResponse#setUseKey(org.eclipse.higgins.sts.IElement)
	 */
	public void setUseKey
		(final IElement elemUseKey)
	{
		this.elemUseKey = elemUseKey;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityTokenResponse#setSignWith(java.net.URI)
	 */
	public void setSignWith
		(final java.net.URI uriSignWith)
	{
		this.uriSignWith = uriSignWith;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityTokenResponse#setEncryptWith(org.eclipse.higgins.sts.IElement)
	 */
	public void setEncryptWith
		(final java.net.URI uriEncryptWith)
	{
		this.uriEncryptWith = uriEncryptWith;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityTokenResponse#setDelegateTo(org.eclipse.higgins.sts.IElement)
	 */
	public void setDelegateTo
		(final IElement elemDelegateTo)
	{
		this.elemDelegateTo = elemDelegateTo;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityTokenResponse#setForwardable(org.eclipse.higgins.sts.IElement)
	 */
	public void setForwardable
		(final boolean bForwardable)
	{
		this.boolForwardable = new java.lang.Boolean(bForwardable);
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityTokenResponse#setDelegatable(org.eclipse.higgins.sts.IElement)
	 */
	public void setDelegatable
		(final boolean bDelegatable)
	{
		this.boolDelegatable = new Boolean(bDelegatable);
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityTokenResponse#setPolicy(org.eclipse.higgins.sts.IElement)
	 */
	public void setPolicy
		(final IElement elemPolicy)
	{
		this.elemPolicy = elemPolicy;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityTokenResponse#setPolicyReference(org.eclipse.higgins.sts.IElement)
	 */
	public void setPolicyReference
		(final IElement elemPolicyReference)
	{
		this.elemPolicyReference = elemPolicyReference;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityTokenResponse#setContext(String)
	 */
	public void setContext
		(final String strContext)
	{
		this.strContext = strContext;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IRequestSecurityTokenResponse#setData(java.lang.Object)
	 */
	public void setData
		(final java.lang.Object objectData)
	{
		this.objectData = objectData;
	}
}
