/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Michael McIntosh (IBM Corporation) - initial API and implementation
 *******************************************************************************/ 

package org.eclipse.higgins.sts.utilities;

import org.eclipse.higgins.messages.utilities.MsgHelper;

/**
 * Used to help format exception details into log output.
 * 
 * @author mikemci at us dot ibm dot com
 *
 */
public class ExceptionHelper
{
	public static void Log
		(final LogHelper log,
		final Exception exception)
	{
		/*
		 * if (exception instanceof AxisFault)
		{
			log.error("AxisFault Cause is:");
			AxisFault outer = (AxisFault)exception;
			Throwable nested = outer.getCause();
			Log(log, nested);
		}		
		else */
		if (exception instanceof java.lang.reflect.InvocationTargetException)
		{
			final java.lang.reflect.InvocationTargetException outer = (java.lang.reflect.InvocationTargetException)exception;
			final Throwable nested = outer.getCause();
			
			String errMsg = MsgHelper.getString(MsgHelper.invocationtargetexception_cause, nested);
			log.error(errMsg);
			
			ExceptionHelper.Log(log, nested);
		}
		else
		{
			final String strMessage = exception.getLocalizedMessage();
			if (null != strMessage)
			{
				String errMsg = MsgHelper.getString(MsgHelper.request_failed_with_exception, strMessage);
				log.error(errMsg);
			}
			log.error(exception);
			final StackTraceElement [] ste = exception.getStackTrace();
			for (int i = 0; i < ste.length; ++i)
			{
				String strLine = MsgHelper.getString(MsgHelper.stacktraceelement_format_msg,
						ste[i].getClassName(), ste[i].getMethodName(), ste[i].getFileName(), String.valueOf(ste[i].getLineNumber()));

				log.error
					(strLine);
			}			
		}
	}
	public static void Log
		(final LogHelper log,
		final java.lang.Throwable throwable)
	{
		if (null == throwable)
		{
			String errMsg = MsgHelper.getString(MsgHelper.log_throwable_is_null);
			log.error(errMsg);
		}
		else 
		/*	if (throwable instanceof AxisFault)
		{
			log.error("AxisFault Cause is:");
			AxisFault outer = (AxisFault)throwable;
			Throwable nested = outer.getCause();
			Log(log, nested);
		}		
		else */
		if (throwable instanceof java.lang.reflect.InvocationTargetException)
		{
			final java.lang.reflect.InvocationTargetException outer = (java.lang.reflect.InvocationTargetException)throwable;
			final Throwable nested = outer.getCause();
			
			String errMsg = MsgHelper.getString(MsgHelper.invocationtargetexception_cause, nested);
			log.error(errMsg);
			
			ExceptionHelper.Log(log, nested);
		
		}
		else
		{
			final String strMessage = throwable.getLocalizedMessage();
			if (null != strMessage)
			{
				log.error(strMessage);
			}
			String errMsg = MsgHelper.getString(MsgHelper.request_failed_with_exception, throwable);
			log.error(errMsg);
			
			final StackTraceElement [] ste = throwable.getStackTrace();
			for (int i = 0; i < ste.length; ++i)
			{
				final String strLine = ste[i].getClassName()
					+ "::" + ste[i].getMethodName()
					+ " " + ste[i].getFileName()
					+ ":" + ste[i].getLineNumber();
				log.error
					(strLine);
			}			
		}
	}
}
