/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.sts.utilities;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.RSAKeyGenParameterSpec;
import java.util.Hashtable;
import java.util.Map;
import javax.security.auth.x500.X500Principal;
import org.eclipse.higgins.sts.spi.IBase64Extension;
import org.eclipse.higgins.sts.utilities.X931KeyGenerator;
import org.eclipse.higgins.sts.utilities.XMLHelper;

public class KeyGenHelper {
    private static String[] pseudo = new String[]{"Q", "L", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F", "G", "H", "J", "K", "M", "N", "P", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"};

    static String byteArrayToHexString(byte[] in) {
        byte ch = 0;
        if (in == null || in.length <= 0) {
            return null;
        }
        String[] pseudo = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F"};
        StringBuffer out = new StringBuffer(in.length * 2);
        out.append("(");
        for (int i = 0; i < in.length; ++i) {
            if (i != 0) {
                out.append(", ");
            }
            out.append("(byte)0x");
            ch = (byte)(in[i] & 0xF0);
            ch = (byte)(ch >>> 4);
            ch = (byte)(ch & 0xF);
            out.append(pseudo[ch]);
            ch = (byte)(in[i] & 0xF);
            out.append(pseudo[ch]);
        }
        out.append(")");
        String rslt = new String(out);
        return rslt;
    }

    public static String ppidToFriendly(byte[] ppid) throws Exception {
        System.out.println("PPID Bytes: " + KeyGenHelper.byteArrayToHexString(ppid));
        MessageDigest mdSha1 = MessageDigest.getInstance("SHA-1");
        byte[] hashId = mdSha1.digest(ppid);
        System.out.println("HashId Bytes: " + KeyGenHelper.byteArrayToHexString(hashId));
        StringBuffer out = new StringBuffer(12);
        byte[] byteNum = new byte[1];
        BigInteger bi32 = new BigInteger("32");
        for (int i = 0; i < 10; ++i) {
            byteNum[0] = hashId[i];
            BigInteger value = new BigInteger(1, byteNum);
            value = value.mod(bi32);
            if (3 == i || 7 == i) {
                out.append("-");
            }
            out.append(pseudo[value.intValue()]);
        }
        return new String(out);
    }

    public static Map getOrganizationalIdentifierAttributes(X509Certificate cert) {
        X500Principal principal = cert.getSubjectX500Principal();
        String strName = principal.getName("RFC1779");
        System.out.println("Name: " + strName);
        Hashtable<String, String> mapDNAttributes = new Hashtable<String, String>();
        StringBuffer sbDistinguishedName = new StringBuffer(strName);
        StringBuffer sbAttributeName = new StringBuffer();
        StringBuffer sbAttributeValue = new StringBuffer();
        boolean bReadingAttributeName = true;
        boolean bReadingAttributeValue = false;
        boolean bInsideDoubleQuotes = false;
        int nDNLength = sbDistinguishedName.length();
        for (int nDNIndex = 0; nDNIndex < nDNLength; ++nDNIndex) {
            if (bReadingAttributeName) {
                if (' ' == sbDistinguishedName.charAt(nDNIndex)) continue;
                sbAttributeName.append(sbDistinguishedName.charAt(nDNIndex));
                if ('=' == sbDistinguishedName.charAt(nDNIndex + 1)) {
                    ++nDNIndex;
                    bReadingAttributeName = false;
                    bReadingAttributeValue = true;
                    continue;
                }
            }
            if (!bReadingAttributeValue) continue;
            if ('\"' == sbDistinguishedName.charAt(nDNIndex)) {
                if (bInsideDoubleQuotes) {
                    bInsideDoubleQuotes = false;
                    continue;
                }
                bInsideDoubleQuotes = true;
                continue;
            }
            if (',' == sbDistinguishedName.charAt(nDNIndex)) {
                if (!bInsideDoubleQuotes) {
                    ++nDNIndex;
                    bReadingAttributeName = true;
                    bReadingAttributeValue = false;
                    System.out.println("Adding Attribute: " + sbAttributeName + " Value: " + sbAttributeValue);
                    mapDNAttributes.put(sbAttributeName.toString(), sbAttributeValue.toString());
                    sbAttributeName = new StringBuffer();
                    sbAttributeValue = new StringBuffer();
                    continue;
                }
                sbAttributeValue.append(sbDistinguishedName.charAt(nDNIndex));
                continue;
            }
            sbAttributeValue.append(sbDistinguishedName.charAt(nDNIndex));
        }
        if (0 < sbAttributeName.length()) {
            System.out.println("Adding Attribute: " + sbAttributeName + " Value: " + sbAttributeValue);
            mapDNAttributes.put(sbAttributeName.toString(), sbAttributeValue.toString());
        }
        return mapDNAttributes;
    }

    public static String getOrgIdString(Map mapOrgIdAttributes) {
        String strValue = (String)mapOrgIdAttributes.get("O");
        if (null == strValue) {
            strValue = "";
        }
        String strResult = "|O=\"" + strValue + "\"";
        strValue = (String)mapOrgIdAttributes.get("L");
        if (null == strValue) {
            strValue = "";
        }
        strResult = strResult + "|L=\"" + strValue + "\"";
        strValue = (String)mapOrgIdAttributes.get("S");
        if (null == strValue) {
            strValue = "";
        }
        strResult = strResult + "|S=\"" + strValue + "\"";
        strValue = (String)mapOrgIdAttributes.get("C");
        if (null == strValue) {
            strValue = "";
        }
        strResult = strResult + "|C=\"" + strValue + "\"|";
        System.out.println("OrgIdString: " + strResult);
        return strResult;
    }

    public static byte[] generateRPIdentifier(X509Certificate[] chain) throws Exception {
        X509Certificate cert = chain[0];
        MessageDigest mdSha256 = MessageDigest.getInstance("SHA-256");
        Map mapOIAs = KeyGenHelper.getOrganizationalIdentifierAttributes(cert);
        if (0 == mapOIAs.size()) {
            PublicKey pk = cert.getPublicKey();
            RSAPublicKey rsaPk = (RSAPublicKey)pk;
            byte[] publicKey = rsaPk.getEncoded();
            ByteBuffer bbPk = ByteBuffer.allocate(publicKey.length - 22);
            bbPk.put(publicKey, 22, publicKey.length - 22);
            return mdSha256.digest(bbPk.array());
        }
        String strOrgIdString = "|ChainElement=\"CN=Entrust.net Secure Server Certification Authority, OU=(c) 1999 Entrust.net Limited, OU=www.entrust.net/CPS incorp. by ref. (limits liab.), O=Entrust.net, C=US\"|ChainElement=\"CN=DigiCert Global CA, OU=www.digicert.com, O=DigiCert Inc, C=US\"";
        strOrgIdString.concat(KeyGenHelper.getOrgIdString(mapOIAs));
        return mdSha256.digest(strOrgIdString.getBytes("UTF-16LE"));
    }

    static void copyByteBuffer(ByteBuffer bbSource, int nSourceOffset, byte[] bDestination, int nDestinationOffset, int numberOfBytes) {
        int nDestination = nDestinationOffset;
        for (int nSource = nSourceOffset; nSource < numberOfBytes + nSourceOffset; ++nSource) {
            bDestination[nDestination++] = bbSource.get(nSource);
        }
    }

    public static KeyPair generateRSAKeyPair(IBase64Extension base64, byte[] masterKey, byte[] relyingPartyIdentifier, int nKeyBitLength) throws Exception {
        int nRounds = 0;
        int nRoundInputByteLength = relyingPartyIdentifier.length + relyingPartyIdentifier.length + 4;
        if (1024 == nKeyBitLength) {
            nRounds = 10;
        } else if (2048 == nKeyBitLength) {
            nRounds = 16;
        } else {
            throw new Exception("Invalid Key Size Requested");
        }
        System.out.println("Section 8.4.1 Step 2 Processing...");
        ByteBuffer[] bbH = new ByteBuffer[nRounds];
        for (int i = 0; i < nRounds; ++i) {
            ByteBuffer bbInput = ByteBuffer.allocate(nRoundInputByteLength);
            bbInput.put(masterKey);
            bbInput.put(relyingPartyIdentifier);
            bbInput.putInt(i);
            MessageDigest mdSha1 = MessageDigest.getInstance("SHA-1");
            byte[] Hn = mdSha1.digest(bbInput.array());
            bbH[i] = ByteBuffer.allocate(Hn.length);
            bbH[i].put(Hn);
            System.out.println("H[" + i + "] " + KeyGenHelper.byteArrayToHexString(bbH[i].array()));
        }
        System.out.println("Section 8.4.1 Step 3 Processing...");
        byte[] Xp1 = new byte[14];
        KeyGenHelper.copyByteBuffer(bbH[0], 6, Xp1, 0, 14);
        System.out.println("Xp1 " + KeyGenHelper.byteArrayToHexString(Xp1));
        byte[] Xp2 = new byte[14];
        KeyGenHelper.copyByteBuffer(bbH[1], 6, Xp2, 0, 14);
        System.out.println("Xp2 " + KeyGenHelper.byteArrayToHexString(Xp2));
        byte[] Xq1 = new byte[14];
        KeyGenHelper.copyByteBuffer(bbH[2], 6, Xq1, 0, 14);
        System.out.println("Xq1 " + KeyGenHelper.byteArrayToHexString(Xq1));
        byte[] Xq2 = new byte[14];
        KeyGenHelper.copyByteBuffer(bbH[3], 6, Xq2, 0, 14);
        System.out.println("Xq2 " + KeyGenHelper.byteArrayToHexString(Xq2));
        byte[] Xp = null;
        byte[] Xq = null;
        if (1024 == nKeyBitLength) {
            Xp = new byte[64];
            KeyGenHelper.copyByteBuffer(bbH[4], 0, Xp, 0, 20);
            KeyGenHelper.copyByteBuffer(bbH[5], 0, Xp, 20, 20);
            KeyGenHelper.copyByteBuffer(bbH[6], 0, Xp, 40, 20);
            KeyGenHelper.copyByteBuffer(bbH[0], 0, Xp, 60, 4);
            Xq = new byte[64];
            KeyGenHelper.copyByteBuffer(bbH[7], 0, Xq, 0, 20);
            KeyGenHelper.copyByteBuffer(bbH[8], 0, Xq, 20, 20);
            KeyGenHelper.copyByteBuffer(bbH[9], 0, Xq, 40, 20);
            KeyGenHelper.copyByteBuffer(bbH[1], 0, Xq, 60, 4);
        } else {
            Xp = new byte[128];
            KeyGenHelper.copyByteBuffer(bbH[4], 0, Xp, 0, 20);
            KeyGenHelper.copyByteBuffer(bbH[5], 0, Xp, 20, 20);
            KeyGenHelper.copyByteBuffer(bbH[6], 0, Xp, 40, 20);
            KeyGenHelper.copyByteBuffer(bbH[0], 0, Xp, 60, 4);
            KeyGenHelper.copyByteBuffer(bbH[10], 0, Xp, 64, 20);
            KeyGenHelper.copyByteBuffer(bbH[11], 0, Xp, 84, 20);
            KeyGenHelper.copyByteBuffer(bbH[12], 0, Xp, 104, 20);
            KeyGenHelper.copyByteBuffer(bbH[2], 0, Xp, 124, 4);
            Xq = new byte[128];
            KeyGenHelper.copyByteBuffer(bbH[7], 0, Xq, 0, 20);
            KeyGenHelper.copyByteBuffer(bbH[8], 0, Xq, 20, 20);
            KeyGenHelper.copyByteBuffer(bbH[9], 0, Xq, 40, 20);
            KeyGenHelper.copyByteBuffer(bbH[1], 0, Xq, 60, 4);
            KeyGenHelper.copyByteBuffer(bbH[13], 0, Xq, 64, 20);
            KeyGenHelper.copyByteBuffer(bbH[14], 0, Xq, 84, 20);
            KeyGenHelper.copyByteBuffer(bbH[15], 0, Xq, 104, 20);
            KeyGenHelper.copyByteBuffer(bbH[3], 0, Xq, 124, 4);
        }
        System.out.println("Xp " + KeyGenHelper.byteArrayToHexString(Xp));
        System.out.println("Xq " + KeyGenHelper.byteArrayToHexString(Xq));
        System.out.println("Section 8.4.1 Step 4 Processing...");
        Xp1[1] = (byte)(Xp1[1] | 0x10);
        Xp2[1] = (byte)(Xp2[1] | 0x10);
        Xq1[1] = (byte)(Xq1[1] | 0x10);
        Xq2[1] = (byte)(Xq2[1] | 0x10);
        System.out.println("Xp1 " + KeyGenHelper.byteArrayToHexString(Xp1));
        System.out.println("Xp2 " + KeyGenHelper.byteArrayToHexString(Xp2));
        System.out.println("Xq1 " + KeyGenHelper.byteArrayToHexString(Xq1));
        System.out.println("Xq2 " + KeyGenHelper.byteArrayToHexString(Xq2));
        System.out.println("Section 8.4.1 Step 5 Processing...");
        Xp[0] = (byte)(Xp[0] | 0xC0);
        Xq[0] = (byte)(Xq[0] | 0xC0);
        System.out.println("Xp " + KeyGenHelper.byteArrayToHexString(Xp));
        System.out.println("Xq " + KeyGenHelper.byteArrayToHexString(Xq));
        System.out.println("Section 8.4.1 Step 6 Processing...");
        X931KeyGenerator kpg = new X931KeyGenerator(Xp1, Xp2, Xq1, Xq2, Xp, Xq);
        RSAKeyGenParameterSpec kpgParams = new RSAKeyGenParameterSpec(2048, RSAKeyGenParameterSpec.F4);
        KeyPair kp = kpg.GenerateKeyPair(kpgParams);
        RSAPublicKey rsaPublicKey = (RSAPublicKey)kp.getPublic();
        BigInteger biModulus = rsaPublicKey.getModulus();
        String strModulus = base64.encode(biModulus);
        strModulus = XMLHelper.stripNewLinesFromString(strModulus);
        BigInteger biExponent = rsaPublicKey.getPublicExponent();
        String strExponent = base64.encode(biExponent);
        strExponent = XMLHelper.stripNewLinesFromString(strExponent);
        System.out.println("Modulus: " + strModulus);
        System.out.println("Exponent: " + strExponent);
        return kp;
    }
}

