/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Michael McIntosh (IBM Corporation) - initial API and implementation
 *******************************************************************************/ 

package org.eclipse.higgins.sts.utilities;

/**
 * Class to help read property values 
 * 
 * @author mikemci at us dot ibm dot com
 */
public class PropertyHelper
{
	private final org.eclipse.higgins.sts.utilities.LogHelper log = new org.eclipse.higgins.sts.utilities.LogHelper
		(PropertyHelper.class.getName());

	/**
	 * The stream for reading the properties file
	 */
	private java.io.FileInputStream configPropertiesStream = null;

	/**
	 * The Properties object
	 */
	private final java.util.Properties configProperties = new java.util.Properties();

	/**
	 * Constructor for the class
	 * 
	 * @param propertiesFile the name of the properties file
	 */
	public PropertyHelper
		(final String propertiesFile)
	{
		try
		{
			this.configPropertiesStream = new java.io.FileInputStream
				(propertiesFile);			
		}
		catch (final java.io.FileNotFoundException fnfe)
		{
    		org.eclipse.higgins.sts.utilities.ExceptionHelper.Log
				(this.log,
				fnfe);
    	}
		try
		{
			this.configProperties.load
				(this.configPropertiesStream);		
		}
		catch (final java.io.IOException ioe)
		{
    		org.eclipse.higgins.sts.utilities.ExceptionHelper.Log
				(this.log,
				ioe);
    	}
	}
	
	/**
	 * Provides access to a specific property value
	 * 
	 * @param key the key associated with the value
	 * @return the value associated with the key (or null if none)
	 */
	public String getProperty
		(final String key)
	{
		return this.configProperties.getProperty
			(key);
	}		
}
