/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Michael McIntosh (IBM Corporation) - initial API and implementation
 *******************************************************************************/ 

package org.eclipse.higgins.sts.server.mapper.extension;

import java.util.Map;

import org.eclipse.higgins.configuration.api.ISettingDescriptor;
import org.eclipse.higgins.configuration.common.SettingDescriptor;
import org.eclipse.higgins.configuration.xml.ISettingHandler;
import org.eclipse.higgins.messages.utilities.MsgHelper;

/**
 * @author mikemci
 *
 */
public class ExtensionMapHandler implements ISettingHandler
{
	private final org.eclipse.higgins.sts.utilities.LogHelper log = new org.eclipse.higgins.sts.utilities.LogHelper
		(ExtensionMapHandler.class.getName());
	
	private final javax.xml.namespace.QName qnameName = new javax.xml.namespace.QName
		(null,
		"Name");
	private final javax.xml.namespace.QName qnameType = new javax.xml.namespace.QName
		(null,
		"Type");

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.binding.axis1x.configuration.ISettingHandler#getSetting(java.lang.String, java.util.Map, java.util.Map, org.w3c.dom.Element)
	 */
	public Object getSetting
		(String strName,
		String strConfigurationBase,
		java.util.Map mapSettingHandlers,
		java.util.Map mapSettingsGlobal,
		Object settingsParent,
		ISettingDescriptor globalDescriptor,
		ISettingDescriptor settingDescriptor,
		org.apache.axiom.om.OMElement omSetting)
		throws Exception
	{	
		this.log.trace("Setting Name: " + strName + " *Begin ExtensionMap*");
		final ISettingHandler handlerMap = (ISettingHandler)mapSettingHandlers.get
			("htf:map");
		if (null == handlerMap)
		{
			String errMsg = MsgHelper.getString(MsgHelper.settinghandler_not_found_for_type, "htf:map");
			this.log.error(errMsg);
			throw new Exception(errMsg);
		}
		final Map mapResult = new java.util.Hashtable();
		final java.util.Iterator iterChildren = omSetting.getChildElements();
		while (iterChildren.hasNext())
		{
			final org.apache.axiom.om.OMElement omChild = (org.apache.axiom.om.OMElement)iterChildren.next();
			final String strSettingName = omChild.getAttributeValue(this.qnameName);
			final String strSettingType = omChild.getAttributeValue(this.qnameType);
			final ISettingDescriptor childDescriptor = new SettingDescriptor(strSettingName, strSettingType);
			final Object objectValue = handlerMap.getSetting
				(strSettingName,
				strConfigurationBase,
				mapSettingHandlers,
				mapSettingsGlobal,
				omSetting,
				globalDescriptor,
				childDescriptor,
				omChild);
			final Map mapValue = (Map)objectValue;
			final Object objectExtensionMapKey = mapValue.get("ExtensionMapKey");
			final Object objectExtensionName = mapValue.get("ExtensionName");
			mapResult.put(objectExtensionMapKey, objectExtensionName);
		}
		this.log.trace("Setting Name: " + strName + " *End ExtensionMap*");
		return mapResult;
	}
}
