/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Michael McIntosh (IBM Corporation) - initial API and implementation
 *******************************************************************************/ 

package org.eclipse.higgins.sts.server.metadata;


/**
 * Implements the IConfigurableComponentFactory that creates the MetadataExchangeService implementation.
 * 
 * @author mikemci at us dot ibm dot com
 */
public class MetadataExchangeServiceFactory
	implements org.eclipse.higgins.configuration.api.IConfigurableComponentFactory
{
	private final org.eclipse.higgins.sts.utilities.LogHelper log = new org.eclipse.higgins.sts.utilities.LogHelper
		(MetadataExchangeServiceFactory.class.getName());

	/**
	 * The singleton instance
	 */
	private static MetadataExchangeService theInstance = null;

	/**
	 * Provides access to the singleton instance
	 * 
	 * @return the singleton instance
	 */
	public org.eclipse.higgins.configuration.api.IConfigurableComponent getSingletonInstance()
	{
		if (null == MetadataExchangeServiceFactory.theInstance)
		{
			try
			{
				MetadataExchangeServiceFactory.theInstance = new MetadataExchangeService();
			}
			catch (final Exception e)
			{
	    		org.eclipse.higgins.sts.utilities.ExceptionHelper.Log
					(this.log,
					e);	
	    		return null;
    		}
		}
		return MetadataExchangeServiceFactory.theInstance;
	}
	
	/**
	 * Provides access to the new instance
	 * 
	 * @return the new instance
	 */
	public org.eclipse.higgins.configuration.api.IConfigurableComponent getNewInstance()
	{
		try
		{
			return new MetadataExchangeService();
		}
		catch (final Exception e)
		{
    		org.eclipse.higgins.sts.utilities.ExceptionHelper.Log
				(this.log,
				e);	
		}	
		return null;
	}
}

